/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.lib.fcommons.config.mapped;

import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.ConfigErrors;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.ConfigPath;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.ConfigSection;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.ConfigValue;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.exception.ConfigMappingException;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.exception.ConfigValidateException;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.mapped.ConverterRegistry;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.mapped.Path;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.mapped.converter.Converter;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.mapped.modifier.ChatColorsModifier;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.mapped.modifier.FieldValueModifier;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.reflection.ReflectField;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.reflection.TypeInfo;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.reflection.UnexpectedActualClassException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MappedField<T> {
    private static final List<FieldValueModifier<?, ?>> VALUE_MODIFIERS = ImmutableList.of((Object)new ChatColorsModifier());
    private final ReflectField<T> field;
    private final Converter<T, ?> converter;
    private final ConfigPath configPath;
    private final List<Annotation> annotations;

    public MappedField(ReflectField<T> field) throws ReflectiveOperationException, ConfigMappingException {
        this.field = field;
        this.converter = ConverterRegistry.fromObjectType(this.getFieldTypeInfo(field));
        this.configPath = field.isAnnotationPresent(Path.class) ? ConfigPath.dotDelimited(field.getAnnotation(Path.class).value()) : ConfigPath.delimitedBy(field.getName(), "__").replace("_", "-");
        this.annotations = Stream.concat(Arrays.stream(field.getAnnotations()), Arrays.stream(field.getDeclaringClass().getDeclaredAnnotations())).collect(Collectors.toList());
    }

    private TypeInfo<T> getFieldTypeInfo(ReflectField<T> field) throws ReflectiveOperationException {
        TypeInfo<T> typeInfo = TypeInfo.of(field);
        if (typeInfo.getTypeClass() == field.getExpectedClass()) {
            return typeInfo;
        }
        throw new UnexpectedActualClassException("actual field type \"" + typeInfo + "\" doesn't have expected class \"" + field.getExpectedClass() + "\"");
    }

    public boolean equalsConfigValue(@NotNull Object mappedObject, @NotNull ConfigSection config) throws ConfigMappingException {
        T fieldValue = this.readFromObject(mappedObject);
        ConfigValue configValue = config.get(this.configPath);
        return this.converter.equalsConfig(fieldValue, configValue);
    }

    @NotNull
    public ConfigValue readConfigValueFromObject(@NotNull Object mappedObject) throws ConfigMappingException {
        try {
            T fieldValue = this.readFromObject(mappedObject);
            if (fieldValue != null) {
                return this.converter.toConfigValue(fieldValue);
            }
            return ConfigValue.NULL;
        }
        catch (ConfigMappingException e) {
            throw new ConfigMappingException(ConfigErrors.conversionFailed(this), e);
        }
    }

    public void setFieldValueFromConfig(@NotNull Object mappedObject, @NotNull ConfigSection config) throws ConfigMappingException, ConfigValidateException {
        ConfigValue configValue = config.get(this.configPath);
        try {
            T fieldValue = this.converter.toFieldValue(configValue);
            if (fieldValue == null) {
                return;
            }
            for (Annotation annotation : this.annotations) {
                fieldValue = this.applyFieldValueModifiers(fieldValue, annotation);
            }
            this.writeToObject(mappedObject, fieldValue);
        }
        catch (ConfigMappingException e) {
            throw new ConfigMappingException(ConfigErrors.conversionFailed(this), e);
        }
    }

    @Nullable
    private T readFromObject(@NotNull Object mappedObject) throws ConfigMappingException {
        try {
            return this.field.get(mappedObject);
        }
        catch (ReflectiveOperationException e) {
            throw new ConfigMappingException(ConfigErrors.fieldReadError(this), e);
        }
    }

    private void writeToObject(@NotNull Object mappedObject, @Nullable T fieldValue) throws ConfigMappingException {
        try {
            this.field.set(mappedObject, fieldValue);
        }
        catch (ReflectiveOperationException e) {
            throw new ConfigMappingException(ConfigErrors.fieldWriteError(this), e);
        }
    }

    private <F, A extends Annotation> F applyFieldValueModifiers(@NotNull F fieldValue, @NotNull A annotation) {
        for (FieldValueModifier<?, ?> modifier : VALUE_MODIFIERS) {
            if (!modifier.isApplicable(annotation, fieldValue)) continue;
            fieldValue = modifier.transform(annotation, fieldValue);
        }
        return fieldValue;
    }

    public String getFieldName() {
        return this.field.getName();
    }

    public Class<?> getDeclaringClass() {
        return this.field.getDeclaringClass();
    }

    public ConfigPath getConfigPath() {
        return this.configPath;
    }
}

