/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.lib.fcommons.config.mapped.converter;

import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.ConfigType;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.ConfigValue;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.exception.ConfigMappingException;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.exception.ConfigValidateException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Converter<F, C> {
    private final ConfigType<C> configType;

    protected Converter(ConfigType<C> configType) {
        this.configType = configType;
    }

    protected final boolean isValidConfigValue(@NotNull ConfigValue configValue) {
        return configValue.isPresentAs(this.configType);
    }

    @NotNull
    public final ConfigValue toConfigValue(@NotNull F fieldValue) throws ConfigMappingException {
        C configValue = this.toConfigValue0(fieldValue);
        return ConfigValue.of(this.configType, configValue);
    }

    @NotNull
    protected abstract C toConfigValue0(@NotNull F var1) throws ConfigMappingException;

    @Nullable
    public final F toFieldValue(@NotNull ConfigValue wrappedConfigValue) throws ConfigMappingException, ConfigValidateException {
        C configValue = wrappedConfigValue.as(this.configType);
        if (configValue != null) {
            return this.toFieldValue0(configValue);
        }
        return null;
    }

    @NotNull
    protected abstract F toFieldValue0(@NotNull C var1) throws ConfigMappingException, ConfigValidateException;

    public final boolean equalsConfig(@Nullable F fieldValue, @NotNull ConfigValue wrappedConfigValue) throws ConfigMappingException {
        C configValue = wrappedConfigValue.as(this.configType);
        if (fieldValue == null && configValue == null) {
            return true;
        }
        if (fieldValue == null || configValue == null) {
            return false;
        }
        return this.equalsConfig0(fieldValue, configValue);
    }

    protected abstract boolean equalsConfig0(@NotNull F var1, @NotNull C var2) throws ConfigMappingException;
}

