/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.lib.fcommons.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.Preconditions;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.reflection.ReflectField;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.reflection.ReflectUtils;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.reflection.TypeWithoutClassException;
import org.jetbrains.annotations.Nullable;

public class TypeInfo<T> {
    private final Type type;
    private final Class<T> typeClass;
    private final Type[] typeArguments;

    private TypeInfo(Type type, Class<T> typeClass, Type[] typeArguments) {
        Preconditions.notNull(type, "type");
        this.type = type;
        this.typeClass = typeClass;
        this.typeArguments = typeArguments;
    }

    public Type getType() {
        return this.type;
    }

    @Nullable
    public Class<T> getTypeClass() {
        return this.typeClass;
    }

    @Nullable
    public Type[] getTypeArguments() {
        return this.typeArguments;
    }

    public ReflectField<?>[] getDeclaredFields() throws ReflectiveOperationException {
        Field[] declaredFields;
        if (this.typeClass == null) {
            throw new TypeWithoutClassException("cannot read fields of type without class: " + this.type);
        }
        try {
            declaredFields = this.typeClass.getDeclaredFields();
        }
        catch (Throwable t) {
            throw new ReflectiveOperationException(t);
        }
        ReflectField[] output = new ReflectField[declaredFields.length];
        for (int i = 0; i < declaredFields.length; ++i) {
            output[i] = ReflectField.wrap(declaredFields[i]);
        }
        return output;
    }

    public T newInstance() throws ReflectiveOperationException {
        if (this.typeClass == null) {
            throw new TypeWithoutClassException("cannot create instance of type without class: " + this.type);
        }
        try {
            Constructor<T> constructor = this.typeClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ReflectiveOperationException(t);
        }
    }

    public String toString() {
        return this.type.toString();
    }

    public static TypeInfo<?> of(ReflectField<?> reflectField) throws ReflectiveOperationException {
        Preconditions.notNull(reflectField, "reflectField");
        return TypeInfo.of(reflectField.getRawField());
    }

    public static TypeInfo<?> of(Field field) throws ReflectiveOperationException {
        Type genericType;
        Preconditions.notNull(field, "field");
        try {
            genericType = field.getGenericType();
        }
        catch (Throwable t) {
            throw new ReflectiveOperationException(t);
        }
        return TypeInfo.of(genericType);
    }

    public static <T> TypeInfo<T> of(Class<T> typeClass) {
        return new TypeInfo<T>(typeClass, typeClass, null);
    }

    public static TypeInfo<?> of(Type type) throws ReflectiveOperationException {
        Type[] typeArguments;
        try {
            typeArguments = type instanceof ParameterizedType ? ((ParameterizedType)type).getActualTypeArguments() : null;
        }
        catch (Throwable t) {
            throw new ReflectiveOperationException(t);
        }
        return new TypeInfo(type, ReflectUtils.getClassFromType(type), typeArguments);
    }
}

