/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.lib.nbt;

import java.util.Arrays;
import me.filoghost.holographicdisplays.plugin.lib.nbt.NBTTag;
import me.filoghost.holographicdisplays.plugin.lib.nbt.NBTType;

public final class NBTByteArray
extends NBTTag {
    private final byte[] value;

    public NBTByteArray(byte[] value) {
        this.value = value;
    }

    public NBTByteArray(Number[] numbers) {
        this.value = new byte[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            this.value[i] = numbers[i].byteValue();
        }
    }

    public int length() {
        return this.value.length;
    }

    public byte[] getValue() {
        return this.value;
    }

    @Override
    public NBTType getType() {
        return NBTType.BYTE_ARRAY;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof NBTByteArray && this.equals((NBTByteArray)obj);
    }

    public boolean equals(NBTByteArray tag) {
        return Arrays.equals(this.value, tag.value);
    }

    @Override
    public String toMSONString() {
        StringBuilder stringbuilder = new StringBuilder("[B;");
        for (int i = 0; i < this.value.length; ++i) {
            if (i != 0) {
                stringbuilder.append(',');
            }
            stringbuilder.append(this.value[i]).append('B');
        }
        return stringbuilder.append(']').toString();
    }
}

