/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.lib.nbt;

import java.util.Arrays;
import me.filoghost.holographicdisplays.plugin.lib.nbt.NBTTag;
import me.filoghost.holographicdisplays.plugin.lib.nbt.NBTType;

public final class NBTLongArray
extends NBTTag {
    private final long[] value;

    public NBTLongArray(long ... value) {
        this.value = value;
    }

    public NBTLongArray(Number[] numbers) {
        this.value = new long[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            this.value[i] = numbers[i].longValue();
        }
    }

    public int length() {
        return this.value.length;
    }

    public long[] getValue() {
        return this.value;
    }

    @Override
    public NBTType getType() {
        return NBTType.LONG_ARRAY;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof NBTLongArray && this.equals((NBTLongArray)obj);
    }

    public boolean equals(NBTLongArray tag) {
        return Arrays.equals(this.value, tag.value);
    }

    @Override
    public String toMSONString() {
        StringBuilder stringbuilder = new StringBuilder("[I;");
        for (int i = 0; i < this.value.length; ++i) {
            if (i != 0) {
                stringbuilder.append(',');
            }
            stringbuilder.append(this.value[i]);
        }
        return stringbuilder.append(']').toString();
    }
}

