/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.lib.updater;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import me.filoghost.holographicdisplays.plugin.lib.updater.InvalidVersionException;
import me.filoghost.holographicdisplays.plugin.lib.updater.PluginVersion;
import me.filoghost.holographicdisplays.plugin.lib.updater.ResponseHandler;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public final class UpdateChecker {
    public static void run(Plugin plugin, int projectId, ResponseHandler responseHandler) {
        if (plugin == null) {
            throw new NullPointerException("Plugin cannot be null");
        }
        if (responseHandler == null) {
            throw new NullPointerException("ResponseHandler cannot be null");
        }
        Bukkit.getScheduler().runTaskAsynchronously(plugin, () -> {
            try {
                PluginVersion localVersion;
                JSONArray filesArray = (JSONArray)UpdateChecker.readJson("https://api.curseforge.com/servermods/files?projectIds=" + projectId);
                if (filesArray.size() == 0) {
                    return;
                }
                String updateName = (String)((JSONObject)filesArray.get(filesArray.size() - 1)).get((Object)"name");
                PluginVersion remoteVersion = new PluginVersion(updateName);
                if (remoteVersion.isNewerThan(localVersion = new PluginVersion(plugin.getDescription().getVersion()))) {
                    Bukkit.getScheduler().runTask(plugin, () -> responseHandler.onUpdateFound(remoteVersion.getFormattedVersion()));
                }
            }
            catch (IOException e) {
                plugin.getLogger().log(Level.WARNING, "Could not contact BukkitDev to check for updates.");
            }
            catch (InvalidVersionException e) {
                plugin.getLogger().log(Level.WARNING, "Could not check for updates because of a version format error: " + e.getMessage() + ".");
                plugin.getLogger().log(Level.WARNING, "Please notify the author of this error.");
            }
            catch (Exception e) {
                plugin.getLogger().log(Level.WARNING, "Unable to check for updates: unhandled exception.", e);
            }
        });
    }

    private static Object readJson(String url) throws MalformedURLException, IOException {
        URLConnection conn = new URL(url).openConnection();
        conn.setConnectTimeout(5000);
        conn.setReadTimeout(8000);
        conn.addRequestProperty("User-Agent", "Plugin Updater (by filoghost)");
        conn.setDoOutput(true);
        return JSONValue.parse((Reader)new BufferedReader(new InputStreamReader(conn.getInputStream())));
    }
}

