/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.listener;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import me.filoghost.holographicdisplays.nms.common.EntityID;
import me.filoghost.holographicdisplays.nms.common.PacketListener;
import me.filoghost.holographicdisplays.plugin.hologram.base.BaseClickableHologramLine;
import org.bukkit.entity.Player;

public class LineClickListener
implements PacketListener {
    private final ConcurrentMap<Integer, BaseClickableHologramLine> linesByEntityID = new ConcurrentHashMap<Integer, BaseClickableHologramLine>();
    private final Set<QueuedClickEvent> queuedClickEvents = Collections.newSetFromMap(new ConcurrentHashMap());

    @Override
    public boolean onAsyncEntityInteract(Player player, int entityID) {
        BaseClickableHologramLine line = (BaseClickableHologramLine)this.linesByEntityID.get(entityID);
        if (line != null) {
            this.queuedClickEvents.add(new QueuedClickEvent(player, line));
            return true;
        }
        return false;
    }

    public void processQueuedClickEvents() {
        for (QueuedClickEvent queuedClickEvent : this.queuedClickEvents) {
            queuedClickEvent.line.onClick(queuedClickEvent.player);
        }
        this.queuedClickEvents.clear();
    }

    public void registerLine(EntityID clickableEntityID, BaseClickableHologramLine line) {
        this.linesByEntityID.put(clickableEntityID.getNumericID(), line);
    }

    public void unregisterLine(EntityID clickableEntityID) {
        if (clickableEntityID.hasInitializedNumericID()) {
            this.linesByEntityID.remove(clickableEntityID.getNumericID());
        }
    }

    private static class QueuedClickEvent {
        private final Player player;
        private final BaseClickableHologramLine line;

        QueuedClickEvent(Player player, BaseClickableHologramLine line) {
            this.player = player;
            this.line = line;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            QueuedClickEvent other = (QueuedClickEvent)obj;
            return this.player.equals(other.player) && this.line.equals(other.line);
        }

        public int hashCode() {
            int result = this.player.hashCode();
            result = 31 * result + this.line.hashCode();
            return result;
        }
    }
}

