/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.listener;

import me.filoghost.holographicdisplays.plugin.HolographicDisplays;
import me.filoghost.holographicdisplays.plugin.config.Settings;
import me.filoghost.holographicdisplays.plugin.format.ColorScheme;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.logging.Log;
import me.filoghost.holographicdisplays.plugin.lib.updater.UpdateChecker;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class UpdateNotificationListener
implements Listener {
    @Nullable
    private String newVersion;

    public void runAsyncUpdateCheck(HolographicDisplays holographicDisplays) {
        if (Settings.updateNotification) {
            UpdateChecker.run((Plugin)holographicDisplays, 75097, newVersion -> {
                this.newVersion = newVersion;
                Log.info("Found a new version available: " + newVersion);
                Log.info("Download it on Bukkit Dev:");
                Log.info("https://dev.bukkit.org/projects/holographic-displays");
            });
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player;
        if (Settings.updateNotification && this.newVersion != null && (player = event.getPlayer()).hasPermission("holographicdisplays.update")) {
            player.sendMessage(ColorScheme.PRIMARY_DARK + "[HolographicDisplays] " + ColorScheme.PRIMARY + "Found an update: " + this.newVersion + ". Download:");
            player.sendMessage(ColorScheme.PRIMARY_DARK + ">> " + ColorScheme.PRIMARY + "https://dev.bukkit.org/projects/holographic-displays");
        }
    }
}

