/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.log;

import java.util.List;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.Strings;

class MessagePartJoiner {
    private final StringBuilder output = new StringBuilder();
    private String previousMessagePart;
    private boolean appendedFirstSentenceSeparator;

    MessagePartJoiner(List<String> messageParts) {
        for (String messagePart : messageParts) {
            this.append(messagePart);
        }
    }

    private void append(String messagePart) {
        this.appendSeparator();
        this.appendMessagePart(messagePart);
        this.previousMessagePart = messagePart;
    }

    private void appendMessagePart(String messagePart) {
        if (this.previousMessagePart == null || Strings.hasSentenceEnding(this.previousMessagePart)) {
            this.output.append(Strings.capitalizeFirst(messagePart));
        } else {
            this.output.append(messagePart);
        }
    }

    private void appendSeparator() {
        if (this.previousMessagePart == null) {
            return;
        }
        if (Strings.hasSentenceEnding(this.previousMessagePart)) {
            this.output.append(" ");
            this.appendedFirstSentenceSeparator = false;
        } else if (!this.appendedFirstSentenceSeparator) {
            this.output.append(": ");
            this.appendedFirstSentenceSeparator = true;
        } else {
            this.output.append(", ");
        }
    }

    StringBuilder getOutput() {
        return this.output;
    }
}

