/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.placeholder.parsing;

import java.util.Objects;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.Strings;
import me.filoghost.holographicdisplays.plugin.placeholder.parsing.PlaceholderIdentifier;
import me.filoghost.holographicdisplays.plugin.placeholder.parsing.PluginName;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaceholderOccurrence {
    private final PluginName pluginName;
    private final PlaceholderIdentifier identifier;
    private final String argument;
    private final int hashCode;

    private PlaceholderOccurrence(PluginName pluginName, PlaceholderIdentifier identifier, String argument) {
        this.pluginName = pluginName;
        this.identifier = identifier;
        this.argument = argument;
        this.hashCode = Objects.hash(pluginName, identifier, argument);
    }

    @Nullable
    public PluginName getPluginName() {
        return this.pluginName;
    }

    @NotNull
    public PlaceholderIdentifier getIdentifier() {
        return this.identifier;
    }

    @Nullable
    public String getArgument() {
        return this.argument;
    }

    public static PlaceholderOccurrence parse(String placeholderContent) {
        String identifierString;
        String[] parts;
        PluginName pluginName = null;
        String argument = null;
        if (placeholderContent.contains(":")) {
            parts = Strings.splitAndTrim(placeholderContent, ":", 2);
            identifierString = parts[0];
            argument = parts[1];
        } else {
            identifierString = placeholderContent;
        }
        if (identifierString.contains("/")) {
            parts = Strings.splitAndTrim(identifierString, "/", 2);
            pluginName = new PluginName(parts[0]);
            identifierString = parts[1];
        }
        PlaceholderIdentifier identifier = new PlaceholderIdentifier(identifierString);
        return new PlaceholderOccurrence(pluginName, identifier, argument);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PlaceholderOccurrence)) {
            return false;
        }
        PlaceholderOccurrence other = (PlaceholderOccurrence)obj;
        return this.hashCode == other.hashCode && Objects.equals(this.pluginName, other.pluginName) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.argument, other.argument);
    }

    public final int hashCode() {
        return this.hashCode;
    }
}

