/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.placeholder.parsing;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import me.filoghost.holographicdisplays.plugin.placeholder.parsing.PlaceholderOccurrence;
import me.filoghost.holographicdisplays.plugin.placeholder.parsing.PlaceholderReplaceFunction;
import me.filoghost.holographicdisplays.plugin.placeholder.parsing.StringReplaceFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringWithPlaceholders {
    private static final char PLACEHOLDER_END_CHAR = '}';
    private static final char PLACEHOLDER_START_CHAR = '{';
    @NotNull
    private final String string;
    @Nullable
    private final List<StringPart> stringParts;

    @NotNull
    public static StringWithPlaceholders of(@NotNull String string) {
        return new StringWithPlaceholders(string, StringWithPlaceholders.splitToParts(string));
    }

    private StringWithPlaceholders(@NotNull String string, @Nullable List<StringPart> stringParts) {
        this.string = string;
        this.stringParts = stringParts;
    }

    @NotNull
    public String getString() {
        return this.string;
    }

    public boolean containsPlaceholders() {
        if (this.stringParts == null) {
            return false;
        }
        for (StringPart stringPart : this.stringParts) {
            if (!(stringPart instanceof PlaceholderPart)) continue;
            return true;
        }
        return false;
    }

    public boolean anyPlaceholderMatch(Predicate<PlaceholderOccurrence> filter) {
        if (this.stringParts == null) {
            return false;
        }
        for (StringPart stringPart : this.stringParts) {
            PlaceholderPart placeholderPart;
            if (!(stringPart instanceof PlaceholderPart) || !filter.test((placeholderPart = (PlaceholderPart)stringPart).getPlaceholderOccurrence())) continue;
            return true;
        }
        return false;
    }

    public boolean anyLiteralPartMatch(Predicate<String> filter) {
        if (this.stringParts == null) {
            return filter.test(this.string);
        }
        for (StringPart stringPart : this.stringParts) {
            if (!(stringPart instanceof LiteralPart) || !filter.test(stringPart.getRawValue())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public String replacePlaceholders(PlaceholderReplaceFunction replaceFunction) {
        return this.replaceParts(replaceFunction, StringReplaceFunction.NO_REPLACEMENTS);
    }

    @NotNull
    public String replaceLiteralParts(StringReplaceFunction replaceFunction) {
        return this.replaceParts(PlaceholderReplaceFunction.NO_REPLACEMENTS, replaceFunction);
    }

    @NotNull
    public String replaceParts(PlaceholderReplaceFunction placeholderReplaceFunction, StringReplaceFunction literalPartReplaceFunction) {
        if (this.stringParts == null) {
            return literalPartReplaceFunction.getReplacement(this.string);
        }
        StringBuilder output = new StringBuilder(this.string.length());
        for (StringPart part : this.stringParts) {
            if (part instanceof LiteralPart) {
                output.append(literalPartReplaceFunction.getReplacement(part.getRawValue()));
                continue;
            }
            output.append(part.getValue(placeholderReplaceFunction));
        }
        return output.toString();
    }

    @Nullable
    private static List<StringPart> splitToParts(@NotNull String string) {
        int placeholderStartIndex = -1;
        int lastAppendIndex = 0;
        ArrayList<LiteralPart> stringParts = null;
        for (int currentIndex = 0; currentIndex < string.length(); ++currentIndex) {
            char currentChar = string.charAt(currentIndex);
            if (placeholderStartIndex >= 0) {
                if (currentChar == '}') {
                    int endIndex = currentIndex + 1;
                    String unparsedString = string.substring(placeholderStartIndex, endIndex);
                    String contentString = unparsedString.substring(1, unparsedString.length() - 1);
                    PlaceholderOccurrence content = PlaceholderOccurrence.parse(contentString);
                    if (stringParts == null) {
                        stringParts = new ArrayList<LiteralPart>();
                    }
                    if (placeholderStartIndex != lastAppendIndex) {
                        stringParts.add(new LiteralPart(string.substring(lastAppendIndex, placeholderStartIndex)));
                    }
                    stringParts.add((LiteralPart)((Object)new PlaceholderPart(content, unparsedString)));
                    lastAppendIndex = endIndex;
                    placeholderStartIndex = -1;
                    continue;
                }
                if (currentChar != '{') continue;
                placeholderStartIndex = currentIndex;
                continue;
            }
            if (currentChar != '{') continue;
            placeholderStartIndex = currentIndex;
        }
        if (lastAppendIndex != string.length() && stringParts != null) {
            stringParts.add(new LiteralPart(string.substring(lastAppendIndex)));
        }
        return stringParts;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StringWithPlaceholders other = (StringWithPlaceholders)obj;
        return Objects.equals(this.string, other.string);
    }

    public int hashCode() {
        return Objects.hashCode(this.string);
    }

    private static interface StringPart {
        public String getValue(PlaceholderReplaceFunction var1);

        public String getRawValue();
    }

    private static class PlaceholderPart
    implements StringPart {
        private final PlaceholderOccurrence placeholderOccurrence;
        private final String unreplacedString;

        PlaceholderPart(@NotNull PlaceholderOccurrence placeholderOccurrence, @NotNull String unreplacedString) {
            this.placeholderOccurrence = placeholderOccurrence;
            this.unreplacedString = unreplacedString;
        }

        @Override
        public String getValue(PlaceholderReplaceFunction placeholderReplaceFunction) {
            String replacement = placeholderReplaceFunction.getReplacement(this.placeholderOccurrence);
            if (replacement != null) {
                return replacement;
            }
            return this.unreplacedString;
        }

        @Override
        public String getRawValue() {
            return this.unreplacedString;
        }

        public PlaceholderOccurrence getPlaceholderOccurrence() {
            return this.placeholderOccurrence;
        }
    }

    private static class LiteralPart
    implements StringPart {
        private final String value;

        LiteralPart(@NotNull String value) {
            this.value = value;
        }

        @Override
        public String getValue(PlaceholderReplaceFunction placeholderReplaceFunction) {
            return this.value;
        }

        @Override
        public String getRawValue() {
            return this.value;
        }
    }
}

