/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.placeholder.registry;

import me.filoghost.holographicdisplays.api.beta.placeholder.GlobalPlaceholder;
import me.filoghost.holographicdisplays.api.beta.placeholder.GlobalPlaceholderFactory;
import me.filoghost.holographicdisplays.plugin.placeholder.PlaceholderException;
import me.filoghost.holographicdisplays.plugin.placeholder.StandardPlaceholder;
import me.filoghost.holographicdisplays.plugin.placeholder.registry.PlaceholderExpansion;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GlobalPlaceholderExpansion
extends PlaceholderExpansion {
    private final GlobalPlaceholderFactory placeholderFactory;

    GlobalPlaceholderExpansion(Plugin plugin, String identifier, GlobalPlaceholderFactory placeholderFactory) {
        super(plugin, identifier);
        this.placeholderFactory = placeholderFactory;
    }

    @Override
    public boolean isIndividual() {
        return false;
    }

    @Override
    @Nullable
    public StandardPlaceholder createPlaceholder(String argument) throws PlaceholderException {
        GlobalPlaceholder placeholder;
        try {
            placeholder = this.placeholderFactory.getPlaceholder(argument);
        }
        catch (Throwable t) {
            throw new PlaceholderException(t, this);
        }
        if (placeholder != null) {
            return new GlobalStandardPlaceholder(placeholder, this);
        }
        return null;
    }

    private static class GlobalStandardPlaceholder
    extends StandardPlaceholder {
        @NotNull
        private final GlobalPlaceholder placeholder;

        GlobalStandardPlaceholder(@NotNull GlobalPlaceholder placeholder, @NotNull GlobalPlaceholderExpansion source) {
            super(source);
            this.placeholder = placeholder;
        }

        @Override
        protected int doGetRefreshIntervalTicks() {
            return this.placeholder.getRefreshIntervalTicks();
        }

        @Override
        @Nullable
        protected String doGetReplacement(Player player, @Nullable String argument) {
            return this.placeholder.getReplacement(argument);
        }
    }
}

