/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.placeholder.registry;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import me.filoghost.holographicdisplays.api.beta.placeholder.GlobalPlaceholder;
import me.filoghost.holographicdisplays.api.beta.placeholder.GlobalPlaceholderFactory;
import me.filoghost.holographicdisplays.api.beta.placeholder.GlobalPlaceholderReplacementSupplier;
import me.filoghost.holographicdisplays.api.beta.placeholder.IndividualPlaceholder;
import me.filoghost.holographicdisplays.api.beta.placeholder.IndividualPlaceholderFactory;
import me.filoghost.holographicdisplays.api.beta.placeholder.IndividualPlaceholderReplacementSupplier;
import me.filoghost.holographicdisplays.api.beta.placeholder.RegisteredPlaceholder;
import me.filoghost.holographicdisplays.plugin.placeholder.parsing.PlaceholderIdentifier;
import me.filoghost.holographicdisplays.plugin.placeholder.parsing.PlaceholderOccurrence;
import me.filoghost.holographicdisplays.plugin.placeholder.parsing.PluginName;
import me.filoghost.holographicdisplays.plugin.placeholder.registry.GlobalPlaceholderExpansion;
import me.filoghost.holographicdisplays.plugin.placeholder.registry.IndividualPlaceholderExpansion;
import me.filoghost.holographicdisplays.plugin.placeholder.registry.PlaceholderExpansion;
import me.filoghost.holographicdisplays.plugin.placeholder.registry.SimpleGlobalPlaceholder;
import me.filoghost.holographicdisplays.plugin.placeholder.registry.SimpleIndividualPlaceholder;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class PlaceholderRegistry {
    private final Table<PlaceholderIdentifier, PluginName, PlaceholderExpansion> placeholderExpansions = HashBasedTable.create();
    private final AtomicLong version = new AtomicLong();

    public long getVersion() {
        return this.version.get();
    }

    public void registerIndividualPlaceholder(Plugin plugin, String identifier, int refreshIntervalTicks, IndividualPlaceholderReplacementSupplier replacementSupplier) {
        this.registerIndividualPlaceholder(plugin, identifier, new SimpleIndividualPlaceholder(refreshIntervalTicks, replacementSupplier));
    }

    public void registerIndividualPlaceholder(Plugin plugin, String identifier, IndividualPlaceholder placeholder) {
        this.registerIndividualPlaceholderFactory(plugin, identifier, argument -> placeholder);
    }

    public void registerIndividualPlaceholderFactory(Plugin plugin, String identifier, IndividualPlaceholderFactory factory) {
        IndividualPlaceholderExpansion expansion = new IndividualPlaceholderExpansion(plugin, identifier, factory);
        this.registerExpansion(expansion);
    }

    public void registerGlobalPlaceholder(Plugin plugin, String identifier, int refreshIntervalTicks, GlobalPlaceholderReplacementSupplier replacementSupplier) {
        this.registerGlobalPlaceholder(plugin, identifier, new SimpleGlobalPlaceholder(refreshIntervalTicks, replacementSupplier));
    }

    public void registerGlobalPlaceholder(Plugin plugin, String identifier, GlobalPlaceholder placeholder) {
        this.registerGlobalPlaceholderFactory(plugin, identifier, argument -> placeholder);
    }

    public void registerGlobalPlaceholderFactory(Plugin plugin, String identifier, GlobalPlaceholderFactory factory) {
        GlobalPlaceholderExpansion expansion = new GlobalPlaceholderExpansion(plugin, identifier, factory);
        this.registerExpansion(expansion);
    }

    private void registerExpansion(PlaceholderExpansion expansion) {
        this.placeholderExpansions.put((Object)expansion.getCaseInsensitiveIdentifier(), (Object)expansion.getPluginName(), (Object)expansion);
        this.version.incrementAndGet();
    }

    public void unregisterAll(Plugin plugin) {
        this.placeholderExpansions.column((Object)new PluginName(plugin)).clear();
        this.version.incrementAndGet();
    }

    public void unregister(Plugin plugin, String identifier) {
        this.placeholderExpansions.remove((Object)new PlaceholderIdentifier(identifier), (Object)new PluginName(plugin));
        this.version.incrementAndGet();
    }

    @Nullable
    public PlaceholderExpansion find(PlaceholderOccurrence textOccurrence) {
        PluginName pluginName = textOccurrence.getPluginName();
        PlaceholderIdentifier identifier = textOccurrence.getIdentifier();
        if (pluginName != null) {
            return (PlaceholderExpansion)this.placeholderExpansions.get((Object)identifier, (Object)pluginName);
        }
        return (PlaceholderExpansion)Iterables.getFirst(this.placeholderExpansions.row((Object)identifier).values(), null);
    }

    public List<RegisteredPlaceholder> getRegisteredPlaceholders(Plugin plugin) {
        PluginName pluginName = new PluginName(plugin);
        return new ArrayList<RegisteredPlaceholder>(this.placeholderExpansions.column((Object)pluginName).values());
    }

    public boolean isRegisteredIdentifier(Plugin plugin, String identifier) {
        return this.placeholderExpansions.contains((Object)new PlaceholderIdentifier(identifier), (Object)new PluginName(plugin));
    }
}

