/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.placeholder.tracking;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import me.filoghost.holographicdisplays.plugin.placeholder.PlaceholderException;
import me.filoghost.holographicdisplays.plugin.placeholder.StandardPlaceholder;
import me.filoghost.holographicdisplays.plugin.placeholder.parsing.PlaceholderOccurrence;
import me.filoghost.holographicdisplays.plugin.placeholder.parsing.StringWithPlaceholders;
import me.filoghost.holographicdisplays.plugin.placeholder.registry.PlaceholderExpansion;
import me.filoghost.holographicdisplays.plugin.placeholder.registry.PlaceholderRegistry;
import me.filoghost.holographicdisplays.plugin.placeholder.tracking.ActivePlaceholder;
import me.filoghost.holographicdisplays.plugin.placeholder.tracking.GlobalActivePlaceholder;
import me.filoghost.holographicdisplays.plugin.placeholder.tracking.IndividualActivePlaceholder;
import me.filoghost.holographicdisplays.plugin.placeholder.tracking.NullActivePlaceholder;
import me.filoghost.holographicdisplays.plugin.placeholder.tracking.PlaceholderExceptionHandler;
import me.filoghost.holographicdisplays.plugin.tick.TickClock;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActivePlaceholderTracker {
    private final PlaceholderRegistry registry;
    private final TickClock tickClock;
    private final PlaceholderExceptionHandler exceptionHandler;
    private final Map<PlaceholderOccurrence, ActivePlaceholder> activePlaceholders;
    private long lastRegistryVersion;

    public ActivePlaceholderTracker(PlaceholderRegistry registry, TickClock tickClock) {
        this.registry = registry;
        this.tickClock = tickClock;
        this.exceptionHandler = new PlaceholderExceptionHandler(tickClock);
        this.activePlaceholders = new HashMap<PlaceholderOccurrence, ActivePlaceholder>();
    }

    public void clearOutdatedEntries() {
        long currentRegistryVersion = this.registry.getVersion();
        if (this.lastRegistryVersion == currentRegistryVersion) {
            return;
        }
        this.lastRegistryVersion = currentRegistryVersion;
        this.activePlaceholders.entrySet().removeIf(entry -> {
            PlaceholderExpansion newSource;
            PlaceholderOccurrence placeholderOccurrence = (PlaceholderOccurrence)entry.getKey();
            PlaceholderExpansion currentSource = ((ActivePlaceholder)entry.getValue()).getSource();
            return !Objects.equals(currentSource, newSource = this.registry.find(placeholderOccurrence));
        });
    }

    public void clearUnusedEntries() {
        long currentTick = this.tickClock.getCurrentTick();
        this.activePlaceholders.values().removeIf(activePlaceholder -> currentTick - activePlaceholder.getLastRequestTick() >= 1L);
    }

    @Nullable
    public String updateAndGetGlobalReplacement(PlaceholderOccurrence placeholderOccurrence) {
        try {
            ActivePlaceholder activePlaceholder = this.trackAndGetPlaceholder(placeholderOccurrence);
            if (activePlaceholder.isIndividual()) {
                return null;
            }
            return activePlaceholder.updateAndGetReplacement(null, this.tickClock.getCurrentTick());
        }
        catch (PlaceholderException e) {
            this.exceptionHandler.handle(e);
            return "[Error]";
        }
    }

    @Nullable
    public String updateAndGetReplacement(PlaceholderOccurrence placeholderOccurrence, Player player) {
        try {
            ActivePlaceholder activePlaceholder = this.trackAndGetPlaceholder(placeholderOccurrence);
            return activePlaceholder.updateAndGetReplacement(player, this.tickClock.getCurrentTick());
        }
        catch (PlaceholderException e) {
            this.exceptionHandler.handle(e);
            return "[Error]";
        }
    }

    @NotNull
    private ActivePlaceholder trackAndGetPlaceholder(PlaceholderOccurrence placeholderOccurrence) throws PlaceholderException {
        ActivePlaceholder activePlaceholder = this.activePlaceholders.get(placeholderOccurrence);
        if (activePlaceholder == null) {
            activePlaceholder = this.createActivePlaceholder(placeholderOccurrence);
            this.activePlaceholders.put(placeholderOccurrence, activePlaceholder);
        }
        return activePlaceholder;
    }

    private ActivePlaceholder createActivePlaceholder(PlaceholderOccurrence placeholderOccurrence) throws PlaceholderException {
        PlaceholderExpansion placeholderExpansion = this.registry.find(placeholderOccurrence);
        StandardPlaceholder placeholder = placeholderExpansion != null ? placeholderExpansion.createPlaceholder(placeholderOccurrence.getArgument()) : null;
        if (placeholder == null) {
            return new NullActivePlaceholder(placeholderExpansion);
        }
        if (placeholder.isIndividual()) {
            return new IndividualActivePlaceholder(placeholder, placeholderOccurrence);
        }
        return new GlobalActivePlaceholder(placeholder, placeholderOccurrence);
    }

    public boolean containsIndividualPlaceholders(@NotNull StringWithPlaceholders stringWithPlaceholders) {
        return stringWithPlaceholders.anyPlaceholderMatch(occurrence -> {
            PlaceholderExpansion placeholderExpansion = this.registry.find((PlaceholderOccurrence)occurrence);
            return placeholderExpansion != null && placeholderExpansion.isIndividual();
        });
    }

    public long getRegistryVersion() {
        return this.registry.getVersion();
    }
}

