/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.placeholder.tracking;

import java.util.Map;
import java.util.WeakHashMap;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.logging.Log;
import me.filoghost.holographicdisplays.plugin.placeholder.PlaceholderException;
import me.filoghost.holographicdisplays.plugin.placeholder.registry.PlaceholderExpansion;
import me.filoghost.holographicdisplays.plugin.tick.TickClock;

class PlaceholderExceptionHandler {
    private final TickClock tickClock;
    private final Map<PlaceholderExpansion, Long> lastErrorLogByPlaceholderExpansion;

    PlaceholderExceptionHandler(TickClock tickClock) {
        this.tickClock = tickClock;
        this.lastErrorLogByPlaceholderExpansion = new WeakHashMap<PlaceholderExpansion, Long>();
    }

    void handle(PlaceholderException exception) {
        PlaceholderExpansion placeholderExpansion = exception.getPlaceholderExpansion();
        Long lastErrorLog = this.lastErrorLogByPlaceholderExpansion.get(placeholderExpansion);
        long currentTick = this.tickClock.getCurrentTick();
        if (lastErrorLog != null && currentTick - lastErrorLog < 20L) {
            return;
        }
        this.lastErrorLogByPlaceholderExpansion.put(placeholderExpansion, currentTick);
        Log.warning("The placeholder \"" + placeholderExpansion.getIdentifier() + "\" registered by the plugin " + placeholderExpansion.getPluginName() + " generated an exception. Please contact the author of " + placeholderExpansion.getPluginName(), exception.getCause());
    }
}

