/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.placeholder.tracking;

import me.filoghost.holographicdisplays.plugin.placeholder.PlaceholderException;
import me.filoghost.holographicdisplays.plugin.placeholder.StandardPlaceholder;
import me.filoghost.holographicdisplays.plugin.placeholder.parsing.PlaceholderOccurrence;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ReplacementHolder {
    @NotNull
    private final StandardPlaceholder placeholder;
    @NotNull
    private final PlaceholderOccurrence placeholderOccurrence;
    @Nullable
    private String currentReplacement;
    private long lastUpdateTick = -1L;

    ReplacementHolder(@NotNull StandardPlaceholder placeholder, @NotNull PlaceholderOccurrence placeholderOccurrence) {
        this.placeholder = placeholder;
        this.placeholderOccurrence = placeholderOccurrence;
    }

    @Nullable
    String updateAndGet(Player player, long currentTick) throws PlaceholderException {
        if (this.needsRefresh(currentTick)) {
            this.currentReplacement = this.placeholder.getReplacement(player, this.placeholderOccurrence.getArgument());
            this.lastUpdateTick = currentTick;
        }
        return this.currentReplacement;
    }

    private boolean needsRefresh(long currentTick) throws PlaceholderException {
        if (this.lastUpdateTick == currentTick) {
            return false;
        }
        if (this.lastUpdateTick == -1L) {
            return true;
        }
        return currentTick - this.lastUpdateTick >= (long)this.placeholder.getRefreshIntervalTicks();
    }
}

