/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.filoghost.holographicdisplays.nms.common.NMSManager;
import me.filoghost.holographicdisplays.nms.v1_15_R1.VersionNMSManager;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.logging.ErrorCollector;
import org.bukkit.Bukkit;

public enum NMSVersion {
    v1_8_R1(NMSManagerFactory.outdatedVersion("1.8.4")),
    v1_8_R2(NMSManagerFactory.outdatedVersion("1.8.4")),
    v1_8_R3(errorCollector -> new me.filoghost.holographicdisplays.nms.v1_8_R3.VersionNMSManager(errorCollector)),
    v1_9_R1(NMSManagerFactory.outdatedVersion("1.9.4")),
    v1_9_R2(errorCollector -> new me.filoghost.holographicdisplays.nms.v1_9_R2.VersionNMSManager(errorCollector)),
    v1_10_R1(errorCollector -> new me.filoghost.holographicdisplays.nms.v1_10_R1.VersionNMSManager(errorCollector)),
    v1_11_R1(errorCollector -> new me.filoghost.holographicdisplays.nms.v1_11_R1.VersionNMSManager(errorCollector)),
    v1_12_R1(errorCollector -> new me.filoghost.holographicdisplays.nms.v1_12_R1.VersionNMSManager(errorCollector)),
    v1_13_R1(NMSManagerFactory.outdatedVersion("1.13.1")),
    v1_13_R2(errorCollector -> new me.filoghost.holographicdisplays.nms.v1_13_R2.VersionNMSManager(errorCollector)),
    v1_14_R1(errorCollector -> new me.filoghost.holographicdisplays.nms.v1_14_R1.VersionNMSManager(errorCollector)),
    v1_15_R1(errorCollector -> new VersionNMSManager(errorCollector)),
    v1_16_R1(errorCollector -> new me.filoghost.holographicdisplays.nms.v1_16_R1.VersionNMSManager(errorCollector)),
    v1_16_R2(errorCollector -> new me.filoghost.holographicdisplays.nms.v1_16_R2.VersionNMSManager(errorCollector)),
    v1_16_R3(errorCollector -> new me.filoghost.holographicdisplays.nms.v1_16_R3.VersionNMSManager(errorCollector)),
    v1_17_R1(errorCollector -> new me.filoghost.holographicdisplays.nms.v1_17_R1.VersionNMSManager(errorCollector)),
    v1_18_R1(errorCollector -> new me.filoghost.holographicdisplays.nms.v1_18_R1.VersionNMSManager(errorCollector)),
    UNKNOWN(NMSManagerFactory.unknownVersion());

    private static final NMSVersion CURRENT_VERSION;
    private final NMSManagerFactory nmsManagerFactory;

    private NMSVersion(NMSManagerFactory nmsManagerFactory) {
        this.nmsManagerFactory = nmsManagerFactory;
    }

    public NMSManager createNMSManager(ErrorCollector errorCollector) throws OutdatedVersionException, UnknownVersionException {
        return this.nmsManagerFactory.create(errorCollector);
    }

    public static NMSVersion getCurrent() {
        return CURRENT_VERSION;
    }

    private static NMSVersion detectCurrentVersion() {
        Matcher matcher = Pattern.compile("v\\d+_\\d+_R\\d+").matcher(Bukkit.getServer().getClass().getPackage().getName());
        if (!matcher.find()) {
            return UNKNOWN;
        }
        String nmsVersionName = matcher.group();
        try {
            return NMSVersion.valueOf(nmsVersionName);
        }
        catch (IllegalArgumentException e) {
            return UNKNOWN;
        }
    }

    static {
        CURRENT_VERSION = NMSVersion.detectCurrentVersion();
    }

    @FunctionalInterface
    private static interface NMSManagerFactory {
        public NMSManager create(ErrorCollector var1) throws UnknownVersionException, OutdatedVersionException;

        public static NMSManagerFactory unknownVersion() {
            return errorCollector -> {
                throw new UnknownVersionException();
            };
        }

        public static NMSManagerFactory outdatedVersion(String minimumSupportedVersion) {
            return errorCollector -> {
                throw new OutdatedVersionException(minimumSupportedVersion);
            };
        }
    }

    public static class OutdatedVersionException
    extends Exception {
        private final String minimumSupportedVersion;

        public OutdatedVersionException(String minimumSupportedVersion) {
            this.minimumSupportedVersion = minimumSupportedVersion;
        }

        public String getMinimumSupportedVersion() {
            return this.minimumSupportedVersion;
        }
    }

    public static class UnknownVersionException
    extends Exception {
    }
}

