/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.classresources.placeholders;

import com.bencodez.votingplugin.user.UserManager;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Objects;
import me.realized.tokenmanager.api.TokenManager;
import me.rockyhawk.commandpanels.CommandPanels;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.ioclasses.legacy.MinecraftVersions;
import me.rockyhawk.commandpanels.openpanelsmanager.PanelPosition;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;

public class Placeholders {
    CommandPanels plugin;

    public Placeholders(CommandPanels pl) {
        this.plugin = pl;
    }

    public String setPlaceholders(Panel panel, PanelPosition position, Player p, String str, boolean primary) {
        String[] HOLDERS = this.getPlaceholderEnds(panel, primary);
        while (str.contains(HOLDERS[0] + "cp-")) {
            try {
                String value;
                int start = str.indexOf(HOLDERS[0] + "cp-");
                int end = str.indexOf(HOLDERS[1], str.indexOf(HOLDERS[0] + "cp-") + 1);
                String identifier = str.substring(start, end).replace(HOLDERS[0] + "cp-", "").replace(HOLDERS[1], "");
                try {
                    value = this.cpPlaceholders(panel, position, p, identifier);
                }
                catch (NullPointerException er) {
                    value = "";
                }
                str = str.replace(str.substring(start, end) + HOLDERS[1], value);
            }
            catch (Exception ex) {
                this.plugin.debug(ex, p);
                break;
            }
        }
        return str;
    }

    public String[] getPlaceholderEnds(Panel panel, boolean primary) {
        ArrayList<String[]> values = new ArrayList<String[]>();
        values.add(new String[]{this.plugin.config.getString("placeholders.primary.start"), this.plugin.config.getString("placeholders.primary.end")});
        values.add(new String[]{this.plugin.config.getString("placeholders.secondary.start"), this.plugin.config.getString("placeholders.secondary.end")});
        if (panel != null && panel.getConfig().isSet("placeholders")) {
            if (panel.getConfig().isSet("placeholders.primary")) {
                values.set(0, new String[]{panel.getConfig().getString("placeholders.primary.start"), panel.getConfig().getString("placeholders.primary.end")});
            }
            if (panel.getConfig().isSet("placeholders.secondary")) {
                values.set(1, new String[]{panel.getConfig().getString("placeholders.secondary.start"), panel.getConfig().getString("placeholders.secondary.end")});
            }
        }
        if (primary) {
            return (String[])values.get(0);
        }
        return (String[])values.get(1);
    }

    public String cpPlaceholders(Panel panel, PanelPosition position, Player p, String identifier) {
        String point_value;
        String matNumber;
        switch (identifier) {
            case "player-displayname": {
                return p.getDisplayName();
            }
            case "player-name": {
                return p.getName();
            }
            case "player-world": {
                return p.getWorld().getName();
            }
            case "player-x": {
                return String.valueOf(Math.round(p.getLocation().getX()));
            }
            case "player-y": {
                return String.valueOf(Math.round(p.getLocation().getY()));
            }
            case "player-z": {
                return String.valueOf(Math.round(p.getLocation().getZ()));
            }
            case "online-players": {
                return Integer.toString(Bukkit.getServer().getOnlinePlayers().size());
            }
            case "panel-position": {
                return position.toString();
            }
            case "tag": {
                return this.plugin.tex.colour(this.plugin.tag);
            }
        }
        if (panel != null) {
            for (String placeholder : panel.placeholders.keys.keySet()) {
                if (!identifier.equals(placeholder)) continue;
                try {
                    return panel.placeholders.keys.get(placeholder);
                }
                catch (Exception ex) {
                    this.plugin.debug(ex, p);
                    break;
                }
            }
        }
        if (identifier.startsWith("server-")) {
            String ip_port = identifier.replace("server-", "");
            Socket s = new Socket();
            try {
                s.connect(new InetSocketAddress(ip_port.split(":")[0], (int)Double.parseDouble(ip_port.split(":")[1])), this.plugin.config.getInt("config.server-ping-timeout"));
                s.close();
                return "true";
            }
            catch (IOException ex) {
                return "false";
            }
        }
        if (identifier.startsWith("nbt-")) {
            try {
                String slot_key = identifier.replace("nbt-", "");
                String value = this.plugin.nbt.getNBT(p.getOpenInventory().getTopInventory().getItem((int)Double.parseDouble(slot_key.split(":")[0])), slot_key.split(":")[1]);
                if (value == null) {
                    value = "empty";
                }
                return value;
            }
            catch (Exception ex) {
                this.plugin.debug(ex, p);
                return "";
            }
        }
        if (identifier.startsWith("material-")) {
            try {
                String material;
                matNumber = identifier.replace("material-", "");
                try {
                    material = p.getOpenInventory().getTopInventory().getItem((int)Double.parseDouble(matNumber)).getType().toString();
                    if (this.plugin.legacy.LOCAL_VERSION.lessThanOrEqualTo(MinecraftVersions.v1_12)) {
                        material = material + ":" + p.getOpenInventory().getTopInventory().getItem((int)Double.parseDouble(matNumber)).getType().getId();
                    }
                }
                catch (NullPointerException er) {
                    material = "AIR";
                }
                return material;
            }
            catch (Exception ex) {
                this.plugin.debug(ex, p);
                return "";
            }
        }
        if (identifier.startsWith("stack-")) {
            try {
                int amount;
                matNumber = identifier.replace("stack-", "");
                try {
                    amount = p.getOpenInventory().getTopInventory().getItem((int)Double.parseDouble(matNumber)).getAmount();
                }
                catch (NullPointerException er) {
                    amount = 0;
                }
                return String.valueOf(amount);
            }
            catch (Exception ex) {
                this.plugin.debug(ex, p);
                return "";
            }
        }
        if (identifier.startsWith("modeldata-")) {
            try {
                int modelData;
                matNumber = identifier.replace("modeldata-", "");
                try {
                    modelData = p.getOpenInventory().getTopInventory().getItem((int)Double.parseDouble(matNumber)).getItemMeta().getCustomModelData();
                }
                catch (NullPointerException er) {
                    modelData = 0;
                }
                return String.valueOf(modelData);
            }
            catch (Exception ex) {
                this.plugin.debug(ex, p);
                return "";
            }
        }
        if (identifier.startsWith("damaged-")) {
            try {
                matNumber = identifier.replace("damaged-", "");
                boolean damaged = false;
                ItemStack itm = p.getOpenInventory().getTopInventory().getItem((int)Double.parseDouble(matNumber));
                try {
                    if (this.plugin.legacy.LOCAL_VERSION.lessThanOrEqualTo(MinecraftVersions.v1_15)) {
                        if (itm.getType().getMaxDurability() != 0) {
                            damaged = itm.getType().getMaxDurability() - itm.getDurability() < itm.getType().getMaxDurability();
                        }
                    } else {
                        Damageable itemDamage = (Damageable)itm.getItemMeta();
                        damaged = itemDamage.hasDamage();
                    }
                }
                catch (NullPointerException er) {
                    damaged = false;
                }
                return String.valueOf(damaged);
            }
            catch (Exception ex) {
                this.plugin.debug(ex, p);
                return "";
            }
        }
        if (identifier.startsWith("identical-")) {
            try {
                String matLocSlot = identifier.replace("identical-", "");
                String matLoc = matLocSlot.split(",")[0];
                int matSlot = (int)Double.parseDouble(matLocSlot.split(",")[1]);
                boolean isIdentical = false;
                ItemStack itm = p.getOpenInventory().getTopInventory().getItem(matSlot);
                if (itm == null) {
                    return "false";
                }
                try {
                    String mmoID;
                    String mmoType;
                    ItemStack confItm = this.plugin.itemCreate.makeItemFromConfig(panel, position, panel.getConfig().getConfigurationSection("custom-item." + matLoc), p, true, true, false);
                    if (this.plugin.itemCreate.isIdentical(confItm, itm)) {
                        isIdentical = true;
                    }
                    String customItemMaterial = panel.getConfig().getString("custom-item." + matLoc + ".material");
                    if (this.plugin.getServer().getPluginManager().isPluginEnabled("MMOItems") && customItemMaterial.startsWith("mmo=") && this.plugin.isMMOItem(itm, mmoType = customItemMaterial.split("\\s")[1], mmoID = customItemMaterial.split("\\s")[2]) && itm.getAmount() <= confItm.getAmount()) {
                        isIdentical = true;
                    }
                }
                catch (NullPointerException er) {
                    isIdentical = false;
                }
                return String.valueOf(isIdentical);
            }
            catch (Exception ex) {
                this.plugin.debug(ex, p);
                return "";
            }
        }
        if (identifier.startsWith("random-")) {
            try {
                String min_max = identifier.replace("random-", "");
                int min = (int)Double.parseDouble(min_max.split(",")[0]);
                int max = (int)Double.parseDouble(min_max.split(",")[1]);
                return String.valueOf(this.plugin.getRandomNumberInRange(min, max));
            }
            catch (Exception ex) {
                this.plugin.debug(ex, p);
                return "";
            }
        }
        if (identifier.startsWith("data-")) {
            try {
                String dataPoint = identifier.replace("data-", "");
                if (dataPoint.contains(",")) {
                    String dataName = dataPoint.split(",")[0];
                    String playerName = dataPoint.split(",")[1];
                    return this.plugin.panelData.getUserData(Bukkit.getOfflinePlayer((String)playerName).getUniqueId(), dataName);
                }
                return this.plugin.panelData.getUserData(p.getUniqueId(), dataPoint);
            }
            catch (Exception ex) {
                this.plugin.debug(ex, p);
                return "";
            }
        }
        if (identifier.startsWith("setdata-")) {
            try {
                point_value = identifier.replace("cp-setdata-", "");
                String command = "set-data= " + point_value.split(",")[0] + " " + point_value.split(",")[1];
                this.plugin.commandTags.runCommand(panel, position, p, command);
                return "";
            }
            catch (Exception ex) {
                this.plugin.debug(ex, p);
                return "";
            }
        }
        if (identifier.startsWith("mathdata-")) {
            try {
                point_value = identifier.replace("mathdata-", "");
                String command = "math-data= " + point_value.split(",")[0] + " " + point_value.split(",")[1];
                this.plugin.commandTags.runCommand(panel, position, p, command);
                return "";
            }
            catch (Exception ex) {
                this.plugin.debug(ex, p);
                return "";
            }
        }
        if (identifier.startsWith("player-online-")) {
            try {
                String playerLocation = identifier.replace("player-online-", "");
                Player[] playerFind = Bukkit.getOnlinePlayers().toArray(new Player[Bukkit.getOnlinePlayers().size()]);
                if (Double.parseDouble(playerLocation) > (double)playerFind.length) {
                    return this.plugin.tex.colour(Objects.requireNonNull(this.plugin.config.getString("config.format.offline")));
                }
                return playerFind[(int)(Double.parseDouble(playerLocation) - 1.0)].getName();
            }
            catch (Exception ex) {
                this.plugin.debug(ex, p);
                return "";
            }
        }
        try {
            if (this.plugin.econ != null && identifier.equals("player-balance")) {
                return String.valueOf(Math.round(this.plugin.econ.getBalance((OfflinePlayer)p)));
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (this.plugin.getServer().getPluginManager().isPluginEnabled("TokenManager")) {
            TokenManager api = (TokenManager)Bukkit.getServer().getPluginManager().getPlugin("TokenManager");
            assert (api != null);
            if (identifier.equals("tokenmanager-balance")) {
                return Long.toString(api.getTokens(p).orElse(0L));
            }
        }
        if (this.plugin.getServer().getPluginManager().isPluginEnabled("VotingPlugin") && identifier.equals("votingplugin-points")) {
            return String.valueOf(UserManager.getInstance().getVotingPluginUser(p).getPoints());
        }
        return "";
    }
}

