/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.commandtags.tags.economy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import me.realized.tokenmanager.api.TokenManager;
import me.rockyhawk.commandpanels.CommandPanels;
import me.rockyhawk.commandpanels.commandtags.CommandTagEvent;
import me.rockyhawk.commandpanels.ioclasses.legacy.MinecraftVersions;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.PotionMeta;

public class SellItemTags
implements Listener {
    CommandPanels plugin;

    public SellItemTags(CommandPanels pl) {
        this.plugin = pl;
    }

    @EventHandler
    public void commandTag(CommandTagEvent e) {
        if (e.name.equalsIgnoreCase("sell=")) {
            e.commandTagUsed();
            try {
                if (this.plugin.econ != null) {
                    boolean sold = this.removeItem(e.p, e.args);
                    if (!sold) {
                        this.plugin.tex.sendMessage(e.p, this.plugin.config.getString("purchase.item.failure"));
                    } else {
                        this.plugin.econ.depositPlayer((OfflinePlayer)e.p, Double.parseDouble(e.args[0]));
                        this.plugin.tex.sendMessage(e.p, Objects.requireNonNull(this.plugin.config.getString("purchase.item.success")).replaceAll("%cp-args%", e.args[1]));
                    }
                } else {
                    this.plugin.tex.sendMessage(e.p, ChatColor.RED + "Selling Requires Vault and an Economy to work!");
                }
            }
            catch (Exception sell) {
                this.plugin.debug(sell, e.p);
                this.plugin.tex.sendMessage(e.p, this.plugin.config.getString("config.format.error") + " commands: " + e.name);
            }
            return;
        }
        if (e.name.equalsIgnoreCase("tokensell=")) {
            e.commandTagUsed();
            try {
                if (this.plugin.getServer().getPluginManager().isPluginEnabled("TokenManager")) {
                    TokenManager api = (TokenManager)Bukkit.getServer().getPluginManager().getPlugin("TokenManager");
                    boolean sold = this.removeItem(e.p, e.args);
                    if (!sold) {
                        this.plugin.tex.sendMessage(e.p, this.plugin.config.getString("purchase.item.failure"));
                    } else {
                        assert (api != null);
                        api.addTokens(e.p, Long.parseLong(e.args[0]));
                        this.plugin.tex.sendMessage(e.p, this.plugin.config.getString("purchase.item.success").replaceAll("%cp-args%", e.args[1]));
                    }
                } else {
                    this.plugin.tex.sendMessage(e.p, ChatColor.RED + "Selling Requires TokenManager to work!");
                }
            }
            catch (Exception sell) {
                this.plugin.debug(sell, e.p);
                this.plugin.tex.sendMessage(e.p, this.plugin.config.getString("config.format.error") + " commands: " + e.name);
            }
        }
    }

    private boolean removeItem(Player p, String[] args) {
        ArrayList<ItemStack> cont = new ArrayList<ItemStack>(Arrays.asList(this.plugin.inventorySaver.getNormalInventory(p)));
        for (int f = 0; f < 36; ++f) {
            ItemStack itm = (ItemStack)cont.get(f);
            if (itm == null || !itm.getType().equals((Object)Material.matchMaterial((String)args[1]))) continue;
            String potion = "false";
            for (String argsTemp : args) {
                if (!argsTemp.startsWith("potion:")) continue;
                potion = argsTemp.replace("potion:", "");
            }
            short id = -1;
            if (this.plugin.legacy.LOCAL_VERSION.lessThanOrEqualTo(MinecraftVersions.v1_15)) {
                for (String argsTemp : args) {
                    if (!argsTemp.startsWith("id:")) continue;
                    id = Byte.parseByte(argsTemp.replace("id:", ""));
                    break;
                }
            }
            try {
                if (!potion.equals("false")) {
                    PotionMeta potionMeta = (PotionMeta)itm.getItemMeta();
                    assert (potionMeta != null);
                    if (!potionMeta.getBasePotionData().getType().name().equalsIgnoreCase(potion)) {
                        p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.RED + "Your item has the wrong potion effect"));
                        return false;
                    }
                }
                if (id != -1 && itm.getDurability() != id) {
                    continue;
                }
            }
            catch (Exception exc) {
                this.plugin.debug(exc, p);
            }
            if (itm.getAmount() < new ItemStack(Objects.requireNonNull(Material.matchMaterial((String)args[1])), Integer.parseInt(args[2])).getAmount()) continue;
            int amt = itm.getAmount() - new ItemStack(Objects.requireNonNull(Material.matchMaterial((String)args[1])), Integer.parseInt(args[2])).getAmount();
            itm.setAmount(amt);
            if (this.plugin.inventorySaver.hasNormalInventory(p)) {
                p.getInventory().setItem(f, (ItemStack)(amt > 0 ? itm : null));
                p.updateInventory();
            } else {
                cont.set(f, (ItemStack)(amt > 0 ? itm : null));
                this.plugin.inventorySaver.inventoryConfig.set(p.getUniqueId().toString(), (Object)this.plugin.itemSerializer.itemStackArrayToBase64(cont.toArray(new ItemStack[0])));
            }
            return true;
        }
        return false;
    }
}

