/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.datamanager;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.UUID;
import java.util.regex.Pattern;
import me.rockyhawk.commandpanels.CommandPanels;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;

public class PanelDataLoader {
    CommandPanels plugin;
    public YamlConfiguration dataConfig;

    public PanelDataLoader(CommandPanels pl) {
        this.plugin = pl;
    }

    public String getUserData(UUID playerUUID, String dataPoint) {
        return this.dataConfig.getString("playerData." + playerUUID + "." + dataPoint);
    }

    public void setUserData(UUID playerUUID, String dataPoint, String dataValue, boolean overwrite) {
        if (!overwrite && this.dataConfig.isSet("playerData." + playerUUID + "." + dataPoint)) {
            return;
        }
        Pattern pattern = Pattern.compile("-?\\d+(\\.\\d+)?");
        if (pattern.matcher(dataValue).matches()) {
            this.doDataMath(playerUUID, dataPoint, dataValue);
            return;
        }
        this.dataConfig.set("playerData." + playerUUID + "." + dataPoint, (Object)dataValue);
    }

    public void delUserData(UUID playerUUID, String dataPoint) {
        this.dataConfig.set("playerData." + playerUUID + "." + dataPoint, null);
    }

    public void clearData(UUID playerUUID) {
        this.dataConfig.set("playerData." + playerUUID, null);
    }

    public void saveDataFile() {
        try {
            this.dataConfig.save(this.plugin.getDataFolder() + File.separator + "data.yml");
        }
        catch (IOException s) {
            s.printStackTrace();
            this.plugin.debug(s, null);
        }
    }

    public void doDataMath(UUID playerUUID, String dataPoint, String dataValue) {
        BigDecimal output;
        BigDecimal originalValue;
        try {
            originalValue = new BigDecimal(this.dataConfig.getString("playerData." + playerUUID + "." + dataPoint));
        }
        catch (Exception ex) {
            this.plugin.debug(ex, null);
            originalValue = new BigDecimal("1");
        }
        switch (dataValue.charAt(0)) {
            case '+': {
                BigDecimal newValue = new BigDecimal(dataValue.substring(1));
                output = originalValue.add(newValue);
                break;
            }
            case '-': {
                BigDecimal newValue = new BigDecimal(dataValue.substring(1));
                output = originalValue.subtract(newValue);
                break;
            }
            case '*': {
                BigDecimal newValue = new BigDecimal(dataValue.substring(1));
                output = originalValue.multiply(newValue);
                break;
            }
            case '/': {
                BigDecimal newValue = new BigDecimal(dataValue.substring(1));
                try {
                    output = originalValue.divide(newValue);
                }
                catch (ArithmeticException ex) {
                    this.plugin.debug(ex, null);
                    output = originalValue;
                }
                break;
            }
            default: {
                BigDecimal newValue;
                output = newValue = new BigDecimal(dataValue);
            }
        }
        if (output.stripTrailingZeros().scale() <= 0) {
            this.dataConfig.set("playerData." + playerUUID + "." + dataPoint, (Object)output.stripTrailingZeros().toPlainString());
            return;
        }
        this.dataConfig.set("playerData." + playerUUID + "." + dataPoint, (Object)output.toPlainString());
    }

    public UUID getOffline(String playerName) {
        return Bukkit.getOfflinePlayer((String)playerName).getUniqueId();
    }
}

