/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.generatepanels;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import me.rockyhawk.commandpanels.CommandPanels;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.ioclasses.legacy.MinecraftVersions;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class GenUtils
implements Listener {
    public YamlConfiguration tempEdit;
    CommandPanels plugin;

    public GenUtils(CommandPanels pl) {
        this.plugin = pl;
        this.tempEdit = YamlConfiguration.loadConfiguration((File)new File(this.plugin.getDataFolder() + File.separator + "temp.yml"));
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent e) {
        Player p = (Player)e.getPlayer();
        if (!ChatColor.stripColor((String)e.getView().getTitle()).equals("Generate New Panel")) {
            return;
        }
        this.plugin.reloadPanelFiles();
        this.generatePanel(p, e.getInventory());
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent e) {
        Player p = e.getPlayer();
        this.plugin.generateMode.remove(p);
    }

    @EventHandler
    public void onInventoryOpenEvent(InventoryOpenEvent e) {
        HumanEntity h = e.getPlayer();
        Player p = Bukkit.getPlayer((String)h.getName());
        if (this.plugin.generateMode.contains(p)) {
            this.plugin.generateMode.remove(p);
            this.generatePanel(p, e.getInventory());
        }
    }

    void generatePanel(Player p, Inventory inv) {
        ArrayList<String> apanels = new ArrayList<String>();
        for (Panel panel : this.plugin.panelList) {
            apanels.add(panel.getName());
        }
        boolean foundItem = false;
        for (ItemStack temp : inv.getContents()) {
            if (temp == null) continue;
            foundItem = true;
            break;
        }
        if (!foundItem) {
            p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.RED + "Cancelled Panel!"));
            return;
        }
        String date = "panel-1";
        int count = 1;
        while (Arrays.asList((Object[])Objects.requireNonNull(this.plugin.panelsf.list())).contains("panel-" + count + ".yml") || apanels.contains("panel-" + count)) {
            date = "panel-" + (count + 1);
            ++count;
        }
        File folder = new File(this.plugin.getDataFolder() + File.separator + "panels");
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)new File(folder + File.separator + date + ".yml"));
        yamlConfiguration.set("panels." + date + ".perm", (Object)"default");
        if (inv.getType().toString().contains("CHEST")) {
            yamlConfiguration.set("panels." + date + ".rows", (Object)(inv.getSize() / 9));
        } else {
            yamlConfiguration.set("panels." + date + ".rows", (Object)inv.getType().toString());
        }
        yamlConfiguration.set("panels." + date + ".title", (Object)("&8Generated " + date));
        yamlConfiguration.addDefault("panels." + date + ".command", (Object)date);
        if (this.plugin.legacy.LOCAL_VERSION.lessThanOrEqualTo(MinecraftVersions.v1_15)) {
            yamlConfiguration.set("panels." + date + ".empty", (Object)"STAINED_GLASS_PANE");
            yamlConfiguration.set("panels." + date + ".emptyID", (Object)"15");
        } else {
            yamlConfiguration.set("panels." + date + ".empty", (Object)"BLACK_STAINED_GLASS_PANE");
        }
        YamlConfiguration yamlConfiguration2 = this.plugin.itemCreate.generatePanelFile(date, inv, yamlConfiguration);
        try {
            yamlConfiguration2.save(new File(this.plugin.panelsf + File.separator + date + ".yml"));
            p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Saved Generated File To: " + date + ".yml"));
        }
        catch (IOException var16) {
            p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.RED + "Could Not Save Generated Panel!"));
        }
        this.plugin.reloadPanelFiles();
    }
}

