/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.ingameeditor;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.rockyhawk.commandpanels.CommandPanels;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.openpanelsmanager.PanelOpenType;
import me.rockyhawk.commandpanels.openpanelsmanager.PanelPosition;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class EditorUserInput
implements Listener {
    CommandPanels plugin;

    public EditorUserInput(CommandPanels pl) {
        this.plugin = pl;
    }

    @EventHandler
    public void onPlayerChatEditor(AsyncPlayerChatEvent e) {
        final Player p = e.getPlayer();
        for (String[] temp : this.plugin.editorInputStrings) {
            if (!temp[0].equals(p.getName())) continue;
            e.setCancelled(true);
            final String panelName = temp[1];
            String panelTitle = temp[1];
            File panelFile = null;
            String section = temp[2];
            YamlConfiguration cfile = null;
            ConfigurationSection cf = null;
            try {
                for (Panel panel : this.plugin.panelList) {
                    if (!panel.getName().equals(panelName)) continue;
                    cf = panel.getConfig();
                    cfile = YamlConfiguration.loadConfiguration((File)panel.getFile());
                    panelFile = panel.getFile();
                    panelTitle = this.plugin.tex.colour(cf.getString("title"));
                    break;
                }
            }
            catch (Exception fail) {
                this.plugin.debug(fail, p);
                this.plugin.editorInputStrings.remove(temp);
                return;
            }
            if (e.getMessage().equalsIgnoreCase(this.plugin.config.getString("config.input-cancel"))) {
                this.plugin.editorInputStrings.remove(temp);
                this.plugin.reloadPanelFiles();
                e.getPlayer().sendMessage(this.plugin.tex.colour(Objects.requireNonNull(this.plugin.config.getString("config.input-cancelled"))));
                return;
            }
            this.plugin.editorInputStrings.remove(temp);
            if (section.startsWith("panel.")) {
                this.panelSectionCheck(p, section, panelName, panelTitle, cf, cfile, panelFile, e);
            } else if (section.startsWith("item:")) {
                this.itemSectionCheck(p, section, panelName, cf, cfile, panelFile, e);
            } else if (section.startsWith("section.")) {
                this.itemSectionSectionCheck(p, section, panelName, cf, cfile, panelFile, e);
            }
            this.plugin.reloadPanelFiles();
            if (section.startsWith("panel.")) {
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        EditorUserInput.this.plugin.editorGuis.openEditorGui(p, 0);
                    }
                });
            } else if (section.startsWith("item:")) {
                final ConfigurationSection finalCF = cf;
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        EditorUserInput.this.plugin.createGUI.openGui(new Panel(finalCF, panelName), p, PanelPosition.Top, PanelOpenType.Editor, 0);
                    }
                });
            } else if (section.startsWith("section.")) {
                final String itemSection = ChatColor.stripColor((String)section.replace("section." + section.split("\\.")[1] + ".", ""));
                final ConfigurationSection finalCF = cf.getConfigurationSection("item." + itemSection);
                if (section.contains("change")) {
                    final String changeItemSection = itemSection.substring(0, itemSection.lastIndexOf("."));
                    final ConfigurationSection changeFinalCF = cf.getConfigurationSection("item." + changeItemSection);
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                        @Override
                        public void run() {
                            EditorUserInput.this.plugin.editorGuis.openItemSections(p, panelName, changeFinalCF, changeItemSection);
                        }
                    });
                } else {
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                        @Override
                        public void run() {
                            EditorUserInput.this.plugin.editorGuis.openItemSections(p, panelName, finalCF, itemSection);
                        }
                    });
                }
            }
            return;
        }
    }

    boolean savePanelFile(ConfigurationSection cf, YamlConfiguration cfile, String panelName, File panelFile) {
        try {
            cfile.set("panels." + panelName, (Object)cf);
            cfile.save(panelFile);
            return true;
        }
        catch (Exception io) {
            this.plugin.debug(io, null);
            return false;
        }
    }

    void panelSectionCheck(Player p, String section, String panelName, String panelTitle, ConfigurationSection cf, YamlConfiguration cfile, File panelFile, AsyncPlayerChatEvent e) {
        switch (section) {
            case "panel.delete": {
                if (!e.getMessage().contains("y")) break;
                if (Objects.requireNonNull(cfile.getConfigurationSection("panels")).getKeys(false).size() != 1) {
                    if (this.savePanelFile(null, cfile, panelName, panelFile)) {
                        p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Deleted Panel!"));
                        break;
                    }
                    p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.RED + "Could Not Delete Panel!"));
                    break;
                }
                if (panelFile.delete()) {
                    p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Deleted Panel!"));
                    break;
                }
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.RED + "Could Not Delete Panel!"));
                break;
            }
            case "panel.perm": {
                if (e.getMessage().contains(" ")) {
                    p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.RED + "Permission cannot contain spaces!"));
                    break;
                }
                cf.set("perm", (Object)e.getMessage());
                this.savePanelFile(cf, cfile, panelName, panelFile);
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Permission required is now commandpanel.panel." + e.getMessage()));
                break;
            }
            case "panel.rows": {
                try {
                    int rows = Integer.parseInt(e.getMessage());
                    if (rows >= 7 || rows <= 0) {
                        p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Choose an integer between 1 to 6!"));
                        return;
                    }
                    cf.set("rows", (Object)rows);
                    this.savePanelFile(cf, cfile, panelName, panelFile);
                    p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Set Panel to " + rows + " rows!"));
                }
                catch (Exception io) {
                    this.plugin.debug(io, p);
                }
                break;
            }
            case "panel.title": {
                if (panelTitle.equals(this.plugin.tex.colour(e.getMessage()))) {
                    p.sendMessage(this.plugin.tex.colour(this.plugin.tag + e.getMessage() + ChatColor.RED + " is in use from another panel!"));
                    break;
                }
                cf.set("title", (Object)e.getMessage());
                this.savePanelFile(cf, cfile, panelName, panelFile);
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Set new Title to " + ChatColor.WHITE + e.getMessage()));
                break;
            }
            case "panel.name": {
                if (e.getMessage().contains(" ")) {
                    p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.RED + "Panel name cannot contain spaces!"));
                    break;
                }
                if (panelName.equals(e.getMessage())) {
                    p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.RED + e.getMessage() + " is in use from another panel!"));
                    break;
                }
                cfile.set("panels." + e.getMessage(), cfile.get("panels." + panelName));
                this.savePanelFile(null, cfile, panelName, panelFile);
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Set new Name to " + e.getMessage()));
                break;
            }
            case "panel.empty": {
                if (e.getMessage().trim().equalsIgnoreCase("remove")) {
                    cf.set("empty", null);
                    this.savePanelFile(cf, cfile, panelName, panelFile);
                    p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Empty materials have been removed."));
                    break;
                }
                String materialTemp = null;
                try {
                    materialTemp = Objects.requireNonNull(Material.matchMaterial((String)e.getMessage())).toString();
                }
                catch (NullPointerException ex) {
                    p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.RED + e.getMessage() + " is not a valid Material!"));
                }
                cf.set("empty", (Object)materialTemp);
                this.savePanelFile(cf, cfile, panelName, panelFile);
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Set Empty material to " + materialTemp));
                break;
            }
            case "panel.sound-on-open": {
                String tempSound;
                if (e.getMessage().trim().equalsIgnoreCase("remove")) {
                    cf.set("sound-on-open", null);
                    this.savePanelFile(cf, cfile, panelName, panelFile);
                    p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Sounds have been removed."));
                    break;
                }
                try {
                    tempSound = Sound.valueOf((String)e.getMessage()).toString();
                }
                catch (Exception ex) {
                    p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.RED + e.getMessage() + " is not a valid Sound!"));
                    return;
                }
                cf.set("sound-on-open", (Object)tempSound);
                this.savePanelFile(cf, cfile, panelName, panelFile);
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Sound when opening is now " + tempSound));
                break;
            }
            case "panel.panelType.add": {
                List<String> typeAdd = new ArrayList<String>();
                if (cf.contains("panelType")) {
                    typeAdd = cf.getStringList("panelType");
                }
                typeAdd.add(e.getMessage().toLowerCase());
                cf.set("panelType", typeAdd);
                this.savePanelFile(cf, cfile, panelName, panelFile);
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Added new panel type: " + e.getMessage().toLowerCase()));
                break;
            }
            case "panel.panelType.remove": {
                if (!cf.contains("panelType")) {
                    p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.RED + "No types found to remove!"));
                    break;
                }
                List typeRemove = cf.getStringList("panelType");
                try {
                    typeRemove.remove(Integer.parseInt(e.getMessage()) - 1);
                }
                catch (Exception ex) {
                    p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.RED + "Could not find type!"));
                    break;
                }
                if (typeRemove.size() == 0) {
                    cf.set("panelType", null);
                } else {
                    cf.set("panelType", (Object)typeRemove);
                }
                this.savePanelFile(cf, cfile, panelName, panelFile);
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Removed panel type " + e.getMessage()));
                break;
            }
            case "panel.commands.add": {
                List<String> commandsAdd = new ArrayList<String>();
                if (cf.contains("commands")) {
                    commandsAdd = cf.getStringList("commands");
                }
                commandsAdd.add(e.getMessage());
                cf.set("commands", commandsAdd);
                this.savePanelFile(cf, cfile, panelName, panelFile);
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Added new command: " + e.getMessage()));
                break;
            }
            case "panel.commands.remove": {
                if (!cf.contains("commands")) {
                    p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.RED + "No commands found to remove!"));
                    break;
                }
                List commandsRemove = cf.getStringList("commands");
                try {
                    commandsRemove.remove(Integer.parseInt(e.getMessage()) - 1);
                }
                catch (Exception ex) {
                    p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.RED + "Could not find command!"));
                    break;
                }
                if (commandsRemove.size() == 0) {
                    cf.set("commands", null);
                } else {
                    cf.set("commands", (Object)commandsRemove);
                }
                this.savePanelFile(cf, cfile, panelName, panelFile);
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Removed command line " + e.getMessage()));
                break;
            }
            case "panel.commands-on-open.add": {
                List<String> commandsOnOpenAdd = new ArrayList<String>();
                if (cf.contains("commands-on-open")) {
                    commandsOnOpenAdd = cf.getStringList("commands-on-open");
                }
                commandsOnOpenAdd.add(e.getMessage());
                cf.set("commands-on-open", commandsOnOpenAdd);
                this.savePanelFile(cf, cfile, panelName, panelFile);
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Added new command: " + e.getMessage()));
                break;
            }
            case "panel.commands-on-open.remove": {
                if (!cf.contains("commands-on-open")) {
                    p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.RED + "No commands found to remove!"));
                    break;
                }
                List commandsOnOpenRemove = cf.getStringList("commands-on-open");
                try {
                    commandsOnOpenRemove.remove(Integer.parseInt(e.getMessage()) - 1);
                }
                catch (Exception ex) {
                    p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.RED + "Could not find command!"));
                    break;
                }
                if (commandsOnOpenRemove.size() == 0) {
                    cf.set("commands-on-open", null);
                } else {
                    cf.set("commands-on-open", (Object)commandsOnOpenRemove);
                }
                this.savePanelFile(cf, cfile, panelName, panelFile);
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Removed command line " + e.getMessage()));
                break;
            }
            case "panel.disabled-worlds.add": {
                List<String> disabledWorldsAdd = new ArrayList<String>();
                if (cf.contains("disabled-worlds")) {
                    disabledWorldsAdd = cf.getStringList("disabled-worlds");
                }
                disabledWorldsAdd.add(e.getMessage());
                cf.set("disabled-worlds", disabledWorldsAdd);
                this.savePanelFile(cf, cfile, panelName, panelFile);
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Added new World: " + e.getMessage()));
                break;
            }
            case "panel.disabled-worlds.remove": {
                if (!cf.contains("disabled-worlds")) {
                    p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.RED + "No Worlds found to remove!"));
                    break;
                }
                List disabledWorldsRemove = cf.getStringList("disabled-worlds");
                try {
                    disabledWorldsRemove.remove(Integer.parseInt(e.getMessage()) - 1);
                }
                catch (Exception ex) {
                    p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.RED + "Could not find World!"));
                    break;
                }
                if (disabledWorldsRemove.size() == 0) {
                    cf.set("disabled-worlds", null);
                } else {
                    cf.set("disabled-worlds", (Object)disabledWorldsRemove);
                }
                this.savePanelFile(cf, cfile, panelName, panelFile);
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Removed World line " + e.getMessage()));
                break;
            }
            case "panel.hotbar.material": {
                if (e.getMessage().trim().equalsIgnoreCase("remove")) {
                    cf.set("open-with-item", null);
                    this.savePanelFile(cf, cfile, panelName, panelFile);
                    p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Hotbar item have been removed."));
                    this.plugin.reloadPanelFiles();
                    break;
                }
                cf.set("open-with-item.material", (Object)e.getMessage());
                if (!cf.contains("open-with-item.name")) {
                    cf.set("open-with-item.name", (Object)(panelName + " Item"));
                }
                this.savePanelFile(cf, cfile, panelName, panelFile);
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Set new Material to " + ChatColor.WHITE + e.getMessage()));
                this.plugin.reloadPanelFiles();
                break;
            }
            case "panel.hotbar.stationary": {
                if (e.getMessage().trim().equalsIgnoreCase("remove")) {
                    cf.set("open-with-item.stationary", null);
                    this.savePanelFile(cf, cfile, panelName, panelFile);
                    p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Hotbar item can now be moved."));
                    break;
                }
                try {
                    int loc = Integer.parseInt(e.getMessage());
                    if (loc >= 36 || loc <= -1) {
                        p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Choose an integer between 0 to 35!"));
                        return;
                    }
                    p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Set Hotbar Location to " + loc + "!"));
                    cf.set("open-with-item.stationary", (Object)loc);
                    this.savePanelFile(cf, cfile, panelName, panelFile);
                }
                catch (Exception io) {
                    this.plugin.debug(io, p);
                }
                this.plugin.hotbar.reloadHotbarSlots();
                break;
            }
            case "panel.hotbar.name": {
                cf.set("open-with-item.name", (Object)e.getMessage());
                this.savePanelFile(cf, cfile, panelName, panelFile);
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Set new Name to " + ChatColor.WHITE + e.getMessage()));
                break;
            }
            case "panel.hotbar.lore.add": {
                List<String> loreAdd = new ArrayList<String>();
                if (cf.contains("open-with-item.lore")) {
                    loreAdd = cf.getStringList("open-with-item.lore");
                }
                loreAdd.add(e.getMessage());
                cf.set("open-with-item.lore", loreAdd);
                this.savePanelFile(cf, cfile, panelName, panelFile);
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Added new lore: " + e.getMessage()));
                break;
            }
            case "panel.hotbar.lore.remove": {
                if (!cf.contains("open-with-item.lore")) {
                    p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.RED + "No lore found to remove!"));
                    break;
                }
                List loreRemove = cf.getStringList("open-with-item.lore");
                try {
                    loreRemove.remove(Integer.parseInt(e.getMessage()) - 1);
                }
                catch (Exception ex) {
                    p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.RED + "Could not find lore!"));
                    break;
                }
                if (loreRemove.size() == 0) {
                    cf.set("open-with-item.lore", null);
                } else {
                    cf.set("open-with-item.lore", (Object)loreRemove);
                }
                this.savePanelFile(cf, cfile, panelName, panelFile);
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Removed lore line " + e.getMessage()));
                break;
            }
            case "panel.hotbar.commands.add": {
                List<String> commandAdd = new ArrayList<String>();
                if (cf.contains("open-with-item.commands")) {
                    commandAdd = cf.getStringList("open-with-item.commands");
                }
                commandAdd.add(e.getMessage());
                cf.set("open-with-item.commands", commandAdd);
                this.savePanelFile(cf, cfile, panelName, panelFile);
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Added new command: " + e.getMessage()));
                break;
            }
            case "panel.hotbar.commands.remove": {
                if (!cf.contains("open-with-item.commands")) {
                    p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.RED + "No commands found to remove!"));
                    break;
                }
                List commandRemove = cf.getStringList("open-with-item.commands");
                try {
                    commandRemove.remove(Integer.parseInt(e.getMessage()) - 1);
                }
                catch (Exception ex) {
                    p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.RED + "Could not find command!"));
                    break;
                }
                if (commandRemove.size() == 0) {
                    cf.set("open-with-item.commands", null);
                } else {
                    cf.set("open-with-item.commands", (Object)commandRemove);
                }
                this.savePanelFile(cf, cfile, panelName, panelFile);
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Removed command line " + e.getMessage()));
            }
        }
    }

    void itemSectionCheck(Player p, String section, String panelName, ConfigurationSection cf, YamlConfiguration cfile, File panelFile, AsyncPlayerChatEvent e) {
        String sectionChange;
        String itemSlot = section.split(":")[1];
        switch (sectionChange = section.replace("item:" + itemSlot + ":", "")) {
            case "name": {
                if (e.getMessage().trim().equalsIgnoreCase("remove")) {
                    cf.set("item." + itemSlot + ".name", (Object)"");
                    this.savePanelFile(cf, cfile, panelName, panelFile);
                    p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Name is now default."));
                    break;
                }
                cf.set("item." + itemSlot + ".name", (Object)e.getMessage());
                this.savePanelFile(cf, cfile, panelName, panelFile);
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Set new name to " + ChatColor.WHITE + e.getMessage()));
                break;
            }
            case "head": {
                if (e.getMessage().trim().equalsIgnoreCase("remove")) {
                    cf.set("item." + itemSlot + ".material", (Object)this.plugin.getHeads.playerHeadString());
                    this.savePanelFile(cf, cfile, panelName, panelFile);
                    p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Material is now default."));
                    break;
                }
                cf.set("item." + itemSlot + ".material", (Object)e.getMessage());
                this.savePanelFile(cf, cfile, panelName, panelFile);
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Set Material value to " + ChatColor.WHITE + e.getMessage()));
                break;
            }
            case "stack": {
                if (e.getMessage().trim().equalsIgnoreCase("remove")) {
                    cf.set("item." + itemSlot + ".stack", null);
                    this.savePanelFile(cf, cfile, panelName, panelFile);
                    p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Item has been unstacked."));
                    break;
                }
                try {
                    int rows = Integer.parseInt(e.getMessage());
                    if (rows >= 65 || rows <= 0) {
                        p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Choose an integer between 1 to 64!"));
                        return;
                    }
                    cf.set("item." + itemSlot + ".stack", (Object)rows);
                    this.savePanelFile(cf, cfile, panelName, panelFile);
                    p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Set stack to " + rows + "!"));
                }
                catch (Exception io) {
                    this.plugin.debug(io, p);
                }
                break;
            }
            case "enchanted": {
                if (e.getMessage().trim().equalsIgnoreCase("remove")) {
                    cf.set("item." + itemSlot + ".enchanted", null);
                    this.savePanelFile(cf, cfile, panelName, panelFile);
                    p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Enchantments have been removed."));
                    break;
                }
                cf.set("item." + itemSlot + ".enchanted", (Object)e.getMessage());
                this.savePanelFile(cf, cfile, panelName, panelFile);
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Set new Enchantment to " + ChatColor.WHITE + e.getMessage()));
                break;
            }
            case "potion": {
                if (e.getMessage().trim().equalsIgnoreCase("remove")) {
                    cf.set("item." + itemSlot + ".potion", null);
                    this.savePanelFile(cf, cfile, panelName, panelFile);
                    p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Potion effects have been removed."));
                    break;
                }
                cf.set("item." + itemSlot + ".potion", (Object)e.getMessage());
                this.savePanelFile(cf, cfile, panelName, panelFile);
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Set new Potion to " + e.getMessage().toUpperCase()));
                break;
            }
            case "customdata": {
                if (e.getMessage().trim().equalsIgnoreCase("remove")) {
                    cf.set("item." + itemSlot + ".customdata", null);
                    this.savePanelFile(cf, cfile, panelName, panelFile);
                    p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Custom Model Data has been removed."));
                    break;
                }
                cf.set("item." + itemSlot + ".customdata", (Object)e.getMessage());
                this.savePanelFile(cf, cfile, panelName, panelFile);
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Custom Model Data set to " + e.getMessage()));
                break;
            }
            case "leatherarmor": {
                if (e.getMessage().trim().equalsIgnoreCase("remove")) {
                    cf.set("item." + itemSlot + ".leatherarmor", null);
                    this.savePanelFile(cf, cfile, panelName, panelFile);
                    p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Leather armor colour has been removed."));
                    break;
                }
                cf.set("item." + itemSlot + ".leatherarmor", (Object)e.getMessage());
                this.savePanelFile(cf, cfile, panelName, panelFile);
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Leather armor colour set to " + e.getMessage()));
                break;
            }
            case "commands:add": {
                List<String> commandsOnOpenAdd = new ArrayList<String>();
                if (cf.contains("item." + itemSlot + ".commands")) {
                    commandsOnOpenAdd = cf.getStringList("item." + itemSlot + ".commands");
                }
                commandsOnOpenAdd.add(e.getMessage());
                cf.set("item." + itemSlot + ".commands", commandsOnOpenAdd);
                this.savePanelFile(cf, cfile, panelName, panelFile);
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Added new command: " + e.getMessage()));
                break;
            }
            case "commands:remove": {
                if (!cf.contains("item." + itemSlot + ".commands")) {
                    p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.RED + "No commands found to remove!"));
                    break;
                }
                List commandsOnOpenRemove = cf.getStringList("item." + itemSlot + ".commands");
                try {
                    commandsOnOpenRemove.remove(Integer.parseInt(e.getMessage()) - 1);
                }
                catch (Exception ex) {
                    p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.RED + "Could not find command!"));
                    this.plugin.debug(ex, p);
                    break;
                }
                if (commandsOnOpenRemove.size() == 0) {
                    cf.set("item." + itemSlot + ".commands", null);
                } else {
                    cf.set("item." + itemSlot + ".commands", (Object)commandsOnOpenRemove);
                }
                this.savePanelFile(cf, cfile, panelName, panelFile);
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Removed command line " + e.getMessage()));
                break;
            }
            case "lore:add": {
                List<String> loreOnOpenAdd = new ArrayList<String>();
                if (cf.contains("item." + itemSlot + ".lore")) {
                    loreOnOpenAdd = cf.getStringList("item." + itemSlot + ".lore");
                }
                loreOnOpenAdd.add(e.getMessage());
                cf.set("item." + itemSlot + ".lore", loreOnOpenAdd);
                this.savePanelFile(cf, cfile, panelName, panelFile);
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Added new lore: " + e.getMessage()));
                break;
            }
            case "lore:remove": {
                if (!cf.contains("item." + itemSlot + ".lore")) {
                    p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.RED + "No lore found to remove!"));
                    break;
                }
                List loreOnOpenRemove = cf.getStringList("item." + itemSlot + ".lore");
                try {
                    loreOnOpenRemove.remove(Integer.parseInt(e.getMessage()) - 1);
                }
                catch (Exception ex) {
                    p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.RED + "Could not find lore!"));
                    this.plugin.debug(ex, p);
                    break;
                }
                if (loreOnOpenRemove.size() == 0) {
                    cf.set("item." + itemSlot + ".lore", null);
                } else {
                    cf.set("item." + itemSlot + ".lore", (Object)loreOnOpenRemove);
                }
                this.savePanelFile(cf, cfile, panelName, panelFile);
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Removed lore line " + e.getMessage()));
                break;
            }
            case "duplicate:add": {
                if (cf.contains("item." + itemSlot + ".duplicate")) {
                    cf.set("item." + itemSlot + ".duplicate", (Object)(cf.getString("item." + itemSlot + ".duplicate") + "," + e.getMessage()));
                } else {
                    cf.set("item." + itemSlot + ".duplicate", (Object)e.getMessage());
                }
                this.savePanelFile(cf, cfile, panelName, panelFile);
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Added new duplicate item/s: " + e.getMessage()));
                break;
            }
            case "duplicate:remove": {
                if (cf.contains("item." + itemSlot + ".duplicate")) {
                    if (cf.getString("item." + itemSlot + ".duplicate").contains(",")) {
                        try {
                            String[] duplicateItems = cf.getString("item." + itemSlot + ".duplicate").split(",");
                            StringBuilder items = new StringBuilder();
                            for (int s = 0; s < duplicateItems.length; ++s) {
                                if (Integer.parseInt(e.getMessage()) == s + 1) continue;
                                items.append(duplicateItems[s]);
                                items.append(",");
                            }
                            cf.set("item." + itemSlot + ".duplicate", (Object)items.toString());
                        }
                        catch (Exception ex) {
                            p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.RED + "Could not delete or find item!"));
                            this.plugin.debug(ex, p);
                            break;
                        }
                        if (cf.getString("item." + itemSlot + ".duplicate").equals("")) {
                            cf.set("item." + itemSlot + ".duplicate", null);
                        }
                    } else {
                        cf.set("item." + itemSlot + ".duplicate", null);
                    }
                } else {
                    p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.RED + "No items found to remove!"));
                    break;
                }
                this.savePanelFile(cf, cfile, panelName, panelFile);
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Removed duplicate item/s: " + e.getMessage()));
            }
        }
    }

    void itemSectionSectionCheck(Player p, String section, String panelName, ConfigurationSection cf, YamlConfiguration cfile, File panelFile, AsyncPlayerChatEvent e) {
        String secondValue = section.split("\\.")[1];
        String itemSection = ChatColor.stripColor((String)section.replace("section." + secondValue + ".", ""));
        String playerMessage = ChatColor.stripColor((String)e.getMessage()).toLowerCase();
        switch (secondValue) {
            case "add": {
                cf.set("item." + itemSection + "." + playerMessage + ".output", (Object)"true");
                if (playerMessage.equals("hasperm")) {
                    cf.set("item." + itemSection + "." + playerMessage + ".perm", (Object)"admin");
                } else {
                    cf.set("item." + itemSection + "." + playerMessage + ".value", (Object)"10");
                    cf.set("item." + itemSection + "." + playerMessage + ".compare", (Object)"%cp-player-balance%");
                }
                cf.set("item." + itemSection + "." + playerMessage + ".material", (Object)"DIRT");
                cf.set("item." + itemSection + "." + playerMessage + ".name", (Object)"");
                this.savePanelFile(cf, cfile, panelName, panelFile);
                this.plugin.reloadPanelFiles();
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Added Section " + ChatColor.WHITE + playerMessage));
                break;
            }
            case "remove": {
                cf.set("item." + itemSection + "." + playerMessage, null);
                this.savePanelFile(cf, cfile, panelName, panelFile);
                this.plugin.reloadPanelFiles();
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Removed Section " + ChatColor.WHITE + playerMessage));
                break;
            }
            case "change": {
                cf.set("item." + itemSection + "." + playerMessage.split(":")[0], (Object)playerMessage.split(":")[1]);
                this.savePanelFile(cf, cfile, panelName, panelFile);
                this.plugin.reloadPanelFiles();
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Set " + playerMessage.split(":")[0] + " to " + ChatColor.WHITE + playerMessage.split(":")[1]));
            }
        }
    }
}

