/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.ingameeditor;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import me.rockyhawk.commandpanels.CommandPanels;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.openpanelsmanager.PanelOpenType;
import me.rockyhawk.commandpanels.openpanelsmanager.PanelPosition;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;

public class EditorUtils
implements Listener {
    public YamlConfiguration tempEdit;
    public ArrayList<String> inventoryItemSettingsOpening = new ArrayList();
    CommandPanels plugin;

    public EditorUtils(CommandPanels pl) {
        this.plugin = pl;
        this.tempEdit = YamlConfiguration.loadConfiguration((File)new File(this.plugin.getDataFolder() + File.separator + "temp.yml"));
    }

    @EventHandler
    public void onClickMainEdit(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        try {
            if (Objects.requireNonNull(e.getClickedInventory()).getType() != InventoryType.CHEST) {
                return;
            }
        }
        catch (NullPointerException nu) {
            return;
        }
        if (!p.getOpenInventory().getTitle().equals(ChatColor.stripColor((String)this.plugin.tex.colour("Command Panels Editor"))) || this.plugin.openPanels.hasPanelOpen(p.getName(), PanelPosition.Top)) {
            return;
        }
        if (e.getClickedInventory() != e.getView().getTopInventory()) {
            return;
        }
        if (!p.hasPermission("commandpanel.edit")) {
            return;
        }
        e.setCancelled(true);
        ArrayList<String> panelNames = new ArrayList<String>();
        ArrayList<String> panelTitles = new ArrayList<String>();
        ArrayList<ConfigurationSection> panelYaml = new ArrayList<ConfigurationSection>();
        try {
            for (Panel panel : this.plugin.panelList) {
                panelNames.add(this.plugin.tex.colour(panel.getName()));
                panelTitles.add(this.plugin.tex.colour(Objects.requireNonNull(panel.getConfig().getString("title"))));
                panelYaml.add(panel.getConfig());
            }
        }
        catch (Exception fail) {
            this.plugin.debug(fail, p);
            return;
        }
        if (e.getSlot() == 48) {
            try {
                if (Objects.requireNonNull(e.getCurrentItem()).getType() == Material.PAPER) {
                    this.plugin.editorGuis.openEditorGui(p, -1);
                    p.updateInventory();
                    return;
                }
            }
            catch (NullPointerException fail) {
                // empty catch block
            }
        }
        if (e.getSlot() == 49 && Objects.requireNonNull(e.getCurrentItem()).getType() == Material.SLIME_BALL) {
            p.updateInventory();
            return;
        }
        if (e.getSlot() == 50) {
            try {
                if (Objects.requireNonNull(e.getCurrentItem()).getType() == Material.PAPER) {
                    this.plugin.editorGuis.openEditorGui(p, 1);
                    p.updateInventory();
                    return;
                }
            }
            catch (NullPointerException fail) {
                // empty catch block
            }
        }
        if (e.getSlot() == 45) {
            p.closeInventory();
            p.updateInventory();
            return;
        }
        if (e.getSlot() <= 44) {
            try {
                if (Objects.requireNonNull(e.getCurrentItem()).getType() != Material.AIR) {
                    if (e.getClick().isLeftClick() && !e.getClick().isShiftClick()) {
                        int count = 0;
                        for (String panelName : panelNames) {
                            if (panelName.equals(ChatColor.stripColor((String)Objects.requireNonNull(e.getCurrentItem().getItemMeta()).getDisplayName()))) {
                                this.plugin.createGUI.openGui(new Panel((ConfigurationSection)panelYaml.get(count), panelName), p, PanelPosition.Top, PanelOpenType.Editor, 0);
                                return;
                            }
                            ++count;
                        }
                    } else {
                        int count = 0;
                        for (String panelName : panelNames) {
                            if (panelName.equals(ChatColor.stripColor((String)Objects.requireNonNull(e.getCurrentItem().getItemMeta()).getDisplayName()))) {
                                this.plugin.editorGuis.openPanelSettings(p, panelName, (ConfigurationSection)panelYaml.get(count));
                                return;
                            }
                            ++count;
                        }
                        p.updateInventory();
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        p.updateInventory();
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent e) {
        Player p = (Player)e.getWhoClicked();
        if (!p.getOpenInventory().getTitle().contains("Editing Panel:") || this.plugin.openPanels.hasPanelOpen(p.getName(), PanelPosition.Top)) {
            return;
        }
        if (!p.hasPermission("commandpanel.edit")) {
            return;
        }
        String panelName = "";
        File file = null;
        YamlConfiguration config = new YamlConfiguration();
        boolean found = false;
        try {
            for (Panel panel : this.plugin.panelList) {
                if (!e.getView().getTitle().equals("Editing Panel: " + panel.getName())) continue;
                panelName = panel.getName();
                file = panel.getFile();
                config = YamlConfiguration.loadConfiguration((File)panel.getFile());
                found = true;
                break;
            }
        }
        catch (Exception fail) {
            this.plugin.debug(fail, p);
            return;
        }
        if (!found) {
            return;
        }
        try {
            if (this.tempEdit.contains("panels." + panelName + ".temp." + p.getName() + ".material") && e.getOldCursor().getType() != Material.matchMaterial((String)Objects.requireNonNull(this.tempEdit.getString("panels." + panelName + ".temp." + p.getName() + ".material")))) {
                this.clearTemp(p, panelName);
                return;
            }
        }
        catch (Exception ex) {
            return;
        }
        if (this.tempEdit.contains("panels." + panelName + ".temp." + p.getName())) {
            try {
                Iterator ex = e.getInventorySlots().iterator();
                while (ex.hasNext()) {
                    int slot = (Integer)ex.next();
                    config.set("panels." + panelName + ".item." + slot, this.tempEdit.get("panels." + panelName + ".temp." + p.getName()));
                    if (config.contains("panels." + panelName + ".item." + slot + ".stack")) {
                        config.set("panels." + panelName + ".item." + slot + ".stack", null);
                    }
                    this.saveFile(file, config);
                    this.saveFile(file, config);
                }
            }
            catch (NullPointerException nu) {
                this.plugin.debug(nu, p);
            }
        }
    }

    @EventHandler
    public void onInventoryEdit(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        if (!p.getOpenInventory().getTitle().contains("Editing Panel:") || this.plugin.openPanels.hasPanelOpen(p.getName(), PanelPosition.Top)) {
            return;
        }
        if (!p.hasPermission("commandpanel.edit")) {
            return;
        }
        String panelName = "";
        File file = null;
        YamlConfiguration config = new YamlConfiguration();
        boolean found = false;
        try {
            for (Panel panel : this.plugin.panelList) {
                if (!e.getView().getTitle().equals("Editing Panel: " + panel.getName())) continue;
                panelName = panel.getName();
                file = panel.getFile();
                config = YamlConfiguration.loadConfiguration((File)panel.getFile());
                found = true;
                break;
            }
        }
        catch (Exception fail) {
            this.plugin.debug(fail, p);
            return;
        }
        if (!found) {
            return;
        }
        if (e.getClick().isShiftClick() && e.getClickedInventory() == e.getView().getTopInventory()) {
            if (e.getInventory().getItem(e.getSlot()) == null) {
                return;
            }
            this.onEditPanelClose(p, e.getInventory(), e.getView());
            this.inventoryItemSettingsOpening.add(p.getName());
            config = YamlConfiguration.loadConfiguration((File)file);
            this.plugin.editorGuis.openItemSettings(p, panelName, config.getConfigurationSection("panels." + panelName + ".item." + e.getSlot()), String.valueOf(e.getSlot()));
            p.updateInventory();
            return;
        }
        if (this.tempEdit.contains("panels." + panelName + ".temp." + p.getName() + ".material") && !this.plugin.getHeads.ifSkullOrHead(Objects.requireNonNull(e.getCursor()).getType().toString()) && e.getCursor().getType() != Material.matchMaterial((String)Objects.requireNonNull(this.tempEdit.getString("panels." + panelName + ".temp." + p.getName() + ".material")))) {
            this.clearTemp(p, panelName);
        }
        if (e.getSlot() == -999) {
            if (e.getCurrentItem() == null) {
                this.clearTemp(p, panelName);
            }
            return;
        }
        if (e.getAction() == InventoryAction.CLONE_STACK) {
            this.saveTempItem(e, p, config, panelName);
            this.saveFile(file, config);
        } else if (e.getAction() == InventoryAction.PLACE_ALL) {
            this.loadTempItem(e, p, config, file, panelName);
            this.clearTemp(p, panelName);
            this.saveFile(file, config);
        } else if (e.getAction() == InventoryAction.COLLECT_TO_CURSOR) {
            this.saveTempItem(e, p, config, panelName);
            this.saveFile(file, config);
            this.removeOldItem(e, p, config, file, panelName);
        } else if (e.getAction() == InventoryAction.DROP_ALL_CURSOR) {
            e.setCancelled(true);
        } else if (e.getAction() == InventoryAction.DROP_ALL_SLOT) {
            e.setCancelled(true);
        } else if (e.getAction() == InventoryAction.DROP_ONE_CURSOR) {
            e.setCancelled(true);
        } else if (e.getAction() == InventoryAction.DROP_ONE_SLOT) {
            e.setCancelled(true);
        } else if (e.getAction() == InventoryAction.HOTBAR_MOVE_AND_READD) {
            e.setCancelled(true);
        } else if (e.getAction() == InventoryAction.HOTBAR_SWAP) {
            e.setCancelled(true);
        } else if (e.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY) {
            e.setCancelled(true);
        } else if (e.getAction() == InventoryAction.PLACE_SOME) {
            this.loadTempItem(e, p, config, file, panelName);
            this.saveFile(file, config);
        } else if (e.getAction() == InventoryAction.SWAP_WITH_CURSOR) {
            e.setCancelled(true);
        } else if (e.getAction() == InventoryAction.PICKUP_ALL) {
            this.saveTempItem(e, p, config, panelName);
            this.saveFile(file, config);
            this.removeOldItem(e, p, config, file, panelName);
        } else if (e.getAction() == InventoryAction.PICKUP_HALF) {
            this.saveTempItem(e, p, config, panelName);
            this.saveFile(file, config);
        } else if (e.getAction() == InventoryAction.PICKUP_ONE) {
            this.saveTempItem(e, p, config, panelName);
            this.saveFile(file, config);
        } else if (e.getAction() == InventoryAction.PICKUP_SOME) {
            this.saveTempItem(e, p, config, panelName);
            this.saveFile(file, config);
        } else if (e.getAction() == InventoryAction.PLACE_ONE) {
            this.loadTempItem(e, p, config, file, panelName);
            this.saveFile(file, config);
        }
    }

    @EventHandler
    public void onPlayerClosePanel(InventoryCloseEvent e) {
        if (this.plugin.openPanels.hasPanelOpen(e.getPlayer().getName(), PanelPosition.Top)) {
            this.plugin.openPanels.closePanelForLoader(e.getPlayer().getName(), PanelPosition.Top);
            return;
        }
        if (this.inventoryItemSettingsOpening.contains(e.getPlayer().getName())) {
            this.inventoryItemSettingsOpening.remove(e.getPlayer().getName());
            return;
        }
        this.onEditPanelClose((Player)e.getPlayer(), e.getInventory(), e.getView());
    }

    @EventHandler
    public void onPanelSettings(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        if (!p.getOpenInventory().getTitle().contains("Panel Settings:") || this.plugin.openPanels.hasPanelOpen(p.getName(), PanelPosition.Top)) {
            return;
        }
        if (!p.hasPermission("commandpanel.edit")) {
            return;
        }
        e.setCancelled(true);
        String panelName = "";
        boolean found = false;
        boolean hotbarItems = false;
        try {
            for (Panel panel : this.plugin.panelList) {
                if (!e.getView().getTitle().equals("Panel Settings: " + panel.getName())) continue;
                panelName = panel.getName();
                if (panel.getConfig().contains("open-with-item")) {
                    hotbarItems = true;
                }
                found = true;
                break;
            }
        }
        catch (Exception fail) {
            this.plugin.debug(fail, p);
            return;
        }
        if (!found) {
            return;
        }
        if (e.getSlot() == 1) {
            this.plugin.editorInputStrings.add(new String[]{p.getName(), panelName, "panel.perm"});
            p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.WHITE + "Enter New Permission"));
            p.closeInventory();
        }
        if (e.getSlot() == 3) {
            this.plugin.editorInputStrings.add(new String[]{p.getName(), panelName, "panel.title"});
            p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.WHITE + "Enter New Title"));
            p.closeInventory();
        }
        if (e.getSlot() == 5) {
            this.plugin.editorInputStrings.add(new String[]{p.getName(), panelName, "panel.sound-on-open"});
            p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.WHITE + "Enter New Sound ID"));
            p.closeInventory();
        }
        if (e.getSlot() == 7) {
            if (e.getClick().isLeftClick()) {
                this.plugin.editorInputStrings.add(new String[]{p.getName(), panelName, "panel.commands.add"});
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.WHITE + "Enter New Command"));
            } else {
                this.plugin.editorInputStrings.add(new String[]{p.getName(), panelName, "panel.commands.remove"});
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.WHITE + "Enter Command to remove (must be an integer)"));
            }
            p.closeInventory();
        }
        if (e.getSlot() == 21) {
            this.plugin.editorInputStrings.add(new String[]{p.getName(), panelName, "panel.delete"});
            p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.WHITE + "Are you sure? (yes/no)"));
            p.closeInventory();
        }
        if (e.getSlot() == 23) {
            this.plugin.editorInputStrings.add(new String[]{p.getName(), panelName, "panel.rows"});
            p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.WHITE + "Enter Row Amount (1 to 6)"));
            p.closeInventory();
        }
        if (e.getSlot() == 13) {
            this.plugin.editorInputStrings.add(new String[]{p.getName(), panelName, "panel.empty"});
            p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.WHITE + "Enter New Material ID"));
            p.closeInventory();
        }
        if (e.getSlot() == 15) {
            if (e.getClick().isLeftClick()) {
                this.plugin.editorInputStrings.add(new String[]{p.getName(), panelName, "panel.commands-on-open.add"});
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.WHITE + "Enter New Command"));
            } else {
                this.plugin.editorInputStrings.add(new String[]{p.getName(), panelName, "panel.commands-on-open.remove"});
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.WHITE + "Enter Command to remove (must be an integer)"));
            }
            p.closeInventory();
        }
        if (e.getSlot() == 17) {
            if (e.getClick().isLeftClick()) {
                this.plugin.editorInputStrings.add(new String[]{p.getName(), panelName, "panel.panelType.add"});
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.WHITE + "Enter New Panel type"));
            } else {
                this.plugin.editorInputStrings.add(new String[]{p.getName(), panelName, "panel.panelType.remove"});
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.WHITE + "Enter Panel Type to remove (must be an integer)"));
            }
            p.closeInventory();
        }
        if (e.getSlot() == 25) {
            if (e.getClick().isLeftClick()) {
                this.plugin.editorInputStrings.add(new String[]{p.getName(), panelName, "panel.disabled-worlds.add"});
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.WHITE + "Enter New World Name"));
            } else {
                this.plugin.editorInputStrings.add(new String[]{p.getName(), panelName, "panel.disabled-worlds.remove"});
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.WHITE + "Enter World line to remove (must be an integer)"));
            }
            p.closeInventory();
        }
        if (e.getSlot() == 11) {
            this.plugin.editorInputStrings.add(new String[]{p.getName(), panelName, "panel.name"});
            p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.WHITE + "Enter New Name"));
            p.closeInventory();
        }
        if (e.getSlot() == 18) {
            this.plugin.editorGuis.openEditorGui(p, 0);
            p.updateInventory();
        }
        if (e.getSlot() == 40) {
            this.plugin.editorInputStrings.add(new String[]{p.getName(), panelName, "panel.hotbar.material"});
            p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.WHITE + "Enter New Material"));
            p.closeInventory();
        }
        if (e.getSlot() == 38 && hotbarItems) {
            this.plugin.editorInputStrings.add(new String[]{p.getName(), panelName, "panel.hotbar.name"});
            p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.WHITE + "Enter New Name"));
            p.closeInventory();
        }
        if (e.getSlot() == 36 && hotbarItems) {
            if (e.getClick().isLeftClick()) {
                this.plugin.editorInputStrings.add(new String[]{p.getName(), panelName, "panel.hotbar.lore.add"});
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.WHITE + "Enter New Item Lore"));
            } else {
                this.plugin.editorInputStrings.add(new String[]{p.getName(), panelName, "panel.hotbar.lore.remove"});
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.WHITE + "Enter lore line to remove (must be an integer)"));
            }
            p.closeInventory();
        }
        if (e.getSlot() == 42 && hotbarItems) {
            this.plugin.editorInputStrings.add(new String[]{p.getName(), panelName, "panel.hotbar.stationary"});
            p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.WHITE + "Enter Location (0 to 35)"));
            p.closeInventory();
        }
        if (e.getSlot() == 44 && hotbarItems) {
            if (e.getClick().isLeftClick()) {
                this.plugin.editorInputStrings.add(new String[]{p.getName(), panelName, "panel.hotbar.commands.add"});
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.WHITE + "Enter New Item Command"));
            } else {
                this.plugin.editorInputStrings.add(new String[]{p.getName(), panelName, "panel.hotbar.commands.remove"});
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.WHITE + "Enter command line to remove (must be an integer)"));
            }
            p.closeInventory();
        }
    }

    @EventHandler
    public void onItemSettings(InventoryClickEvent e) {
        String itemSlot;
        Player p = (Player)e.getWhoClicked();
        if (!p.getOpenInventory().getTitle().contains("Item Settings:") || this.plugin.openPanels.hasPanelOpen(p.getName(), PanelPosition.Top)) {
            return;
        }
        if (!p.hasPermission("commandpanel.edit")) {
            return;
        }
        e.setCancelled(true);
        String panelName = "";
        ConfigurationSection panelYaml = null;
        boolean found = false;
        try {
            for (Panel panel : this.plugin.panelList) {
                if (!e.getView().getTitle().equals("Item Settings: " + panel.getName())) continue;
                panelName = panel.getName();
                panelYaml = panel.getConfig();
                found = true;
                break;
            }
        }
        catch (Exception fail) {
            this.plugin.debug(fail, p);
            return;
        }
        if (!found) {
            return;
        }
        try {
            itemSlot = ChatColor.stripColor((String)e.getView().getTopInventory().getItem(35).getItemMeta().getDisplayName().split("\\s")[2]);
        }
        catch (Exception ex) {
            this.plugin.getServer().getConsoleSender().sendMessage("[CommandPanels] Could not get item slot");
            this.plugin.debug(ex, p);
            return;
        }
        if (e.getSlot() == 1) {
            this.plugin.editorInputStrings.add(new String[]{p.getName(), panelName, "item:" + itemSlot + ":name"});
            p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.WHITE + "Enter New Item Name"));
            p.closeInventory();
        }
        if (e.getSlot() == 3) {
            if (e.getClick().isLeftClick()) {
                this.plugin.editorInputStrings.add(new String[]{p.getName(), panelName, "item:" + itemSlot + ":commands:add"});
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.WHITE + "Enter New Item Command"));
            } else {
                this.plugin.editorInputStrings.add(new String[]{p.getName(), panelName, "item:" + itemSlot + ":commands:remove"});
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.WHITE + "Enter command line to remove (must be an integer)"));
            }
            p.closeInventory();
        }
        if (e.getSlot() == 5) {
            this.plugin.editorInputStrings.add(new String[]{p.getName(), panelName, "item:" + itemSlot + ":enchanted"});
            p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.WHITE + "Enter New Item Enchantment"));
            p.closeInventory();
        }
        if (e.getSlot() == 7) {
            this.plugin.editorInputStrings.add(new String[]{p.getName(), panelName, "item:" + itemSlot + ":potion"});
            p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.WHITE + "Enter New Item Potion Effect"));
            p.closeInventory();
        }
        if (e.getSlot() == 13) {
            if (e.getClick().isLeftClick()) {
                this.plugin.editorInputStrings.add(new String[]{p.getName(), panelName, "item:" + itemSlot + ":duplicate:add"});
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.WHITE + "Enter Duplicate Item Location/s"));
            } else {
                this.plugin.editorInputStrings.add(new String[]{p.getName(), panelName, "item:" + itemSlot + ":duplicate:remove"});
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.WHITE + "Enter Duplicate Item/s to Remove (must be an integer)"));
            }
            p.closeInventory();
        }
        if (e.getSlot() == 19) {
            if (e.getClick().isLeftClick()) {
                this.plugin.editorInputStrings.add(new String[]{p.getName(), panelName, "item:" + itemSlot + ":lore:add"});
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.WHITE + "Enter New Item Lore"));
            } else {
                this.plugin.editorInputStrings.add(new String[]{p.getName(), panelName, "item:" + itemSlot + ":lore:remove"});
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.WHITE + "Enter lore line to remove (must be an integer)"));
            }
            p.closeInventory();
        }
        if (e.getSlot() == 21) {
            this.plugin.editorInputStrings.add(new String[]{p.getName(), panelName, "item:" + itemSlot + ":stack"});
            p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.WHITE + "Enter New Item Stack (must be an integer)"));
            p.closeInventory();
        }
        if (e.getSlot() == 23) {
            this.plugin.editorInputStrings.add(new String[]{p.getName(), panelName, "item:" + itemSlot + ":customdata"});
            p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.WHITE + "Enter New Custom Model Data"));
            p.closeInventory();
        }
        if (e.getSlot() == 25) {
            this.plugin.editorInputStrings.add(new String[]{p.getName(), panelName, "item:" + itemSlot + ":leatherarmor"});
            p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.WHITE + "Enter New Leather Armor Colour"));
            p.closeInventory();
        }
        if (e.getSlot() == 31) {
            this.plugin.editorGuis.openItemSections(p, panelName, panelYaml.getConfigurationSection("item." + itemSlot), itemSlot);
            p.updateInventory();
        }
        if (e.getSlot() == 35) {
            this.plugin.editorInputStrings.add(new String[]{p.getName(), panelName, "item:" + itemSlot + ":head"});
            p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.WHITE + "Enter New Custom Material (eg. cps= self)"));
            p.closeInventory();
        }
        if (e.getSlot() == 27) {
            if (itemSlot.contains(".")) {
                String newSection = itemSlot.substring(0, itemSlot.lastIndexOf("."));
                this.plugin.editorGuis.openItemSections(p, panelName, panelYaml.getConfigurationSection("item." + newSection), newSection);
            } else {
                this.plugin.createGUI.openGui(new Panel(panelYaml, panelName), p, PanelPosition.Top, PanelOpenType.Editor, 0);
            }
            p.updateInventory();
        }
    }

    @EventHandler
    public void onItemSection(InventoryClickEvent e) {
        String section;
        Player p = (Player)e.getWhoClicked();
        if (!p.getOpenInventory().getTitle().contains("Item Sections:") || this.plugin.openPanels.hasPanelOpen(p.getName(), PanelPosition.Top)) {
            return;
        }
        if (!p.hasPermission("commandpanel.edit")) {
            return;
        }
        e.setCancelled(true);
        String panelName = "";
        ConfigurationSection panelYaml = null;
        boolean found = false;
        try {
            for (Panel panel : this.plugin.panelList) {
                if (!e.getView().getTitle().equals("Item Sections: " + panel.getName())) continue;
                panelName = panel.getName();
                panelYaml = panel.getConfig();
                found = true;
                break;
            }
        }
        catch (Exception fail) {
            this.plugin.debug(fail, p);
            return;
        }
        if (!found) {
            return;
        }
        try {
            section = ChatColor.stripColor((String)Objects.requireNonNull(Objects.requireNonNull(e.getView().getTopInventory().getItem(44)).getItemMeta()).getDisplayName().split("\\s")[2]);
        }
        catch (Exception ex) {
            this.plugin.getServer().getConsoleSender().sendMessage("[CommandPanels] Could not get item slot");
            this.plugin.debug(ex, p);
            return;
        }
        ConfigurationSection itemConfSection = panelYaml.getConfigurationSection("item." + section);
        if (e.getSlot() <= 35 && e.getInventory().getItem(e.getSlot()) != null) {
            if (e.getClick().isLeftClick()) {
                String newSection = section + "." + ChatColor.stripColor((String)e.getInventory().getItem(e.getSlot()).getItemMeta().getDisplayName());
                this.plugin.editorGuis.openItemSettings(p, panelName, itemConfSection.getConfigurationSection(ChatColor.stripColor((String)e.getInventory().getItem(e.getSlot()).getItemMeta().getDisplayName())), newSection);
                p.updateInventory();
            } else {
                String itemNameSection = "." + ChatColor.stripColor((String)e.getInventory().getItem(e.getSlot()).getItemMeta().getDisplayName());
                this.plugin.editorInputStrings.add(new String[]{p.getName(), panelName, "section.change." + section + itemNameSection});
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.WHITE + "Enter Setting to change, eg, value:500"));
                p.closeInventory();
            }
        }
        if (e.getSlot() == 38) {
            this.plugin.editorInputStrings.add(new String[]{p.getName(), panelName, "section.remove." + section});
            p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.WHITE + "Enter Section name to remove, eg, hasperm or hasperm0"));
            p.closeInventory();
        }
        if (e.getSlot() == 42) {
            this.plugin.editorInputStrings.add(new String[]{p.getName(), panelName, "section.add." + section});
            p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.WHITE + "Enter Section name to add, eg, hasperm or hasperm0"));
            p.closeInventory();
        }
        if (e.getSlot() == 36) {
            this.plugin.editorGuis.openItemSettings(p, panelName, itemConfSection, section);
            p.updateInventory();
        }
    }

    public void saveTempItem(InventoryClickEvent e, Player p, YamlConfiguration file, String panelName) {
        this.tempEdit.set("panels." + panelName + ".temp." + p.getName(), file.get("panels." + panelName + ".item." + e.getSlot()));
        this.saveFile("temp.yml", this.tempEdit);
    }

    public void loadTempItem(InventoryClickEvent e, Player p, YamlConfiguration config, File file, String panelName) {
        if (this.tempEdit.contains("panels." + panelName + ".temp." + p.getName())) {
            config.set("panels." + panelName + ".item." + e.getSlot(), this.tempEdit.get("panels." + panelName + ".temp." + p.getName()));
            this.saveFile(file, config);
        }
    }

    public void removeOldItem(InventoryClickEvent e, Player p, YamlConfiguration config, File file, String panelName) {
        config.set("panels." + panelName + ".item." + e.getSlot(), null);
        this.saveFile(file, config);
    }

    public void clearTemp(Player p, String panelName) {
        this.tempEdit.set("panels." + panelName + ".temp." + p.getName(), null);
        this.saveFile("temp.yml", this.tempEdit);
    }

    public void saveFile(String fileName, YamlConfiguration file) {
        try {
            file.save(new File(this.plugin.getDataFolder() + File.separator + fileName));
        }
        catch (IOException s) {
            this.plugin.debug(s, null);
        }
    }

    public void saveFile(File file, YamlConfiguration config) {
        try {
            config.save(file);
        }
        catch (IOException s) {
            this.plugin.debug(s, null);
        }
    }

    public void onEditPanelClose(Player p, Inventory inv, InventoryView invView) {
        if (!p.getOpenInventory().getTitle().contains("Editing Panel:")) {
            return;
        }
        if (!p.hasPermission("commandpanel.edit")) {
            return;
        }
        String panelName = "";
        File file = null;
        YamlConfiguration config = new YamlConfiguration();
        boolean found = false;
        try {
            for (Panel panel : this.plugin.panelList) {
                if (!invView.getTitle().equals("Editing Panel: " + panel.getName())) continue;
                panelName = panel.getName();
                file = panel.getFile();
                config = YamlConfiguration.loadConfiguration((File)panel.getFile());
                found = true;
                break;
            }
        }
        catch (Exception fail) {
            this.plugin.debug(fail, p);
            return;
        }
        if (!found) {
            return;
        }
        config = this.plugin.itemCreate.generatePanelFile(panelName, inv, config);
        try {
            config.save(file);
            p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Saved Changes!"));
        }
        catch (IOException s) {
            p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.RED + "Could Not Save Changes!"));
            this.plugin.debug(s, p);
        }
        this.plugin.reloadPanelFiles();
    }
}

