/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.openpanelsmanager;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import me.rockyhawk.commandpanels.CommandPanels;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.api.PanelClosedEvent;
import me.rockyhawk.commandpanels.api.PanelsInterface;
import me.rockyhawk.commandpanels.openpanelsmanager.PanelPosition;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class OpenPanelsLoader {
    CommandPanels plugin;
    public HashMap<String, PanelsInterface> openPanels = new HashMap();
    public HashSet<String> skipPanelClose = new HashSet();

    public OpenPanelsLoader(CommandPanels pl) {
        this.plugin = pl;
    }

    public Panel getOpenPanel(String playerName, PanelPosition position) {
        for (Map.Entry<String, PanelsInterface> entry : this.openPanels.entrySet()) {
            if (!entry.getKey().equals(playerName)) continue;
            return entry.getValue().getPanel(position);
        }
        return null;
    }

    public boolean hasPanelOpen(String playerName, String panelName, PanelPosition position) {
        for (Map.Entry<String, PanelsInterface> entry : this.openPanels.entrySet()) {
            try {
                if (!entry.getKey().equals(playerName) || !entry.getValue().getPanel(position).getName().equals(panelName)) continue;
                return true;
            }
            catch (NullPointerException ex) {
                return false;
            }
        }
        return false;
    }

    public boolean hasPanelOpen(String playerName, PanelPosition position) {
        for (Map.Entry<String, PanelsInterface> entry : this.openPanels.entrySet()) {
            try {
                if (!entry.getKey().equals(playerName) || entry.getValue().getPanel(position) == null) continue;
                return true;
            }
            catch (NullPointerException ex) {
                return false;
            }
        }
        return false;
    }

    public void openPanelForLoader(String playerName, Panel panel, PanelPosition position) {
        if (!this.openPanels.containsKey(playerName)) {
            this.openPanels.put(playerName, new PanelsInterface(playerName));
        }
        this.openPanels.get(playerName).setPanel(panel, position);
        this.openPanels.get((Object)playerName).getPanel((PanelPosition)position).isOpen = true;
        if (this.plugin.config.contains("config.panel-snooper") && Objects.requireNonNull(this.plugin.config.getString("config.panel-snooper")).trim().equalsIgnoreCase("true")) {
            Bukkit.getConsoleSender().sendMessage("[CommandPanels] " + playerName + " Opened " + panel.getName() + " at " + (Object)((Object)position));
        }
    }

    public void closePanelForLoader(String playerName, PanelPosition position) {
        if (!this.openPanels.containsKey(playerName) || this.skipPanelClose.contains(playerName)) {
            return;
        }
        this.panelCloseCommands(playerName, position, this.openPanels.get(playerName).getPanel(position));
        if (this.plugin.config.contains("config.panel-snooper") && Objects.requireNonNull(this.plugin.config.getString("config.panel-snooper")).equalsIgnoreCase("true")) {
            Bukkit.getConsoleSender().sendMessage("[CommandPanels] " + playerName + " Closed " + this.openPanels.get(playerName).getPanel(position).getName() + " at " + (Object)((Object)position));
        }
        PanelClosedEvent closedEvent = new PanelClosedEvent(Bukkit.getPlayer((String)playerName), this.openPanels.get(playerName).getPanel(position), position);
        Bukkit.getPluginManager().callEvent((Event)closedEvent);
        this.openPanels.get(playerName).setPanel(null, position);
        if (this.openPanels.get(playerName).allClosed()) {
            this.removePlayer(playerName);
        } else if (this.openPanels.get(playerName).getPanel(PanelPosition.Top) == null) {
            this.removePlayer(playerName);
        }
        this.plugin.inventorySaver.restoreInventory(Bukkit.getPlayer((String)playerName), position);
    }

    public void removePlayer(String playerName) {
        this.openPanels.get(playerName).setPanel(null, PanelPosition.Top);
        this.openPanels.get(playerName).setPanel(null, PanelPosition.Middle);
        this.openPanels.get(playerName).setPanel(null, PanelPosition.Bottom);
        this.openPanels.remove(playerName);
    }

    public void panelCloseCommands(String playerName, PanelPosition position, Panel panel) {
        if (panel.getConfig().contains("commands-on-close")) {
            try {
                this.plugin.commandTags.runCommands(panel, position, Bukkit.getPlayer((String)playerName), panel.getConfig().getStringList("commands-on-close"));
            }
            catch (Exception s) {
                this.plugin.debug(s, null);
            }
        }
    }

    public boolean isNBTInjected(ItemStack itm) {
        if (itm != null) {
            return this.plugin.nbt.hasNBT(itm);
        }
        return false;
    }
}

