/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.openpanelsmanager;

import java.util.Objects;
import me.rockyhawk.commandpanels.CommandPanels;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.api.PanelClosedEvent;
import me.rockyhawk.commandpanels.openpanelsmanager.PanelPosition;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;

public class UtilsPanelsLoader
implements Listener {
    CommandPanels plugin;

    public UtilsPanelsLoader(CommandPanels pl) {
        this.plugin = pl;
    }

    @EventHandler
    public void onPlayerClosePanel(PlayerQuitEvent e) {
        this.plugin.openPanels.closePanelForLoader(e.getPlayer().getName(), PanelPosition.Top);
        Player p = e.getPlayer();
        p.updateInventory();
        for (ItemStack itm : p.getInventory().getContents()) {
            if (itm == null || !this.plugin.nbt.hasNBT(itm)) continue;
            p.getInventory().remove(itm);
        }
    }

    @EventHandler
    public void onPlayerClosePanel(InventoryCloseEvent e) {
        if (!Objects.requireNonNull(this.plugin.config.getString("config.ingame-editor")).equalsIgnoreCase("true")) {
            this.plugin.openPanels.closePanelForLoader(e.getPlayer().getName(), PanelPosition.Top);
        }
    }

    @EventHandler
    public void onInventoryItemClick(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        if (!this.plugin.openPanels.hasPanelOpen(p.getName(), PanelPosition.Top)) {
            for (ItemStack itm : p.getInventory().getContents()) {
                if (!this.plugin.openPanels.isNBTInjected(itm)) continue;
                p.getInventory().remove(itm);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void vanillaOpenedEvent(InventoryOpenEvent e) {
        if (e.isCancelled() && this.plugin.openPanels.hasPanelOpen(e.getPlayer().getName(), PanelPosition.Top)) {
            Panel closedPanel = this.plugin.openPanels.getOpenPanel(e.getPlayer().getName(), PanelPosition.Top);
            this.plugin.openPanels.removePlayer(e.getPlayer().getName());
            PanelClosedEvent closedEvent = new PanelClosedEvent(Bukkit.getPlayer((String)e.getPlayer().getName()), closedPanel, PanelPosition.Top);
            Bukkit.getPluginManager().callEvent((Event)closedEvent);
            if (this.plugin.config.contains("config.panel-snooper") && Objects.requireNonNull(this.plugin.config.getString("config.panel-snooper")).equalsIgnoreCase("true")) {
                Bukkit.getConsoleSender().sendMessage("[CommandPanels] " + e.getPlayer().getName() + "'s Panel was Force Closed");
            }
        }
    }
}

