/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.openwithitem;

import java.util.HashMap;
import java.util.UUID;
import me.rockyhawk.commandpanels.CommandPanels;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.openpanelsmanager.PanelPosition;
import me.rockyhawk.commandpanels.openwithitem.HotbarPlayerManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class HotbarItemLoader {
    CommandPanels plugin;
    HashMap<UUID, HotbarPlayerManager> stationaryItems = new HashMap();

    public HotbarItemLoader(CommandPanels pl) {
        this.plugin = pl;
    }

    public void reloadHotbarSlots() {
        this.stationaryItems.clear();
        for (Player p : Bukkit.getServer().getOnlinePlayers()) {
            this.plugin.hotbar.updateHotbarItems(p);
        }
    }

    public boolean stationaryExecute(int slot, Player p, ClickType click, boolean openPanel) {
        if (this.stationaryItems.get((Object)p.getUniqueId()).list.containsKey(slot)) {
            if (openPanel) {
                try {
                    if (!this.plugin.nbt.getNBT(p.getInventory().getItem(slot), "CommandPanelsHotbar").split(":")[1].equals(String.valueOf(slot))) {
                        return false;
                    }
                }
                catch (Exception ex) {
                    return false;
                }
                Panel panel = this.stationaryItems.get(p.getUniqueId()).getPanel(slot);
                if (!p.hasPermission("commandpanel.panel." + panel.getConfig().getString("perm"))) {
                    return false;
                }
                if (!this.itemCheckExecute(p.getInventory().getItem(slot), p, false, false)) {
                    return false;
                }
                if (panel.getHotbarSection(p).contains("commands")) {
                    this.plugin.commandTags.runCommands(panel, PanelPosition.Top, p, panel.getHotbarSection(p).getStringList("commands"), click);
                    return true;
                }
                panel.open(p, PanelPosition.Top);
            }
            return true;
        }
        return false;
    }

    public boolean itemCheckExecute(ItemStack invItem, Player p, boolean openPanel, boolean stationaryOnly) {
        try {
            if (this.plugin.nbt.getNBT(invItem, "CommandPanelsHotbar") == null) {
                return false;
            }
        }
        catch (IllegalArgumentException | NullPointerException nu) {
            return false;
        }
        for (Panel panel : this.plugin.panelList) {
            if (stationaryOnly) {
                try {
                    if (this.plugin.nbt.getNBT(invItem, "CommandPanelsHotbar").split(":")[1].equals("-1")) {
                        continue;
                    }
                }
                catch (IllegalArgumentException | NullPointerException runtimeException) {
                    // empty catch block
                }
            }
            if (!panel.hasHotbarItem() || !this.plugin.nbt.getNBT(invItem, "CommandPanelsHotbar").split(":")[0].equals(panel.getName())) continue;
            if (openPanel) {
                if (!this.plugin.panelPerms.isPanelWorldEnabled(p, panel.getConfig())) {
                    return false;
                }
                if (panel.getHotbarSection(p).contains("commands")) {
                    for (String command : panel.getHotbarSection(p).getStringList("commands")) {
                        this.plugin.commandTags.runCommand(panel, PanelPosition.Top, p, command);
                    }
                    return true;
                }
                panel.open(p, PanelPosition.Top);
            }
            return true;
        }
        return false;
    }

    public void updateHotbarItems(Player p) {
        if (!this.plugin.openWithItem) {
            return;
        }
        this.stationaryItems.put(p.getUniqueId(), new HotbarPlayerManager());
        for (int i = 0; i <= 35; ++i) {
            try {
                if (this.plugin.nbt.getNBT(p.getInventory().getItem(i), "CommandPanelsHotbar") == null || this.plugin.nbt.getNBT(p.getInventory().getItem(i), "CommandPanelsHotbar").endsWith("-1")) continue;
                p.getInventory().setItem(i, new ItemStack(Material.AIR));
                continue;
            }
            catch (IllegalArgumentException | NullPointerException runtimeException) {
                // empty catch block
            }
        }
        for (Panel panel : this.plugin.panelList) {
            if (!this.plugin.panelPerms.isPanelWorldEnabled(p, panel.getConfig()) || !p.hasPermission("commandpanel.panel." + panel.getConfig().getString("perm")) || !panel.hasHotbarItem()) continue;
            ItemStack s = panel.getHotbarItem(p);
            if (!panel.getHotbarSection(p).contains("stationary")) continue;
            p.getInventory().setItem(panel.getHotbarSection(p).getInt("stationary"), s);
            this.stationaryItems.get(p.getUniqueId()).addSlot(panel.getHotbarSection(p).getInt("stationary"), panel);
        }
        p.updateInventory();
    }
}

