/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.openwithitem;

import java.util.ArrayList;
import java.util.Objects;
import me.rockyhawk.commandpanels.CommandPanels;
import me.rockyhawk.commandpanels.ioclasses.GetItemInHand;
import me.rockyhawk.commandpanels.ioclasses.GetItemInHand_Legacy;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;

public class UtilsOpenWithItem
implements Listener {
    CommandPanels plugin;

    public UtilsOpenWithItem(CommandPanels pl) {
        this.plugin = pl;
    }

    @EventHandler
    public void onAnyClick(InventoryClickEvent e) {
        if (!this.plugin.openWithItem) {
            return;
        }
        Player p = (Player)e.getWhoClicked();
        if (e.getAction() == InventoryAction.NOTHING) {
            return;
        }
        if (e.getSlot() == -999) {
            return;
        }
        if (e.getClickedInventory() == null) {
            return;
        }
        if (e.getClickedInventory().getType() == InventoryType.PLAYER && !e.isCancelled() && this.plugin.hotbar.stationaryExecute(e.getSlot(), p, e.getClick(), true)) {
            e.setCancelled(true);
            p.updateInventory();
        }
    }

    @EventHandler
    public void onPlayerUse(PlayerInteractEvent e) {
        if (!this.plugin.openWithItem) {
            return;
        }
        try {
            if (e.getAction() != Action.RIGHT_CLICK_AIR && e.getAction() != Action.RIGHT_CLICK_BLOCK || Objects.requireNonNull(e.getItem()).getType() == Material.AIR) {
                return;
            }
        }
        catch (Exception b) {
            return;
        }
        Player p = e.getPlayer();
        if (this.plugin.hotbar.itemCheckExecute(e.getItem(), p, true, false)) {
            e.setCancelled(true);
            p.updateInventory();
        }
    }

    @EventHandler
    public void onWorldChange(PlayerChangedWorldEvent e) {
        this.plugin.hotbar.updateHotbarItems(e.getPlayer());
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent e) {
        this.plugin.hotbar.updateHotbarItems(e.getPlayer());
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent e) {
        if (!this.plugin.openWithItem) {
            return;
        }
        for (ItemStack s : new ArrayList(e.getDrops())) {
            try {
                if (this.plugin.nbt.getNBT(s, "CommandPanelsHotbar") == null || this.plugin.nbt.getNBT(s, "CommandPanelsHotbar").endsWith("-1")) continue;
                e.getDrops().remove(s);
            }
            catch (IllegalArgumentException | NullPointerException runtimeException) {}
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        this.plugin.hotbar.updateHotbarItems(e.getPlayer());
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent e) {
        this.plugin.hotbar.stationaryItems.remove(e.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent e) {
        if (!this.plugin.openWithItem) {
            return;
        }
        Player p = e.getPlayer();
        if (this.plugin.hotbar.itemCheckExecute(e.getItemDrop().getItemStack(), p, false, true)) {
            e.setCancelled(true);
            p.updateInventory();
        }
    }

    @EventHandler
    public void onInteractEntity(PlayerInteractEntityEvent e) {
        if (!this.plugin.openWithItem) {
            return;
        }
        Player p = e.getPlayer();
        ItemStack clicked = Bukkit.getVersion().contains("1.8") ? new GetItemInHand_Legacy(this.plugin).itemInHand(p) : new GetItemInHand(this.plugin).itemInHand(p);
        if (this.plugin.hotbar.itemCheckExecute(clicked, p, true, false)) {
            e.setCancelled(true);
            p.updateInventory();
        }
    }
}

