/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.playerinventoryhandler;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import me.rockyhawk.commandpanels.CommandPanels;
import me.rockyhawk.commandpanels.api.PanelOpenedEvent;
import me.rockyhawk.commandpanels.openpanelsmanager.PanelPosition;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;

public class InventorySaver
implements Listener {
    public YamlConfiguration inventoryConfig;
    CommandPanels plugin;

    public InventorySaver(CommandPanels pl) {
        this.plugin = pl;
    }

    public void saveInventoryFile() {
        try {
            this.inventoryConfig.save(this.plugin.getDataFolder() + File.separator + "inventories.yml");
        }
        catch (IOException s) {
            s.printStackTrace();
            this.plugin.debug(s, null);
        }
    }

    @EventHandler
    public void onOpen(PanelOpenedEvent e) {
        if (e.getPosition() != PanelPosition.Top) {
            this.addInventory(e.getPlayer());
        }
    }

    @EventHandler
    public void playerJoined(PlayerJoinEvent e) {
        this.restoreInventory(e.getPlayer(), PanelPosition.Top);
    }

    public void restoreInventory(Player p, PanelPosition position) {
        if (p == null) {
            return;
        }
        if (this.plugin.openPanels.hasPanelOpen(p.getName(), PanelPosition.Middle) || this.plugin.openPanels.hasPanelOpen(p.getName(), PanelPosition.Bottom)) {
            if (position == PanelPosition.Bottom) {
                for (int s = 0; s < 9; ++s) {
                    p.getInventory().setItem(s, null);
                }
            } else if (position == PanelPosition.Middle) {
                for (int s = 9; s < 36; ++s) {
                    p.getInventory().setItem(s, null);
                }
            }
            return;
        }
        if (this.inventoryConfig.isSet(p.getUniqueId().toString())) {
            p.getInventory().setContents(this.plugin.itemSerializer.itemStackArrayFromBase64(this.inventoryConfig.getString(p.getUniqueId().toString())));
            this.inventoryConfig.set(p.getUniqueId().toString(), null);
        }
    }

    public void addInventory(Player p) {
        if (!this.inventoryConfig.contains(p.getUniqueId().toString())) {
            this.inventoryConfig.set(p.getUniqueId().toString(), (Object)this.plugin.itemSerializer.itemStackArrayToBase64(p.getInventory().getContents()));
            ItemStack[] armorContents = (ItemStack[])p.getInventory().getArmorContents().clone();
            p.getInventory().clear();
            p.getInventory().setArmorContents(armorContents);
        }
    }

    public ItemStack[] getNormalInventory(Player p) {
        if (this.hasNormalInventory(p)) {
            return p.getInventory().getContents();
        }
        return this.plugin.itemSerializer.itemStackArrayFromBase64(this.inventoryConfig.getString(p.getUniqueId().toString()));
    }

    public boolean hasNormalInventory(Player p) {
        return !this.inventoryConfig.isSet(p.getUniqueId().toString());
    }

    public void addItem(Player p, ItemStack item) {
        if (this.hasNormalInventory(p)) {
            if (p.getInventory().firstEmpty() >= 0) {
                p.getInventory().addItem(new ItemStack[]{item});
                return;
            }
        } else {
            ArrayList<ItemStack> cont = new ArrayList<ItemStack>(Arrays.asList(this.getNormalInventory(p)));
            boolean found = false;
            for (int i = 0; 36 > i; ++i) {
                if (cont.get(i) == null) {
                    cont.set(i, item);
                    found = true;
                    break;
                }
                if (!((ItemStack)cont.get(i)).isSimilar(item)) continue;
                ((ItemStack)cont.get(i)).setAmount(((ItemStack)cont.get(i)).getAmount() + 1);
                found = true;
                break;
            }
            if (found) {
                this.inventoryConfig.set(p.getUniqueId().toString(), (Object)this.plugin.itemSerializer.itemStackArrayToBase64(cont.toArray(new ItemStack[0])));
                return;
            }
        }
        p.getLocation().getWorld().dropItemNaturally(p.getLocation(), item);
    }
}

