/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.papi.expansion.essentials;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.Kit;
import com.earth2me.essentials.User;
import com.earth2me.essentials.UserData;
import com.earth2me.essentials.utils.DateUtil;
import com.earth2me.essentials.utils.DescParseTickFormat;
import com.google.common.primitives.Ints;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.stream.StreamSupport;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import net.ess3.api.IEssentials;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class EssentialsExpansion
extends PlaceholderExpansion {
    private Essentials essentials;
    private final String VERSION = ((Object)((Object)this)).getClass().getPackage().getImplementationVersion();

    public boolean canRegister() {
        return Bukkit.getPluginManager().getPlugin("Essentials") != null;
    }

    public boolean register() {
        this.essentials = (Essentials)Bukkit.getPluginManager().getPlugin("Essentials");
        if (this.essentials != null) {
            return super.register();
        }
        return false;
    }

    @NotNull
    public String getAuthor() {
        return "clip";
    }

    @NotNull
    public String getIdentifier() {
        return "essentials";
    }

    @NotNull
    public String getVersion() {
        return this.VERSION;
    }

    public String onRequest(OfflinePlayer player, @NotNull String identifier) {
        String papiTrue = PlaceholderAPIPlugin.booleanTrue();
        String papiFalse = PlaceholderAPIPlugin.booleanFalse();
        if (player == null) {
            return "";
        }
        if (identifier.startsWith("kit_last_use_")) {
            Kit kit;
            String kitName = identifier.split("kit_last_use_")[1].toLowerCase();
            try {
                kit = new Kit(kitName, (IEssentials)this.essentials);
            }
            catch (Exception e) {
                return "Invalid kit name";
            }
            long time = this.essentials.getUser(player.getUniqueId()).getKitTimestamp(kit.getName());
            if (time == 1L || time <= 0L) {
                return "1";
            }
            return PlaceholderAPIPlugin.getDateFormat().format(new Date(time));
        }
        if (identifier.startsWith("kit_is_available_")) {
            long time;
            Kit kit;
            String kitName = identifier.split("kit_is_available_")[1].toLowerCase();
            User user = this.essentials.getUser(player.getUniqueId());
            try {
                kit = new Kit(kitName, (IEssentials)this.essentials);
            }
            catch (Exception e) {
                return "Invalid kit name";
            }
            try {
                time = kit.getNextUse(user);
            }
            catch (Exception e) {
                return papiFalse;
            }
            return time == 0L ? papiTrue : papiFalse;
        }
        if (identifier.startsWith("kit_time_until_available_")) {
            long time;
            Kit kit;
            String kitName = identifier.split("kit_time_until_available_")[1].toLowerCase();
            boolean raw = false;
            User user = this.essentials.getUser(player.getUniqueId());
            if (kitName.startsWith("raw_")) {
                raw = true;
                if ((kitName = kitName.substring(4)).isEmpty()) {
                    return "Invalid kit name";
                }
            }
            try {
                kit = new Kit(kitName, (IEssentials)this.essentials);
            }
            catch (Exception e) {
                return "Invalid kit name";
            }
            try {
                time = kit.getNextUse(user);
            }
            catch (Exception e) {
                return "-1";
            }
            if (time <= System.currentTimeMillis()) {
                return raw ? "0" : DateUtil.formatDateDiff((long)System.currentTimeMillis());
            }
            if (raw) {
                return String.valueOf(Instant.now().until(Instant.ofEpochMilli(time), ChronoUnit.MILLIS));
            }
            return DateUtil.formatDateDiff((long)time);
        }
        if (identifier.startsWith("has_kit_")) {
            Player oPlayer = player.getPlayer();
            if (oPlayer == null) {
                return papiFalse;
            }
            String kit = identifier.split("has_kit_")[1];
            return oPlayer.hasPermission("essentials.kits." + kit) ? papiTrue : papiFalse;
        }
        if (identifier.startsWith("home_")) {
            User user = this.essentials.getUser(player.getUniqueId());
            Integer homeNumber = Ints.tryParse((String)identifier.replaceAll("\\D+", ""));
            if (homeNumber == null) {
                return null;
            }
            if ((homeNumber = Integer.valueOf(homeNumber - 1)) >= user.getHomes().size() || homeNumber < 0) {
                return "";
            }
            if (identifier.matches("(\\w+_)(\\d)")) {
                return (String)user.getHomes().get(homeNumber);
            }
            if (identifier.matches("(\\w+_)(\\d)(_\\w)")) {
                try {
                    Location home = user.getHome((String)user.getHomes().get(homeNumber));
                    StringBuilder stringBuilder = new StringBuilder();
                    switch (identifier.charAt(identifier.length() - 1)) {
                        case 'x': {
                            stringBuilder.append(home.getX()).append(".5");
                            break;
                        }
                        case 'y': {
                            stringBuilder.append((int)home.getY());
                            break;
                        }
                        case 'z': {
                            stringBuilder.append(home.getZ()).append(".5");
                        }
                    }
                    return stringBuilder.toString();
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        if (identifier.startsWith("worth")) {
            ItemStack item;
            if (identifier.contains(":")) {
                Material material = Material.getMaterial((String)identifier.replace("worth:", "").toUpperCase());
                if (material == null) {
                    return "";
                }
                item = new ItemStack(material, 1);
            } else {
                Player oPlayer = player.getPlayer();
                if (oPlayer == null) {
                    return "";
                }
                if (oPlayer.getItemInHand().getType() == Material.AIR) {
                    return "";
                }
                item = oPlayer.getItemInHand();
            }
            BigDecimal worth = this.essentials.getWorth().getPrice((com.earth2me.essentials.IEssentials)this.essentials, item);
            if (worth == null) {
                return "";
            }
            return String.valueOf(worth.doubleValue());
        }
        User user = this.essentials.getUser(player.getUniqueId());
        switch (identifier) {
            case "is_pay_confirm": {
                return user.isPromptingPayConfirm() ? papiTrue : papiFalse;
            }
            case "is_pay_enabled": {
                return user.isAcceptingPay() ? papiTrue : papiFalse;
            }
            case "is_teleport_enabled": {
                return user.isTeleportEnabled() ? papiTrue : papiFalse;
            }
            case "is_muted": {
                return user.isMuted() ? papiTrue : papiFalse;
            }
            case "vanished": {
                return user.isVanished() ? papiTrue : papiFalse;
            }
            case "afk": {
                return user.isAfk() ? papiTrue : papiFalse;
            }
            case "afk_reason": {
                if (user.getAfkMessage() == null) {
                    return "";
                }
                return ChatColor.translateAlternateColorCodes((char)'&', (String)user.getAfkMessage());
            }
            case "afk_player_count": {
                return String.valueOf(this.essentials.getUserMap().getAllUniqueUsers().stream().map(UUID2 -> this.essentials.getUser(UUID2)).filter(UserData::isAfk).count());
            }
            case "msg_ignore": {
                return user.isIgnoreMsg() ? papiTrue : papiFalse;
            }
            case "fly": {
                return user.getBase().getAllowFlight() ? papiTrue : papiFalse;
            }
            case "nickname": {
                return user.getNickname() != null ? this.essentials.getUser(player.getUniqueId()).getNickname() : player.getName();
            }
            case "nickname_stripped": {
                return ChatColor.stripColor((String)(user.getNickname() != null ? this.essentials.getUser(player.getUniqueId()).getNickname() : player.getName()));
            }
            case "godmode": {
                return user.isGodModeEnabled() ? papiTrue : papiFalse;
            }
            case "unique": {
                return NumberFormat.getInstance().format(this.essentials.getUserMap().getUniqueUsers());
            }
            case "homes_set": {
                return user.getHomes().isEmpty() ? "0" : String.valueOf(user.getHomes().size());
            }
            case "homes_max": {
                return String.valueOf(this.essentials.getSettings().getHomeLimit(user));
            }
            case "jailed": {
                return user.isJailed() ? papiTrue : papiFalse;
            }
            case "jailed_time_remaining": {
                return user.getFormattedJailTime();
            }
            case "pm_recipient": {
                return user.getReplyRecipient() != null ? user.getReplyRecipient().getName() : "";
            }
            case "safe_online": {
                return String.valueOf(StreamSupport.stream(this.essentials.getOnlineUsers().spliterator(), false).filter(user1 -> !user1.isHidden()).count());
            }
            case "world_date": {
                return DateFormat.getDateInstance(2, this.essentials.getI18n().getCurrentLocale()).format(DescParseTickFormat.ticksToDate((long)(user.getWorld() == null ? 0L : user.getWorld().getFullTime())));
            }
            case "world_time": {
                return DescParseTickFormat.format12((long)(user.getWorld() == null ? 0L : user.getWorld().getTime()));
            }
            case "world_time_24": {
                return DescParseTickFormat.format24((long)(user.getWorld() == null ? 0L : user.getWorld().getTime()));
            }
        }
        return null;
    }
}

