/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.IEssentials;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.command.Command;
import org.bukkit.command.PluginIdentifiableCommand;
import org.bukkit.plugin.Plugin;

public class AlternativeCommandsHandler {
    private static final Logger LOGGER = Logger.getLogger("Essentials");
    private final transient Map<String, List<Command>> altcommands = new HashMap<String, List<Command>>();
    private final transient Map<String, String> disabledList = new HashMap<String, String>();
    private final transient IEssentials ess;

    public AlternativeCommandsHandler(IEssentials ess) {
        this.ess = ess;
        for (Plugin plugin : ess.getServer().getPluginManager().getPlugins()) {
            if (!plugin.isEnabled()) continue;
            this.addPlugin(plugin);
        }
    }

    public final void addPlugin(Plugin plugin) {
        if (plugin.getDescription().getMain().contains("com.earth2me.essentials") || plugin.getDescription().getMain().contains("net.essentialsx")) {
            return;
        }
        for (Map.Entry<String, Command> entry : this.getPluginCommands(plugin).entrySet()) {
            String[] commandSplit = entry.getKey().split(":", 2);
            String commandName = commandSplit.length > 1 ? commandSplit[1] : entry.getKey();
            Command command = entry.getValue();
            List pluginCommands = this.altcommands.computeIfAbsent(commandName.toLowerCase(Locale.ENGLISH), k -> new ArrayList());
            boolean found = false;
            for (Command pc2 : pluginCommands) {
                if (!((PluginIdentifiableCommand)pc2).getPlugin().equals(plugin)) continue;
                found = true;
                break;
            }
            if (found) continue;
            pluginCommands.add(command);
        }
    }

    private Map<String, Command> getPluginCommands(Plugin plugin) {
        HashMap<String, Command> commands = new HashMap<String, Command>();
        for (Map.Entry<String, Command> entry : this.ess.getKnownCommandsProvider().getKnownCommands().entrySet()) {
            if (!(entry.getValue() instanceof PluginIdentifiableCommand) || !((PluginIdentifiableCommand)entry.getValue()).getPlugin().equals(plugin)) continue;
            commands.put(entry.getKey(), entry.getValue());
        }
        return commands;
    }

    public void removePlugin(Plugin plugin) {
        Iterator<Map.Entry<String, List<Command>>> iterator = this.altcommands.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, List<Command>> entry = iterator.next();
            entry.getValue().removeIf(pc -> !(pc instanceof PluginIdentifiableCommand) || ((PluginIdentifiableCommand)pc).getPlugin().equals(plugin));
            if (!entry.getValue().isEmpty()) continue;
            iterator.remove();
        }
    }

    public Command getAlternative(String label) {
        List<Command> commands = this.altcommands.get(label);
        if (commands == null || commands.isEmpty()) {
            return null;
        }
        if (commands.size() == 1) {
            return commands.get(0);
        }
        for (Command command : commands) {
            if (!command.getName().equalsIgnoreCase(label)) continue;
            return command;
        }
        return commands.get(0);
    }

    public void executed(String label, Command pc) {
        if (pc instanceof PluginIdentifiableCommand) {
            String altString = ((PluginIdentifiableCommand)pc).getPlugin().getName() + ":" + pc.getName();
            if (this.ess.getSettings().isDebug()) {
                LOGGER.log(Level.INFO, "Essentials: Alternative command " + label + " found, using " + altString);
            }
            this.disabledList.put(label, altString);
        }
    }

    public Map<String, String> disabledCommands() {
        return this.disabledList;
    }
}

