/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.FakeAccessor;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.paperlib.PaperLib;
import com.earth2me.essentials.textreader.IText;
import com.earth2me.essentials.textreader.KeywordReplacer;
import com.earth2me.essentials.textreader.TextInput;
import com.earth2me.essentials.textreader.TextPager;
import com.earth2me.essentials.utils.DateUtil;
import com.earth2me.essentials.utils.FormatUtil;
import com.earth2me.essentials.utils.LocationUtil;
import com.earth2me.essentials.utils.MaterialUtil;
import com.earth2me.essentials.utils.VersionUtil;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import net.ess3.api.IEssentials;
import net.ess3.api.events.AfkStatusChangeEvent;
import net.ess3.provider.CommandSendListenerProvider;
import net.ess3.provider.providers.BukkitCommandSendListenerProvider;
import net.ess3.provider.providers.PaperCommandSendListenerProvider;
import net.essentialsx.api.v2.events.AsyncUserDataLoadEvent;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.data.type.Bed;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.FormattedCommandAlias;
import org.bukkit.command.PluginCommand;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerEggThrowEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPickupArrowEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class EssentialsPlayerListener
implements Listener,
FakeAccessor {
    private static final Logger LOGGER = Logger.getLogger("Essentials");
    private final transient IEssentials ess;
    private final ConcurrentHashMap<UUID, Integer> pendingMotdTasks = new ConcurrentHashMap();

    public EssentialsPlayerListener(IEssentials parent) {
        this.ess = parent;
    }

    private static boolean isEntityPickupEvent() {
        try {
            Class.forName("org.bukkit.event.entity.EntityPickupItemEvent");
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    private static boolean isCommandSendEvent() {
        try {
            Class.forName("org.bukkit.event.player.PlayerCommandSendEvent");
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    private static boolean isPaperCommandSendEvent() {
        try {
            Class.forName("com.destroystokyo.paper.event.brigadier.AsyncPlayerSendCommandsEvent");
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    private static boolean isArrowPickupEvent() {
        try {
            Class.forName("org.bukkit.event.player.PlayerPickupArrowEvent");
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    public void registerEvents() {
        this.ess.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.ess);
        if (EssentialsPlayerListener.isArrowPickupEvent()) {
            this.ess.getServer().getPluginManager().registerEvents((Listener)new ArrowPickupListener(), (Plugin)this.ess);
        }
        if (EssentialsPlayerListener.isEntityPickupEvent()) {
            this.ess.getServer().getPluginManager().registerEvents((Listener)new PickupListener1_12(), (Plugin)this.ess);
        } else {
            this.ess.getServer().getPluginManager().registerEvents((Listener)new PickupListenerPre1_12(), (Plugin)this.ess);
        }
        if (EssentialsPlayerListener.isPaperCommandSendEvent()) {
            this.ess.getServer().getPluginManager().registerEvents((Listener)new PaperCommandSendListenerProvider(new CommandSendFilter()), (Plugin)this.ess);
        } else if (EssentialsPlayerListener.isCommandSendEvent()) {
            this.ess.getServer().getPluginManager().registerEvents((Listener)new BukkitCommandSendListenerProvider(new CommandSendFilter()), (Plugin)this.ess);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        User user = this.ess.getUser(event.getPlayer());
        this.updateCompass(user);
        user.setDisplayNick();
        if (this.ess.getSettings().isTeleportInvulnerability()) {
            user.enableInvulnerabilityAfterTeleport();
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        User user = this.ess.getUser(event.getPlayer());
        if (user.isMuted()) {
            String dateDiff;
            event.setCancelled(true);
            String string = dateDiff = user.getMuteTimeout() > 0L ? DateUtil.formatDateDiff(user.getMuteTimeout()) : null;
            if (dateDiff == null) {
                user.sendMessage(user.hasMuteReason() ? I18n.tl("voiceSilencedReason", user.getMuteReason()) : I18n.tl("voiceSilenced", new Object[0]));
            } else {
                user.sendMessage(user.hasMuteReason() ? I18n.tl("voiceSilencedReasonTime", dateDiff, user.getMuteReason()) : I18n.tl("voiceSilencedTime", dateDiff));
            }
            LOGGER.info(I18n.tl("mutedUserSpeaks", user.getName(), event.getMessage()));
        }
        try {
            Iterator it = event.getRecipients().iterator();
            while (it.hasNext()) {
                User u = this.ess.getUser((Player)it.next());
                if (!u.isIgnoredPlayer(user)) continue;
                it.remove();
            }
        }
        catch (UnsupportedOperationException ex) {
            if (this.ess.getSettings().isDebug()) {
                this.ess.getLogger().log(Level.INFO, "Ignore could not block chat due to custom chat plugin event.", ex);
            }
            this.ess.getLogger().info("Ignore could not block chat due to custom chat plugin event.");
        }
        user.updateActivityOnChat(true);
        user.setDisplayNick();
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        if (event.getFrom().getBlockX() == event.getTo().getBlockX() && event.getFrom().getBlockZ() == event.getTo().getBlockZ() && event.getFrom().getBlockY() == event.getTo().getBlockY()) {
            return;
        }
        if (!this.ess.getSettings().cancelAfkOnMove() && !this.ess.getSettings().getFreezeAfkPlayers()) {
            event.getHandlers().unregister((Listener)this);
            if (this.ess.getSettings().isDebug()) {
                LOGGER.log(Level.INFO, "Unregistering move listener");
            }
            return;
        }
        User user = this.ess.getUser(event.getPlayer());
        if (user.isAfk() && this.ess.getSettings().getFreezeAfkPlayers()) {
            Location from = event.getFrom();
            Location origTo = event.getTo();
            Location to = origTo.clone();
            if (origTo.getY() >= (double)(from.getBlockY() + 1)) {
                user.updateActivityOnMove(true);
                return;
            }
            to.setX(from.getX());
            to.setY(from.getY());
            to.setZ(from.getZ());
            try {
                event.setTo(LocationUtil.getSafeDestination(this.ess, to));
            }
            catch (Exception ex) {
                event.setTo(to);
            }
            return;
        }
        Location afk = user.getAfkPosition();
        if (afk == null || !event.getTo().getWorld().equals(afk.getWorld()) || afk.distanceSquared(event.getTo()) > 9.0) {
            user.updateActivityOnMove(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerQuit(PlayerQuitEvent event) {
        User user = this.ess.getUser(event.getPlayer());
        Integer pendingId = this.pendingMotdTasks.remove(user.getUUID());
        if (pendingId != null) {
            this.ess.getScheduler().cancelTask(pendingId.intValue());
        }
        if (this.hideJoinQuitMessages() || this.ess.getSettings().allowSilentJoinQuit() && user.isAuthorized("essentials.silentquit")) {
            event.setQuitMessage(null);
        } else if (this.ess.getSettings().isCustomQuitMessage() && event.getQuitMessage() != null) {
            Player player = event.getPlayer();
            String msg = this.ess.getSettings().getCustomQuitMessage().replace("{PLAYER}", player.getDisplayName()).replace("{USERNAME}", player.getName()).replace("{ONLINE}", NumberFormat.getInstance().format(this.ess.getOnlinePlayers().size())).replace("{UPTIME}", DateUtil.formatDateDiff(ManagementFactory.getRuntimeMXBean().getStartTime())).replace("{PREFIX}", FormatUtil.replaceFormat(this.ess.getPermissionsHandler().getPrefix(player))).replace("{SUFFIX}", FormatUtil.replaceFormat(this.ess.getPermissionsHandler().getSuffix(player)));
            event.setQuitMessage(msg.isEmpty() ? null : msg);
        }
        user.startTransaction();
        if (this.ess.getSettings().removeGodOnDisconnect() && user.isGodModeEnabled()) {
            user.setGodModeEnabled(false);
        }
        if (user.isVanished()) {
            user.setVanished(false);
        }
        user.setLogoutLocation();
        if (user.isRecipeSee()) {
            user.getBase().getOpenInventory().getTopInventory().clear();
        }
        ArrayList viewers = new ArrayList(user.getBase().getInventory().getViewers());
        for (HumanEntity viewer : viewers) {
            User uviewer;
            if (!(viewer instanceof Player) || !(uviewer = this.ess.getUser((Player)viewer)).isInvSee()) continue;
            uviewer.getBase().closeInventory();
        }
        user.updateActivity(false, AfkStatusChangeEvent.Cause.QUIT);
        if (!user.isHidden()) {
            user.setLastLogout(System.currentTimeMillis());
        }
        user.stopTransaction();
        user.dispose();
    }

    @Override
    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        String joinMessage = event.getJoinMessage();
        this.ess.runTaskAsynchronously(() -> this.delayedJoin(event.getPlayer(), joinMessage));
        if (this.hideJoinQuitMessages() || this.ess.getSettings().allowSilentJoinQuit() || this.ess.getSettings().isCustomJoinMessage()) {
            event.setJoinMessage(null);
        }
    }

    private boolean hideJoinQuitMessages() {
        return this.ess.getSettings().hasJoinQuitMessagePlayerCount() && this.ess.getServer().getOnlinePlayers().size() > this.ess.getSettings().getJoinQuitMessagePlayerCount();
    }

    public void delayedJoin(final Player player, final String message) {
        if (!player.isOnline()) {
            return;
        }
        this.ess.getBackup().onPlayerJoin();
        User dUser = this.ess.getUser(player);
        dUser.startTransaction();
        if (dUser.isNPC()) {
            dUser.setNPC(false);
        }
        final long currentTime = System.currentTimeMillis();
        dUser.checkMuteTimeout(currentTime);
        dUser.updateActivity(false, AfkStatusChangeEvent.Cause.JOIN);
        dUser.stopTransaction();
        class DelayJoinTask
        implements Runnable {
            DelayJoinTask() {
            }

            @Override
            public void run() {
                String effectiveMessage;
                boolean newUsername;
                User user = EssentialsPlayerListener.this.ess.getUser(player);
                if (!user.getBase().isOnline()) {
                    return;
                }
                user.startTransaction();
                String lastAccountName = user.getLastAccountName();
                user.setLastAccountName(user.getBase().getName());
                user.setLastLogin(currentTime);
                user.setDisplayNick();
                EssentialsPlayerListener.this.updateCompass(user);
                boolean bl = newUsername = EssentialsPlayerListener.this.ess.getSettings().isCustomNewUsernameMessage() && lastAccountName != null && !lastAccountName.equals(user.getBase().getName());
                if (!EssentialsPlayerListener.this.ess.getVanishedPlayersNew().isEmpty() && !user.isAuthorized("essentials.vanish.see")) {
                    for (String p : EssentialsPlayerListener.this.ess.getVanishedPlayersNew()) {
                        Player toVanish = EssentialsPlayerListener.this.ess.getServer().getPlayerExact(p);
                        if (toVanish == null || !toVanish.isOnline()) continue;
                        user.getBase().hidePlayer(toVanish);
                        if (!EssentialsPlayerListener.this.ess.getSettings().isDebug()) continue;
                        EssentialsPlayerListener.this.ess.getLogger().info("Hiding vanished player: " + p);
                    }
                }
                if (user.isAuthorized("essentials.sleepingignored")) {
                    user.getBase().setSleepingIgnored(true);
                }
                if (EssentialsPlayerListener.this.ess.getSettings().allowSilentJoinQuit() && (user.isAuthorized("essentials.silentjoin") || user.isAuthorized("essentials.silentjoin.vanish"))) {
                    if (user.isAuthorized("essentials.silentjoin.vanish")) {
                        user.setVanished(true);
                    }
                    effectiveMessage = null;
                } else if (message == null || EssentialsPlayerListener.this.hideJoinQuitMessages()) {
                    effectiveMessage = null;
                } else if (EssentialsPlayerListener.this.ess.getSettings().isCustomJoinMessage()) {
                    String msg = (newUsername ? EssentialsPlayerListener.this.ess.getSettings().getCustomNewUsernameMessage() : EssentialsPlayerListener.this.ess.getSettings().getCustomJoinMessage()).replace("{PLAYER}", player.getDisplayName()).replace("{USERNAME}", player.getName()).replace("{UNIQUE}", NumberFormat.getInstance().format(EssentialsPlayerListener.this.ess.getUserMap().getUniqueUsers())).replace("{ONLINE}", NumberFormat.getInstance().format(EssentialsPlayerListener.this.ess.getOnlinePlayers().size())).replace("{UPTIME}", DateUtil.formatDateDiff(ManagementFactory.getRuntimeMXBean().getStartTime())).replace("{PREFIX}", FormatUtil.replaceFormat(EssentialsPlayerListener.this.ess.getPermissionsHandler().getPrefix(player))).replace("{SUFFIX}", FormatUtil.replaceFormat(EssentialsPlayerListener.this.ess.getPermissionsHandler().getSuffix(player))).replace("{OLDUSERNAME}", lastAccountName == null ? "" : lastAccountName);
                    if (!msg.isEmpty()) {
                        EssentialsPlayerListener.this.ess.getServer().broadcastMessage(msg);
                    }
                    effectiveMessage = msg.isEmpty() ? null : msg;
                } else if (EssentialsPlayerListener.this.ess.getSettings().allowSilentJoinQuit()) {
                    EssentialsPlayerListener.this.ess.getServer().broadcastMessage(message);
                    effectiveMessage = message;
                } else {
                    effectiveMessage = message;
                }
                EssentialsPlayerListener.this.ess.runTaskAsynchronously(() -> EssentialsPlayerListener.this.ess.getServer().getPluginManager().callEvent((Event)new AsyncUserDataLoadEvent(user, effectiveMessage)));
                if (EssentialsPlayerListener.this.ess.getSettings().getMotdDelay() >= 0) {
                    int motdDelay = EssentialsPlayerListener.this.ess.getSettings().getMotdDelay() / 50;
                    1DelayJoinTask.DelayMotdTask motdTask = new 1DelayJoinTask.DelayMotdTask(user);
                    if (motdDelay > 0) {
                        EssentialsPlayerListener.this.pendingMotdTasks.put(user.getUUID(), EssentialsPlayerListener.this.ess.scheduleSyncDelayedTask(motdTask, motdDelay));
                    } else {
                        motdTask.run();
                    }
                }
                if (!EssentialsPlayerListener.this.ess.getSettings().isCommandDisabled("mail") && user.isAuthorized("essentials.mail")) {
                    if (user.getUnreadMailAmount() == 0) {
                        if (EssentialsPlayerListener.this.ess.getSettings().isNotifyNoNewMail()) {
                            user.sendMessage(I18n.tl("noNewMail", new Object[0]));
                        }
                    } else {
                        user.notifyOfMail();
                    }
                }
                if (user.isAuthorized("essentials.updatecheck")) {
                    EssentialsPlayerListener.this.ess.runTaskAsynchronously(() -> {
                        for (String str : EssentialsPlayerListener.this.ess.getUpdateChecker().getVersionMessages(false, false)) {
                            user.sendMessage(str);
                        }
                    });
                }
                if (user.isAuthorized("essentials.fly.safelogin")) {
                    user.getBase().setFallDistance(0.0f);
                    if (LocationUtil.shouldFly(EssentialsPlayerListener.this.ess, user.getLocation())) {
                        user.getBase().setAllowFlight(true);
                        user.getBase().setFlying(true);
                        if (EssentialsPlayerListener.this.ess.getSettings().isSendFlyEnableOnJoin()) {
                            user.getBase().sendMessage(I18n.tl("flyMode", I18n.tl("enabled", new Object[0]), user.getDisplayName()));
                        }
                    }
                }
                if (!user.isAuthorized("essentials.speed")) {
                    user.getBase().setFlySpeed(0.1f);
                    user.getBase().setWalkSpeed(0.2f);
                }
                if (user.isSocialSpyEnabled() && !user.isAuthorized("essentials.socialspy")) {
                    user.setSocialSpyEnabled(false);
                    EssentialsPlayerListener.this.ess.getLogger().log(Level.INFO, "Set socialspy to false for {0} because they had it enabled without permission.", user.getName());
                }
                if (user.isGodModeEnabled() && !user.isAuthorized("essentials.god")) {
                    user.setGodModeEnabled(false);
                    EssentialsPlayerListener.this.ess.getLogger().log(Level.INFO, "Set god mode to false for {0} because they had it enabled without permission.", user.getName());
                }
                user.setConfirmingClearCommand(null);
                user.getConfirmingPayments().clear();
                user.stopTransaction();
            }

            class 1DelayJoinTask.DelayMotdTask
            implements Runnable {
                private final User user;

                1DelayJoinTask.DelayMotdTask(User user) {
                    this.user = user;
                }

                @Override
                public void run() {
                    IText input;
                    EssentialsPlayerListener.this.pendingMotdTasks.remove(this.user.getUUID());
                    IText tempInput = null;
                    if (!EssentialsPlayerListener.this.ess.getSettings().isCommandDisabled("motd")) {
                        try {
                            tempInput = new TextInput(this.user.getSource(), "motd", true, EssentialsPlayerListener.this.ess);
                        }
                        catch (IOException ex) {
                            if (EssentialsPlayerListener.this.ess.getSettings().isDebug()) {
                                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                            }
                            LOGGER.log(Level.WARNING, ex.getMessage());
                        }
                    }
                    if ((input = tempInput) != null && !input.getLines().isEmpty() && this.user.isAuthorized("essentials.motd")) {
                        KeywordReplacer output = new KeywordReplacer(input, this.user.getSource(), EssentialsPlayerListener.this.ess);
                        TextPager pager = new TextPager(output, true);
                        pager.showPage("1", null, "motd", this.user.getSource());
                    }
                }
            }
        }
        this.ess.scheduleSyncDelayedTask(new DelayJoinTask());
    }

    private void updateCompass(User user) {
        if (this.ess.getSettings().isCompassTowardsHomePerm() && !user.isAuthorized("essentials.home.compass")) {
            return;
        }
        Location loc = user.getHome(user.getLocation());
        if (loc == null) {
            PaperLib.getBedSpawnLocationAsync(user.getBase(), false).thenAccept(location -> {
                if (location != null) {
                    user.getBase().setCompassTarget(location);
                }
            });
            return;
        }
        user.getBase().setCompassTarget(loc);
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerLoginBanned(PlayerLoginEvent event) {
        if (event.getResult() == PlayerLoginEvent.Result.KICK_BANNED) {
            BanEntry banEntry = this.ess.getServer().getBanList(BanList.Type.NAME).getBanEntry(event.getPlayer().getName());
            if (banEntry != null) {
                Date banExpiry = banEntry.getExpiration();
                if (banExpiry != null) {
                    String expiry = DateUtil.formatDateDiff(banExpiry.getTime());
                    event.setKickMessage(I18n.tl("tempbanJoin", expiry, banEntry.getReason()));
                } else {
                    event.setKickMessage(I18n.tl("banJoin", banEntry.getReason()));
                }
            } else {
                banEntry = this.ess.getServer().getBanList(BanList.Type.IP).getBanEntry(event.getAddress().getHostAddress());
                if (banEntry != null) {
                    event.setKickMessage(I18n.tl("banIpJoin", banEntry.getReason()));
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerLogin(PlayerLoginEvent event) {
        if (event.getResult() == PlayerLoginEvent.Result.KICK_FULL) {
            User kfuser = this.ess.getUser(event.getPlayer());
            if (kfuser.isAuthorized("essentials.joinfullserver")) {
                event.allow();
                return;
            }
            if (this.ess.getSettings().isCustomServerFullMessage()) {
                event.disallow(PlayerLoginEvent.Result.KICK_FULL, I18n.tl("serverFull", new Object[0]));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        if (player.hasMetadata("NPC") || event.getCause() != PlayerTeleportEvent.TeleportCause.PLUGIN && event.getCause() != PlayerTeleportEvent.TeleportCause.COMMAND) {
            return;
        }
        User user = this.ess.getUser(player);
        if (this.ess.getSettings().registerBackInListener() && user.isAuthorized("essentials.back.onteleport")) {
            user.setLastLocation();
        }
        if (this.ess.getSettings().isTeleportInvulnerability()) {
            user.enableInvulnerabilityAfterTeleport();
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerEggThrow(PlayerEggThrowEvent event) {
        ItemStack stack;
        User user = this.ess.getUser(event.getPlayer());
        if (user.hasUnlimited(stack = new ItemStack(Material.EGG, 1))) {
            user.getBase().getInventory().addItem(new ItemStack[]{stack});
            user.getBase().updateInventory();
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerBucketEmpty(PlayerBucketEmptyEvent event) {
        User user = this.ess.getUser(event.getPlayer());
        if (user.hasUnlimited(new ItemStack(event.getBucket()))) {
            event.getItemStack().setType(event.getBucket());
            this.ess.scheduleSyncDelayedTask(() -> ((Player)user.getBase()).updateInventory());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        Command knownCommand;
        String args;
        String cmd = event.getMessage().toLowerCase(Locale.ENGLISH).split(" ")[0].replace("/", "").toLowerCase(Locale.ENGLISH);
        int argStartIndex = event.getMessage().indexOf(" ");
        String string = args = argStartIndex == -1 ? "" : event.getMessage().substring(argStartIndex);
        if (this.ess.getServer().getPluginCommand(cmd) == null && (knownCommand = this.ess.getKnownCommandsProvider().getKnownCommands().get(cmd)) instanceof FormattedCommandAlias) {
            FormattedCommandAlias command = (FormattedCommandAlias)knownCommand;
            for (String fullCommand : this.ess.getFormattedCommandAliasProvider().createCommands(command, (CommandSender)event.getPlayer(), args.split(" "))) {
                this.handlePlayerCommandPreprocess(event, fullCommand);
            }
            return;
        }
        this.handlePlayerCommandPreprocess(event, cmd + args);
    }

    public void handlePlayerCommandPreprocess(PlayerCommandPreprocessEvent event, String effectiveCommand) {
        User user;
        Player player = event.getPlayer();
        String cmd = effectiveCommand.toLowerCase(Locale.ENGLISH).split(" ")[0].replace("/", "").toLowerCase(Locale.ENGLISH);
        PluginCommand pluginCommand = this.ess.getServer().getPluginCommand(cmd);
        if (!(!this.ess.getSettings().getSocialSpyCommands().contains(cmd) && !this.ess.getSettings().getSocialSpyCommands().contains("*") || pluginCommand != null && (pluginCommand.getName().equals("msg") || pluginCommand.getName().equals("r")) || (user = this.ess.getUser(player)).isAuthorized("essentials.chat.spy.exempt"))) {
            for (User spyer : this.ess.getOnlineUsers()) {
                if (!spyer.isSocialSpyEnabled() || player.equals(spyer.getBase())) continue;
                if (user.isMuted() && this.ess.getSettings().getSocialSpyListenMutedPlayers()) {
                    spyer.sendMessage(I18n.tl("socialSpyMutedPrefix", new Object[0]) + player.getDisplayName() + ": " + event.getMessage());
                    continue;
                }
                spyer.sendMessage(I18n.tl("socialSpyPrefix", new Object[0]) + player.getDisplayName() + ": " + event.getMessage());
            }
        }
        if ((user = this.ess.getUser(player)).isMuted() && (this.ess.getSettings().getMuteCommands().contains(cmd) || this.ess.getSettings().getMuteCommands().contains("*"))) {
            String dateDiff;
            event.setCancelled(true);
            String string = dateDiff = user.getMuteTimeout() > 0L ? DateUtil.formatDateDiff(user.getMuteTimeout()) : null;
            if (dateDiff == null) {
                player.sendMessage(user.hasMuteReason() ? I18n.tl("voiceSilencedReason", user.getMuteReason()) : I18n.tl("voiceSilenced", new Object[0]));
            } else {
                player.sendMessage(user.hasMuteReason() ? I18n.tl("voiceSilencedReasonTime", dateDiff, user.getMuteReason()) : I18n.tl("voiceSilencedTime", dateDiff));
            }
            LOGGER.info(I18n.tl("mutedUserSpeaks", player.getName(), event.getMessage()));
            return;
        }
        boolean broadcast = true;
        boolean update = true;
        if (pluginCommand != null) {
            switch (pluginCommand.getName()) {
                case "afk": {
                    update = false;
                }
                case "vanish": {
                    broadcast = false;
                }
            }
        }
        if (update) {
            user.updateActivityOnInteract(broadcast);
        }
        if (this.ess.getSettings().isCommandCooldownsEnabled() && !user.isAuthorized("essentials.commandcooldowns.bypass")) {
            Map.Entry<Pattern, Long> cooldownEntry;
            int argStartIndex = effectiveCommand.indexOf(" ");
            String args = argStartIndex == -1 ? "" : " " + effectiveCommand.substring(argStartIndex);
            String fullCommand = pluginCommand == null ? effectiveCommand : pluginCommand.getName() + args;
            boolean cooldownFound = false;
            for (Map.Entry<Pattern, Long> entry : new HashMap<Pattern, Long>(user.getCommandCooldowns()).entrySet()) {
                if (entry.getValue() <= System.currentTimeMillis()) {
                    user.clearCommandCooldown(entry.getKey());
                    continue;
                }
                if (!entry.getKey().matcher(fullCommand).matches() || entry.getValue() <= System.currentTimeMillis()) continue;
                String commandCooldownTime = DateUtil.formatDateDiff(entry.getValue());
                user.sendMessage(I18n.tl("commandCooldown", commandCooldownTime));
                cooldownFound = true;
                event.setCancelled(true);
                break;
            }
            if (!cooldownFound && (cooldownEntry = this.ess.getSettings().getCommandCooldownEntry(fullCommand)) != null) {
                if (this.ess.getSettings().isDebug()) {
                    this.ess.getLogger().info("Applying " + cooldownEntry.getValue() + "ms cooldown on /" + fullCommand + " for" + user.getName() + ".");
                }
                Date expiry = new Date(System.currentTimeMillis() + cooldownEntry.getValue());
                user.addCommandCooldown(cooldownEntry.getKey(), expiry, this.ess.getSettings().isCommandCooldownPersistent(fullCommand));
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerChangedWorldFlyReset(PlayerChangedWorldEvent event) {
        User user = this.ess.getUser(event.getPlayer());
        if (this.ess.getSettings().isWorldChangeFlyResetEnabled() && user.getBase().getGameMode() != GameMode.CREATIVE && !user.getBase().getGameMode().name().equals("SPECTATOR") && !user.isAuthorized("essentials.fly")) {
            user.getBase().setFallDistance(0.0f);
            user.getBase().setAllowFlight(false);
        }
        if (this.ess.getSettings().isWorldChangeSpeedResetEnabled()) {
            if (!user.isAuthorized("essentials.speed")) {
                user.getBase().setFlySpeed(0.1f);
                user.getBase().setWalkSpeed(0.2f);
            } else {
                if ((double)user.getBase().getFlySpeed() > this.ess.getSettings().getMaxFlySpeed() && !user.isAuthorized("essentials.speed.bypass")) {
                    user.getBase().setFlySpeed((float)this.ess.getSettings().getMaxFlySpeed());
                } else {
                    user.getBase().setFlySpeed(user.getBase().getFlySpeed() * 0.99999f);
                }
                if ((double)user.getBase().getWalkSpeed() > this.ess.getSettings().getMaxWalkSpeed() && !user.isAuthorized("essentials.speed.bypass")) {
                    user.getBase().setWalkSpeed((float)this.ess.getSettings().getMaxWalkSpeed());
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerChangedWorld(PlayerChangedWorldEvent event) {
        User user = this.ess.getUser(event.getPlayer());
        String newWorld = event.getPlayer().getLocation().getWorld().getName();
        user.setDisplayNick();
        this.updateCompass(user);
        if (this.ess.getSettings().getNoGodWorlds().contains(newWorld) && user.isGodModeEnabledRaw()) {
            user.sendMessage(I18n.tl("noGodWorldWarning", new Object[0]));
        }
        if (!user.getWorld().getName().equals(newWorld)) {
            user.sendMessage(I18n.tl("currentWorld", newWorld));
        }
        if (user.isVanished()) {
            user.setVanished(user.isAuthorized("essentials.vanish"));
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerInteract(PlayerInteractEvent event) {
        boolean updateActivity = true;
        switch (event.getAction()) {
            case RIGHT_CLICK_BLOCK: {
                User player;
                if (event.isCancelled() || !MaterialUtil.isBed(event.getClickedBlock().getType()) || !this.ess.getSettings().getUpdateBedAtDaytime() || VersionUtil.getServerBukkitVersion().isHigherThanOrEqualTo(VersionUtil.v1_13_2_R01) && ((Bed)event.getClickedBlock().getBlockData()).isOccupied() || !(player = this.ess.getUser(event.getPlayer())).isAuthorized("essentials.sethome.bed") || !player.getWorld().getEnvironment().equals((Object)World.Environment.NORMAL)) break;
                player.getBase().setBedSpawnLocation(event.getClickedBlock().getLocation());
                if (!VersionUtil.getServerBukkitVersion().isLowerThan(VersionUtil.v1_15_R01)) break;
                player.sendMessage(I18n.tl("bedSet", player.getLocation().getWorld().getName(), player.getLocation().getBlockX(), player.getLocation().getBlockY(), player.getLocation().getBlockZ()));
                break;
            }
            case LEFT_CLICK_AIR: {
                User user;
                if (event.getPlayer().isFlying() && (user = this.ess.getUser(event.getPlayer())).isFlyClickJump()) {
                    this.useFlyClickJump(user);
                    break;
                }
            }
            case LEFT_CLICK_BLOCK: {
                User user;
                if (event.getItem() == null || event.getItem().getType() == Material.AIR || !(user = this.ess.getUser(event.getPlayer())).hasPowerTools() || !user.arePowerToolsEnabled() || !this.usePowertools(user, event.getItem().getType())) break;
                event.setCancelled(true);
                break;
            }
            case PHYSICAL: {
                updateActivity = false;
                break;
            }
        }
        if (updateActivity) {
            this.ess.getUser(event.getPlayer()).updateActivityOnInteract(true);
        }
    }

    private void useFlyClickJump(final User user) {
        block2: {
            try {
                final Location otarget = LocationUtil.getTarget((LivingEntity)user.getBase());
                class DelayedClickJumpTask
                implements Runnable {
                    DelayedClickJumpTask() {
                    }

                    @Override
                    public void run() {
                        Location loc = user.getLocation();
                        loc.setX(otarget.getX());
                        loc.setZ(otarget.getZ());
                        while (LocationUtil.isBlockDamaging(loc.getWorld(), loc.getBlockX(), loc.getBlockY() - 1, loc.getBlockZ())) {
                            loc.setY(loc.getY() + 1.0);
                        }
                        PaperLib.teleportAsync((Entity)user.getBase(), loc, PlayerTeleportEvent.TeleportCause.PLUGIN);
                    }
                }
                this.ess.scheduleSyncDelayedTask(new DelayedClickJumpTask());
            }
            catch (Exception ex) {
                if (!this.ess.getSettings().isDebug()) break block2;
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    private boolean usePowertools(final User user, Material material) {
        List<String> commandList = user.getPowertool(material);
        if (commandList == null || commandList.isEmpty()) {
            return false;
        }
        boolean used = false;
        for (final String command : commandList) {
            if (command.contains("{player}")) continue;
            if (command.startsWith("c:")) {
                used = true;
                user.getBase().chat(command.substring(2));
                continue;
            }
            used = true;
            class PowerToolUseTask
            implements Runnable {
                PowerToolUseTask() {
                }

                @Override
                public void run() {
                    user.getBase().chat("/" + command);
                    LOGGER.log(Level.INFO, String.format("[PT] %s issued server command: /%s", user.getName(), command));
                }
            }
            this.ess.scheduleSyncDelayedTask(new PowerToolUseTask());
        }
        return used;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onInventoryClickEvent(InventoryClickEvent event) {
        Player refreshPlayer = null;
        Inventory top = event.getView().getTopInventory();
        InventoryType type = top.getType();
        Inventory clickedInventory = event.getRawSlot() < 0 ? null : (event.getRawSlot() < top.getSize() ? top : event.getView().getBottomInventory());
        User user = this.ess.getUser((Player)event.getWhoClicked());
        if (type == InventoryType.PLAYER) {
            InventoryHolder invHolder = top.getHolder();
            if (invHolder instanceof HumanEntity) {
                User invOwner = this.ess.getUser((Player)invHolder);
                if (user.isInvSee() && (!user.isAuthorized("essentials.invsee.modify") || invOwner.isAuthorized("essentials.invsee.preventmodify") || !invOwner.getBase().isOnline())) {
                    event.setCancelled(true);
                    refreshPlayer = user.getBase();
                }
            }
        } else if (type == InventoryType.ENDER_CHEST) {
            if (user.isEnderSee() && !user.isAuthorized("essentials.enderchest.modify")) {
                event.setCancelled(true);
                refreshPlayer = user.getBase();
            }
        } else if (type == InventoryType.WORKBENCH) {
            if (user.isRecipeSee()) {
                event.setCancelled(true);
                refreshPlayer = user.getBase();
            }
        } else if (type == InventoryType.CHEST && top.getSize() == 9) {
            InventoryHolder invHolder = top.getHolder();
            if (invHolder instanceof HumanEntity && user.isInvSee() && event.getClick() != ClickType.MIDDLE) {
                event.setCancelled(true);
                refreshPlayer = user.getBase();
            }
        } else if (clickedInventory != null && clickedInventory.getType() == InventoryType.PLAYER && this.ess.getSettings().isDirectHatAllowed() && event.getClick() == ClickType.LEFT && event.getSlot() == 39 && event.getCursor().getType() != Material.AIR && event.getCursor().getType().getMaxDurability() == 0 && !MaterialUtil.isSkull(event.getCursor().getType()) && user.isAuthorized("essentials.hat") && !user.isAuthorized("essentials.hat.prevent-type." + event.getCursor().getType().name().toLowerCase()) && !this.isPreventBindingHat(user, (PlayerInventory)clickedInventory)) {
            event.setCancelled(true);
            PlayerInventory inv = (PlayerInventory)clickedInventory;
            ItemStack head = inv.getHelmet();
            inv.setHelmet(event.getCursor());
            event.setCursor(head);
        }
        if (refreshPlayer != null) {
            this.ess.scheduleSyncDelayedTask(() -> refreshPlayer.updateInventory(), 1L);
        }
    }

    private boolean isPreventBindingHat(User user, PlayerInventory inventory) {
        if (VersionUtil.getServerBukkitVersion().isHigherThan(VersionUtil.v1_9_4_R01)) {
            ItemStack head = inventory.getHelmet();
            return head != null && head.getEnchantments().containsKey(Enchantment.BINDING_CURSE) && !user.isAuthorized("essentials.hat.ignore-binding");
        }
        return false;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onInventoryCloseEvent(InventoryCloseEvent event) {
        InventoryHolder invHolder;
        Player refreshPlayer = null;
        Inventory top = event.getView().getTopInventory();
        InventoryType type = top.getType();
        if (type == InventoryType.PLAYER) {
            User user = this.ess.getUser((Player)event.getPlayer());
            user.setInvSee(false);
            refreshPlayer = user.getBase();
        } else if (type == InventoryType.ENDER_CHEST) {
            User user = this.ess.getUser((Player)event.getPlayer());
            user.setEnderSee(false);
            refreshPlayer = user.getBase();
        } else if (type == InventoryType.WORKBENCH) {
            User user = this.ess.getUser((Player)event.getPlayer());
            if (user.isRecipeSee()) {
                user.setRecipeSee(false);
                event.getView().getTopInventory().clear();
                refreshPlayer = user.getBase();
            }
        } else if (type == InventoryType.CHEST && top.getSize() == 9 && (invHolder = top.getHolder()) instanceof HumanEntity) {
            User user = this.ess.getUser((Player)event.getPlayer());
            user.setInvSee(false);
            refreshPlayer = user.getBase();
        }
        if (refreshPlayer != null) {
            this.ess.scheduleSyncDelayedTask(() -> ((Player)refreshPlayer).updateInventory(), 1L);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerFishEvent(PlayerFishEvent event) {
        User user = this.ess.getUser(event.getPlayer());
        user.updateActivityOnInteract(true);
    }

    @Override
    public void getUser(Player player) {
        this.ess.getUser(player);
    }

    private static final class ArrowPickupListener
    implements Listener {
        private ArrowPickupListener() {
        }

        @EventHandler(priority=EventPriority.LOW)
        public void onArrowPickup(PlayerPickupArrowEvent event) {
            if (event.getItem().hasMetadata("ess_fireball_proj")) {
                event.setCancelled(true);
            }
        }
    }

    private final class PickupListener1_12
    implements Listener {
        private PickupListener1_12() {
        }

        @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
        public void onPlayerPickupItem(EntityPickupItemEvent event) {
            if (EssentialsPlayerListener.this.ess.getSettings().getDisableItemPickupWhileAfk() && event.getEntity() instanceof Player && EssentialsPlayerListener.this.ess.getUser((Player)event.getEntity()).isAfk()) {
                event.setCancelled(true);
            }
        }
    }

    private final class PickupListenerPre1_12
    implements Listener {
        private PickupListenerPre1_12() {
        }

        @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
        public void onPlayerPickupItem(PlayerPickupItemEvent event) {
            if (event.getItem().hasMetadata("ess_fireball_proj")) {
                event.setCancelled(true);
            } else if (EssentialsPlayerListener.this.ess.getSettings().getDisableItemPickupWhileAfk() && EssentialsPlayerListener.this.ess.getUser(event.getPlayer()).isAfk()) {
                event.setCancelled(true);
            }
        }
    }

    private final class CommandSendFilter
    implements CommandSendListenerProvider.Filter {
        private CommandSendFilter() {
        }

        @Override
        public Predicate<String> apply(Player player) {
            User user = EssentialsPlayerListener.this.ess.getUser(player);
            HashSet checked = new HashSet();
            HashSet toRemove = new HashSet();
            return label -> {
                if (this.isEssentialsCommand((String)label)) {
                    PluginCommand command = EssentialsPlayerListener.this.ess.getServer().getPluginCommand(label);
                    if (!checked.contains(command)) {
                        checked.add(command);
                        if (!user.isAuthorized(command.getName().equals("r") ? "essentials.msg" : "essentials." + command.getName())) {
                            toRemove.add(command);
                        }
                    }
                    return toRemove.contains(command);
                }
                return false;
            };
        }

        private boolean isEssentialsCommand(String label) {
            PluginCommand command = EssentialsPlayerListener.this.ess.getServer().getPluginCommand(label);
            return !(command == null || command.getPlugin() != EssentialsPlayerListener.this.ess && !command.getPlugin().getClass().getName().startsWith("com.earth2me.essentials") && !command.getPlugin().getClass().getName().startsWith("net.essentialsx") || !EssentialsPlayerListener.this.ess.getSettings().isCommandOverridden(label) && EssentialsPlayerListener.this.ess.getAlternativeCommandsHandler().getAlternative(label) != null);
        }
    }
}

