/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.I18n;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.math.BigInteger;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import net.ess3.api.IEssentials;
import org.bukkit.Bukkit;

public class ManagedFile {
    private static final int BUFFERSIZE = 8192;
    private final transient File file;

    public ManagedFile(String filename, IEssentials ess) {
        this.file = new File(ess.getDataFolder(), filename);
        if (this.file.exists()) {
            try {
                if (ManagedFile.checkForVersion(this.file, ess.getDescription().getVersion()) && !this.file.delete()) {
                    throw new IOException("Could not delete file " + this.file.toString());
                }
            }
            catch (IOException ex) {
                Bukkit.getLogger().log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        if (!this.file.exists()) {
            try {
                ManagedFile.copyResourceAscii("/" + filename, this.file);
            }
            catch (IOException ex) {
                Bukkit.getLogger().log(Level.SEVERE, I18n.tl("itemsCsvNotLoaded", filename), ex);
            }
        }
    }

    public static void copyResourceAscii(String resourceName, File file) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(ManagedFile.class.getResourceAsStream(resourceName));){
            MessageDigest digest = ManagedFile.getDigest();
            try (DigestOutputStream digestStream = new DigestOutputStream(new FileOutputStream(file), digest);
                 OutputStreamWriter writer = new OutputStreamWriter(digestStream);){
                int length;
                char[] buffer = new char[8192];
                while ((length = reader.read(buffer)) >= 0) {
                    writer.write(buffer, 0, length);
                }
                writer.write("\n");
                writer.flush();
                BigInteger hashInt = new BigInteger(1, digest.digest());
                digestStream.on(false);
                digestStream.write(35);
                digestStream.write(hashInt.toString(16).getBytes());
            }
        }
    }

    public static boolean checkForVersion(File file, String version) throws IOException {
        block23: {
            if (file.length() < 33L) {
                return false;
            }
            try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));){
                int length;
                byte[] buffer = new byte[(int)file.length()];
                int position = 0;
                while ((length = bis.read(buffer, position, Math.min((int)file.length() - position, 8192))) >= 0 && (long)(position += length) < file.length()) {
                }
                ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
                if (bais.skip(file.length() - 33L) != file.length() - 33L) {
                    boolean bl = false;
                    return bl;
                }
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(bais));){
                    String versioncheck;
                    String hash = reader.readLine();
                    if (hash == null || !hash.matches("#[a-f0-9]{32}")) break block23;
                    hash = hash.substring(1);
                    bais.reset();
                    String versionline = reader.readLine();
                    if (versionline == null || !versionline.matches("#version: .+") || (versioncheck = versionline.substring(10)).equalsIgnoreCase(version)) break block23;
                    bais.reset();
                    MessageDigest digest = ManagedFile.getDigest();
                    try (DigestInputStream digestStream = new DigestInputStream(bais, digest);){
                        byte[] bytes = new byte[(int)file.length() - 33];
                        digestStream.read(bytes);
                        BigInteger correct = new BigInteger(hash, 16);
                        BigInteger test = new BigInteger(1, digest.digest());
                        if (correct.equals(test)) {
                            boolean bl = true;
                            return bl;
                        }
                        Bukkit.getLogger().warning("File " + file.toString() + " has been modified by user and file version differs, please update the file manually.");
                    }
                }
            }
        }
        return false;
    }

    public static MessageDigest getDigest() throws IOException {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IOException(ex);
        }
    }

    public List<String> getLines() {
        ArrayList<String> arrayList;
        BufferedReader reader = new BufferedReader(new FileReader(this.file));
        try {
            String line;
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
            arrayList = lines;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                Bukkit.getLogger().log(Level.SEVERE, ex.getMessage(), ex);
                return Collections.emptyList();
            }
        }
        reader.close();
        return arrayList;
    }
}

