/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.Enchantments;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.Potions;
import com.earth2me.essentials.User;
import com.earth2me.essentials.textreader.BookInput;
import com.earth2me.essentials.textreader.BookPager;
import com.earth2me.essentials.utils.EnumUtil;
import com.earth2me.essentials.utils.FormatUtil;
import com.earth2me.essentials.utils.MaterialUtil;
import com.earth2me.essentials.utils.NumberUtil;
import com.earth2me.essentials.utils.VersionUtil;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import net.ess3.api.IEssentials;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.block.Banner;
import org.bukkit.block.BlockState;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.potion.Potion;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class MetaItemStack {
    private static final Map<String, DyeColor> colorMap = new HashMap<String, DyeColor>();
    private static final Map<String, FireworkEffect.Type> fireworkShape = new HashMap<String, FireworkEffect.Type>();
    private static boolean useNewSkullMethod = true;
    private static final transient java.util.regex.Pattern splitPattern;
    private static final transient java.util.regex.Pattern hexPattern;
    private ItemStack stack;
    private FireworkEffect.Builder builder = FireworkEffect.builder();
    private PotionEffectType pEffectType;
    private PotionEffect pEffect;
    private boolean validFirework = false;
    private boolean validFireworkCharge = false;
    private boolean validPotionEffect = false;
    private boolean validPotionDuration = false;
    private boolean validPotionPower = false;
    private boolean isSplashPotion = false;
    private boolean completePotion = false;
    private int power = 1;
    private int duration = 120;

    public MetaItemStack(ItemStack stack) {
        this.stack = stack.clone();
    }

    private static void setSkullOwner(IEssentials ess, ItemStack stack, String owner) {
        if (!(stack.getItemMeta() instanceof SkullMeta)) {
            return;
        }
        SkullMeta meta = (SkullMeta)stack.getItemMeta();
        if (useNewSkullMethod) {
            try {
                meta.setOwningPlayer(ess.getServer().getOfflinePlayer(owner));
                stack.setItemMeta((ItemMeta)meta);
                return;
            }
            catch (NoSuchMethodError e) {
                useNewSkullMethod = false;
            }
        }
        meta.setOwner(owner);
        stack.setItemMeta((ItemMeta)meta);
    }

    public ItemStack getItemStack() {
        return this.stack;
    }

    public boolean isValidFirework() {
        return this.validFirework;
    }

    public boolean isValidPotion() {
        return this.validPotionEffect && this.validPotionDuration && this.validPotionPower;
    }

    public FireworkEffect.Builder getFireworkBuilder() {
        return this.builder;
    }

    public PotionEffect getPotionEffect() {
        return this.pEffect;
    }

    public boolean completePotion() {
        return this.completePotion;
    }

    private void resetPotionMeta() {
        this.pEffect = null;
        this.pEffectType = null;
        this.validPotionEffect = false;
        this.validPotionDuration = false;
        this.validPotionPower = false;
        this.isSplashPotion = false;
        this.completePotion = true;
    }

    public boolean canSpawn(IEssentials ess) {
        try {
            ess.getServer().getUnsafe().modifyItemStack(this.stack.clone(), "{}");
            return true;
        }
        catch (NoSuchMethodError nsme) {
            return true;
        }
        catch (Throwable npe) {
            if (ess.getSettings().isDebug()) {
                ess.getLogger().log(Level.INFO, "Itemstack is invalid", npe);
            }
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parseStringMeta(CommandSource sender, boolean allowUnsafe, String[] string, int fromArg, IEssentials ess) throws Exception {
        if (string[fromArg].startsWith("{") && this.hasMetaPermission(sender, "vanilla", false, true, ess)) {
            try {
                this.stack = ess.getServer().getUnsafe().modifyItemStack(this.stack, Joiner.on((char)' ').join(Arrays.asList(string).subList(fromArg, string.length)));
                return;
            }
            catch (NullPointerException npe) {
                if (!ess.getSettings().isDebug()) return;
                ess.getLogger().log(Level.INFO, "Itemstack is invalid", npe);
                return;
            }
            catch (NoSuchMethodError nsme) {
                throw new Exception(I18n.tl("noMetaJson", new Object[0]), nsme);
            }
            catch (Throwable throwable) {
                throw new Exception(throwable.getMessage(), throwable);
            }
        } else {
            for (int i = fromArg; i < string.length; ++i) {
                this.addStringMeta(sender, allowUnsafe, string[i], ess);
            }
            if (this.validFirework) {
                if (!this.hasMetaPermission(sender, "firework", true, true, ess)) {
                    throw new Exception(I18n.tl("noMetaFirework", new Object[0]));
                }
                FireworkEffect effect = this.builder.build();
                FireworkMeta fmeta = (FireworkMeta)this.stack.getItemMeta();
                fmeta.addEffect(effect);
                if (fmeta.getEffects().size() > 1 && !this.hasMetaPermission(sender, "firework-multiple", true, true, ess)) {
                    throw new Exception(I18n.tl("multipleCharges", new Object[0]));
                }
                this.stack.setItemMeta((ItemMeta)fmeta);
            }
            if (!this.validFireworkCharge) return;
            if (!this.hasMetaPermission(sender, "firework", true, true, ess)) {
                throw new Exception(I18n.tl("noMetaFirework", new Object[0]));
            }
            FireworkEffect effect = this.builder.build();
            FireworkEffectMeta meta = (FireworkEffectMeta)this.stack.getItemMeta();
            meta.setEffect(effect);
            this.stack.setItemMeta((ItemMeta)meta);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addStringMeta(CommandSource sender, boolean allowUnsafe, String string, IEssentials ess) throws Exception {
        String[] split = splitPattern.split(string, 2);
        if (split.length < 1) {
            return;
        }
        Material WRITTEN_BOOK = EnumUtil.getMaterial("WRITTEN_BOOK");
        if (split.length > 1 && split[0].equalsIgnoreCase("name") && this.hasMetaPermission(sender, "name", false, true, ess)) {
            String displayName = FormatUtil.replaceFormat(split[1].replace('_', ' '));
            ItemMeta meta = this.stack.getItemMeta();
            meta.setDisplayName(displayName);
            this.stack.setItemMeta(meta);
            return;
        } else if (split.length > 1 && (split[0].equalsIgnoreCase("lore") || split[0].equalsIgnoreCase("desc")) && this.hasMetaPermission(sender, "lore", false, true, ess)) {
            ArrayList<String> lore = new ArrayList<String>();
            for (String line : split[1].split("(?<!\\\\)\\|")) {
                lore.add(FormatUtil.replaceFormat(line.replace('_', ' ').replace("\\|", "|")));
            }
            ItemMeta meta = this.stack.getItemMeta();
            meta.setLore(lore);
            this.stack.setItemMeta(meta);
            return;
        } else if (split[0].equalsIgnoreCase("unbreakable") && this.hasMetaPermission(sender, "unbreakable", false, true, ess)) {
            boolean value = split.length <= 1 || Boolean.parseBoolean(split[1]);
            this.setUnbreakable(ess, this.stack, value);
            return;
        } else if (split.length > 1 && (split[0].equalsIgnoreCase("player") || split[0].equalsIgnoreCase("owner")) && this.hasMetaPermission(sender, "head", false, true, ess)) {
            if (!MaterialUtil.isPlayerHead(this.stack.getType(), this.stack.getDurability())) throw new Exception(I18n.tl("onlyPlayerSkulls", new Object[0]));
            String owner = split[1];
            MetaItemStack.setSkullOwner(ess, this.stack, owner);
            return;
        } else if (split.length > 1 && split[0].equalsIgnoreCase("book") && MaterialUtil.isEditableBook(this.stack.getType()) && (this.hasMetaPermission(sender, "book", true, true, ess) || this.hasMetaPermission(sender, "chapter-" + split[1].toLowerCase(Locale.ENGLISH), true, true, ess))) {
            BookMeta meta = (BookMeta)this.stack.getItemMeta();
            BookInput input = new BookInput("book", true, ess);
            BookPager pager = new BookPager(input);
            List<String> pages = pager.getPages(split[1]);
            meta.setPages(pages);
            this.stack.setItemMeta((ItemMeta)meta);
            return;
        } else if (split.length > 1 && split[0].equalsIgnoreCase("author") && this.stack.getType() == WRITTEN_BOOK && this.hasMetaPermission(sender, "author", false, true, ess)) {
            String author = FormatUtil.replaceFormat(split[1]);
            BookMeta meta = (BookMeta)this.stack.getItemMeta();
            meta.setAuthor(author);
            this.stack.setItemMeta((ItemMeta)meta);
            return;
        } else if (split.length > 1 && split[0].equalsIgnoreCase("title") && this.stack.getType() == WRITTEN_BOOK && this.hasMetaPermission(sender, "title", false, true, ess)) {
            String title = FormatUtil.replaceFormat(split[1].replace('_', ' '));
            BookMeta meta = (BookMeta)this.stack.getItemMeta();
            meta.setTitle(title);
            this.stack.setItemMeta((ItemMeta)meta);
            return;
        } else if (split.length > 1 && split[0].startsWith("page") && split[0].length() > 4 && MaterialUtil.isEditableBook(this.stack.getType()) && this.hasMetaPermission(sender, "page", false, true, ess)) {
            int page = NumberUtil.isInt(split[0].substring(4)) ? Integer.parseInt(split[0].substring(4)) - 1 : 0;
            BookMeta meta = (BookMeta)this.stack.getItemMeta();
            ArrayList<String> pages = meta.hasPages() ? new ArrayList<String>(meta.getPages()) : new ArrayList();
            ArrayList<String> lines = new ArrayList<String>();
            for (String line : split[1].split("(?<!\\\\)\\|")) {
                lines.add(FormatUtil.replaceFormat(line.replace('_', ' ').replace("\\|", "|")));
            }
            String content = String.join((CharSequence)"\n", lines);
            if (page >= pages.size()) {
                for (int i = 0; i <= page - pages.size(); ++i) {
                    pages.add("");
                }
            }
            pages.set(page, content);
            meta.setPages(pages);
            this.stack.setItemMeta((ItemMeta)meta);
            return;
        } else if (split.length > 1 && split[0].equalsIgnoreCase("power") && MaterialUtil.isFirework(this.stack.getType()) && this.hasMetaPermission(sender, "firework-power", false, true, ess)) {
            int power = NumberUtil.isInt(split[1]) ? Integer.parseInt(split[1]) : 0;
            FireworkMeta meta = (FireworkMeta)this.stack.getItemMeta();
            meta.setPower(power > 3 ? 4 : power);
            this.stack.setItemMeta((ItemMeta)meta);
            return;
        } else if (split.length > 1 && split[0].equalsIgnoreCase("itemflags") && this.hasMetaPermission(sender, "itemflags", false, true, ess)) {
            this.addItemFlags(string);
            return;
        } else if (MaterialUtil.isFirework(this.stack.getType())) {
            if (this.parseEnchantmentStrings(sender, allowUnsafe, split, ess)) return;
            this.addFireworkMeta(sender, false, string, ess);
            return;
        } else if (MaterialUtil.isFireworkCharge(this.stack.getType())) {
            if (this.parseEnchantmentStrings(sender, allowUnsafe, split, ess)) return;
            this.addChargeMeta(sender, false, string, ess);
            return;
        } else if (MaterialUtil.isPotion(this.stack.getType())) {
            if (!split[0].equalsIgnoreCase("power") && this.parseEnchantmentStrings(sender, allowUnsafe, split, ess)) return;
            this.addPotionMeta(sender, false, string, ess);
            return;
        } else if (MaterialUtil.isBanner(this.stack.getType())) {
            if (this.parseEnchantmentStrings(sender, allowUnsafe, split, ess)) return;
            this.addBannerMeta(sender, false, string, ess);
            return;
        } else if (split.length > 1 && (split[0].equalsIgnoreCase("color") || split[0].equalsIgnoreCase("colour")) && MaterialUtil.isLeatherArmor(this.stack.getType())) {
            String[] color = split[1].split("[|,]");
            if (color.length == 1 && (NumberUtil.isInt(color[0]) || color[0].startsWith("#"))) {
                LeatherArmorMeta meta = (LeatherArmorMeta)this.stack.getItemMeta();
                String input = color[0];
                if (input.startsWith("#")) {
                    meta.setColor(Color.fromRGB((int)Integer.valueOf(input.substring(1, 3), 16), (int)Integer.valueOf(input.substring(3, 5), 16), (int)Integer.valueOf(input.substring(5, 7), 16)));
                } else {
                    meta.setColor(Color.fromRGB((int)Integer.parseInt(input)));
                }
                this.stack.setItemMeta((ItemMeta)meta);
                return;
            } else {
                if (color.length != 3) throw new Exception(I18n.tl("leatherSyntax", new Object[0]));
                int red = NumberUtil.isInt(color[0]) ? Integer.parseInt(color[0]) : 0;
                int green = NumberUtil.isInt(color[1]) ? Integer.parseInt(color[1]) : 0;
                int blue = NumberUtil.isInt(color[2]) ? Integer.parseInt(color[2]) : 0;
                LeatherArmorMeta meta = (LeatherArmorMeta)this.stack.getItemMeta();
                meta.setColor(Color.fromRGB((int)red, (int)green, (int)blue));
                this.stack.setItemMeta((ItemMeta)meta);
            }
            return;
        } else {
            this.parseEnchantmentStrings(sender, allowUnsafe, split, ess);
        }
    }

    public void addItemFlags(String string) throws Exception {
        String[] separate = splitPattern.split(string, 2);
        if (separate.length != 2) {
            throw new Exception(I18n.tl("invalidItemFlagMeta", string));
        }
        String[] split = separate[1].split(",");
        ItemMeta meta = this.stack.getItemMeta();
        for (String s2 : split) {
            for (ItemFlag flag : ItemFlag.values()) {
                if (!s2.equalsIgnoreCase(flag.name())) continue;
                meta.addItemFlags(new ItemFlag[]{flag});
            }
        }
        if (meta.getItemFlags().isEmpty()) {
            throw new Exception(I18n.tl("invalidItemFlagMeta", string));
        }
        this.stack.setItemMeta(meta);
    }

    private void addChargeMeta(CommandSource sender, boolean allowShortName, String string, IEssentials ess) throws Exception {
        String[] split = splitPattern.split(string, 2);
        if (split.length < 2) {
            return;
        }
        if (split[0].equalsIgnoreCase("color") || split[0].equalsIgnoreCase("colour") || allowShortName && split[0].equalsIgnoreCase("c")) {
            String[] colors;
            ArrayList<Color> primaryColors = new ArrayList<Color>();
            for (String color : colors = split[1].split(",")) {
                if (colorMap.containsKey(color.toUpperCase())) {
                    this.validFireworkCharge = true;
                    primaryColors.add(colorMap.get(color.toUpperCase()).getFireworkColor());
                    continue;
                }
                if (hexPattern.matcher(color).matches()) {
                    this.validFireworkCharge = true;
                    primaryColors.add(Color.fromRGB((int)Integer.decode(color)));
                    continue;
                }
                throw new Exception(I18n.tl("invalidFireworkFormat", split[1], split[0]));
            }
            this.builder.withColor(primaryColors);
        } else if (split[0].equalsIgnoreCase("shape") || split[0].equalsIgnoreCase("type") || allowShortName && (split[0].equalsIgnoreCase("s") || split[0].equalsIgnoreCase("t"))) {
            FireworkEffect.Type finalEffect = null;
            String string2 = split[1] = split[1].equalsIgnoreCase("large") ? "BALL_LARGE" : split[1];
            if (!fireworkShape.containsKey(split[1].toUpperCase())) {
                throw new Exception(I18n.tl("invalidFireworkFormat", split[1], split[0]));
            }
            finalEffect = fireworkShape.get(split[1].toUpperCase());
            if (finalEffect != null) {
                this.builder.with(finalEffect);
            }
        } else if (split[0].equalsIgnoreCase("fade") || allowShortName && split[0].equalsIgnoreCase("f")) {
            String[] colors;
            ArrayList<Color> fadeColors = new ArrayList<Color>();
            for (String color : colors = split[1].split(",")) {
                if (colorMap.containsKey(color.toUpperCase())) {
                    fadeColors.add(colorMap.get(color.toUpperCase()).getFireworkColor());
                    continue;
                }
                if (hexPattern.matcher(color).matches()) {
                    fadeColors.add(Color.fromRGB((int)Integer.decode(color)));
                    continue;
                }
                throw new Exception(I18n.tl("invalidFireworkFormat", split[1], split[0]));
            }
            if (!fadeColors.isEmpty()) {
                this.builder.withFade(fadeColors);
            }
        } else if (split[0].equalsIgnoreCase("effect") || allowShortName && split[0].equalsIgnoreCase("e")) {
            String[] effects;
            for (String effect : effects = split[1].split(",")) {
                if (effect.equalsIgnoreCase("twinkle")) {
                    this.builder.flicker(true);
                    continue;
                }
                if (effect.equalsIgnoreCase("trail")) {
                    this.builder.trail(true);
                    continue;
                }
                throw new Exception(I18n.tl("invalidFireworkFormat", split[1], split[0]));
            }
        }
    }

    public void addFireworkMeta(CommandSource sender, boolean allowShortName, String string, IEssentials ess) throws Exception {
        if (MaterialUtil.isFirework(this.stack.getType())) {
            String[] split = splitPattern.split(string, 2);
            if (split.length < 2) {
                return;
            }
            if (split[0].equalsIgnoreCase("color") || split[0].equalsIgnoreCase("colour") || allowShortName && split[0].equalsIgnoreCase("c")) {
                String[] colors;
                if (this.validFirework) {
                    if (!this.hasMetaPermission(sender, "firework", true, true, ess)) {
                        throw new Exception(I18n.tl("noMetaFirework", new Object[0]));
                    }
                    FireworkEffect effect = this.builder.build();
                    FireworkMeta fmeta = (FireworkMeta)this.stack.getItemMeta();
                    fmeta.addEffect(effect);
                    if (fmeta.getEffects().size() > 1 && !this.hasMetaPermission(sender, "firework-multiple", true, true, ess)) {
                        throw new Exception(I18n.tl("multipleCharges", new Object[0]));
                    }
                    this.stack.setItemMeta((ItemMeta)fmeta);
                    this.builder = FireworkEffect.builder();
                }
                ArrayList<Color> primaryColors = new ArrayList<Color>();
                for (String color : colors = split[1].split(",")) {
                    if (colorMap.containsKey(color.toUpperCase())) {
                        this.validFirework = true;
                        primaryColors.add(colorMap.get(color.toUpperCase()).getFireworkColor());
                        continue;
                    }
                    if (hexPattern.matcher(color).matches()) {
                        this.validFirework = true;
                        primaryColors.add(Color.fromRGB((int)Integer.decode(color)));
                        continue;
                    }
                    throw new Exception(I18n.tl("invalidFireworkFormat", split[1], split[0]));
                }
                this.builder.withColor(primaryColors);
            } else if (split[0].equalsIgnoreCase("shape") || split[0].equalsIgnoreCase("type") || allowShortName && (split[0].equalsIgnoreCase("s") || split[0].equalsIgnoreCase("t"))) {
                FireworkEffect.Type finalEffect = null;
                String string2 = split[1] = split[1].equalsIgnoreCase("large") ? "BALL_LARGE" : split[1];
                if (!fireworkShape.containsKey(split[1].toUpperCase())) {
                    throw new Exception(I18n.tl("invalidFireworkFormat", split[1], split[0]));
                }
                finalEffect = fireworkShape.get(split[1].toUpperCase());
                if (finalEffect != null) {
                    this.builder.with(finalEffect);
                }
            } else if (split[0].equalsIgnoreCase("fade") || allowShortName && split[0].equalsIgnoreCase("f")) {
                String[] colors;
                ArrayList<Color> fadeColors = new ArrayList<Color>();
                for (String color : colors = split[1].split(",")) {
                    if (colorMap.containsKey(color.toUpperCase())) {
                        fadeColors.add(colorMap.get(color.toUpperCase()).getFireworkColor());
                        continue;
                    }
                    if (hexPattern.matcher(color).matches()) {
                        fadeColors.add(Color.fromRGB((int)Integer.decode(color)));
                        continue;
                    }
                    throw new Exception(I18n.tl("invalidFireworkFormat", split[1], split[0]));
                }
                if (!fadeColors.isEmpty()) {
                    this.builder.withFade(fadeColors);
                }
            } else if (split[0].equalsIgnoreCase("effect") || allowShortName && split[0].equalsIgnoreCase("e")) {
                String[] effects;
                for (String effect : effects = split[1].split(",")) {
                    if (effect.equalsIgnoreCase("twinkle")) {
                        this.builder.flicker(true);
                        continue;
                    }
                    if (effect.equalsIgnoreCase("trail")) {
                        this.builder.trail(true);
                        continue;
                    }
                    throw new Exception(I18n.tl("invalidFireworkFormat", split[1], split[0]));
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addPotionMeta(CommandSource sender, boolean allowShortName, String string, IEssentials ess) throws Exception {
        if (!MaterialUtil.isPotion(this.stack.getType())) return;
        String[] split = splitPattern.split(string, 2);
        if (split.length < 2) {
            return;
        }
        if (split[0].equalsIgnoreCase("effect") || allowShortName && split[0].equalsIgnoreCase("e")) {
            this.pEffectType = Potions.getByName(split[1]);
            if (this.pEffectType == null || this.pEffectType.getName() == null) throw new Exception(I18n.tl("invalidPotionMeta", split[1]));
            if (!this.hasMetaPermission(sender, "potions." + this.pEffectType.getName().toLowerCase(Locale.ENGLISH), true, false, ess)) throw new Exception(I18n.tl("noPotionEffectPerm", this.pEffectType.getName().toLowerCase(Locale.ENGLISH)));
            this.validPotionEffect = true;
        } else if (split[0].equalsIgnoreCase("power") || allowShortName && split[0].equalsIgnoreCase("p")) {
            if (!NumberUtil.isInt(split[1])) throw new Exception(I18n.tl("invalidPotionMeta", split[1]));
            this.validPotionPower = true;
            this.power = Integer.parseInt(split[1]);
            if (this.power > 0 && this.power < 4) {
                --this.power;
            }
        } else if (split[0].equalsIgnoreCase("amplifier") || allowShortName && split[0].equalsIgnoreCase("a")) {
            if (!NumberUtil.isInt(split[1])) throw new Exception(I18n.tl("invalidPotionMeta", split[1]));
            this.validPotionPower = true;
            this.power = Integer.parseInt(split[1]);
        } else if (split[0].equalsIgnoreCase("duration") || allowShortName && split[0].equalsIgnoreCase("d")) {
            if (!NumberUtil.isInt(split[1])) throw new Exception(I18n.tl("invalidPotionMeta", split[1]));
            this.validPotionDuration = true;
            this.duration = Integer.parseInt(split[1]) * 20;
        } else if (split[0].equalsIgnoreCase("splash") || allowShortName && split[0].equalsIgnoreCase("s")) {
            this.isSplashPotion = Boolean.parseBoolean(split[1]);
        }
        if (!this.isValidPotion()) return;
        PotionMeta pmeta = (PotionMeta)this.stack.getItemMeta();
        this.pEffect = this.pEffectType.createEffect(this.duration, this.power);
        if (pmeta.getCustomEffects().size() > 1 && !this.hasMetaPermission(sender, "potions.multiple", true, false, ess)) {
            throw new Exception(I18n.tl("multiplePotionEffects", new Object[0]));
        }
        pmeta.addCustomEffect(this.pEffect, true);
        this.stack.setItemMeta((ItemMeta)pmeta);
        if (VersionUtil.getServerBukkitVersion().isHigherThanOrEqualTo(VersionUtil.v1_9_R01)) {
            if (this.isSplashPotion && this.stack.getType() != Material.SPLASH_POTION) {
                this.stack.setType(Material.SPLASH_POTION);
            } else if (!this.isSplashPotion && this.stack.getType() != Material.POTION) {
                this.stack.setType(Material.POTION);
            }
        } else {
            Potion potion = Potion.fromDamage((int)this.stack.getDurability());
            potion.setSplash(this.isSplashPotion);
            potion.apply(this.stack);
        }
        this.resetPotionMeta();
    }

    private boolean parseEnchantmentStrings(CommandSource sender, boolean allowUnsafe, String[] split, IEssentials ess) throws Exception {
        Enchantment enchantment = Enchantments.getByName(split[0]);
        if (enchantment == null) {
            return false;
        }
        if (this.hasMetaPermission(sender, "enchantments." + enchantment.getName().toLowerCase(Locale.ENGLISH), false, false, ess)) {
            int level = -1;
            if (split.length > 1) {
                try {
                    level = Integer.parseInt(split[1]);
                }
                catch (NumberFormatException ex) {
                    level = -1;
                }
            }
            if (level < 0 || !allowUnsafe && level > enchantment.getMaxLevel()) {
                level = enchantment.getMaxLevel();
            }
            this.addEnchantment(sender, allowUnsafe, enchantment, level);
        }
        return true;
    }

    public void addEnchantment(CommandSource sender, boolean allowUnsafe, Enchantment enchantment, int level) throws Exception {
        if (enchantment == null) {
            throw new Exception(I18n.tl("enchantmentNotFound", new Object[0]));
        }
        try {
            if (this.stack.getType().equals((Object)Material.ENCHANTED_BOOK)) {
                EnchantmentStorageMeta meta = (EnchantmentStorageMeta)this.stack.getItemMeta();
                if (level == 0) {
                    meta.removeStoredEnchant(enchantment);
                } else {
                    meta.addStoredEnchant(enchantment, level, allowUnsafe);
                }
                this.stack.setItemMeta((ItemMeta)meta);
            } else if (level == 0) {
                this.stack.removeEnchantment(enchantment);
            } else if (allowUnsafe) {
                this.stack.addUnsafeEnchantment(enchantment, level);
            } else {
                this.stack.addEnchantment(enchantment, level);
            }
        }
        catch (Exception ex) {
            throw new Exception("Enchantment " + enchantment.getName() + ": " + ex.getMessage(), ex);
        }
    }

    public Enchantment getEnchantment(User user, String name) throws Exception {
        Enchantment enchantment = Enchantments.getByName(name);
        if (enchantment == null) {
            return null;
        }
        String enchantmentName = enchantment.getName().toLowerCase(Locale.ENGLISH);
        if (!this.hasMetaPermission(user, "enchantments." + enchantmentName, true, false)) {
            throw new Exception(I18n.tl("enchantmentPerm", enchantmentName));
        }
        return enchantment;
    }

    public void addBannerMeta(CommandSource sender, boolean allowShortName, String string, IEssentials ess) throws Exception {
        if (MaterialUtil.isBanner(this.stack.getType()) && !this.stack.getType().toString().equals("SHIELD") && string != null) {
            String[] split = splitPattern.split(string, 2);
            if (split.length < 2) {
                throw new Exception(I18n.tl("invalidBanner", split[1]));
            }
            PatternType patternType = null;
            try {
                patternType = PatternType.valueOf((String)split[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            BannerMeta meta = (BannerMeta)this.stack.getItemMeta();
            if (split[0].equalsIgnoreCase("basecolor")) {
                Color color = Color.fromRGB((int)Integer.parseInt(split[1]));
                meta.setBaseColor(DyeColor.getByColor((Color)color));
            } else if (patternType != null) {
                PatternType type = PatternType.valueOf((String)split[0]);
                DyeColor color = DyeColor.getByColor((Color)Color.fromRGB((int)Integer.parseInt(split[1])));
                Pattern pattern = new Pattern(color, type);
                meta.addPattern(pattern);
            }
            this.stack.setItemMeta((ItemMeta)meta);
        } else if (this.stack.getType().toString().equals("SHIELD") && string != null) {
            String[] split = splitPattern.split(string, 2);
            if (split.length < 2) {
                throw new Exception(I18n.tl("invalidBanner", split[1]));
            }
            PatternType patternType = null;
            try {
                patternType = PatternType.valueOf((String)split[0]);
            }
            catch (Exception meta) {
                // empty catch block
            }
            BlockStateMeta meta = (BlockStateMeta)this.stack.getItemMeta();
            Banner banner = (Banner)meta.getBlockState();
            if (split[0].equalsIgnoreCase("basecolor")) {
                Color color = Color.fromRGB((int)Integer.parseInt(split[1]));
                banner.setBaseColor(DyeColor.getByColor((Color)color));
            } else if (patternType != null) {
                PatternType type = PatternType.valueOf((String)split[0]);
                DyeColor color = DyeColor.getByColor((Color)Color.fromRGB((int)Integer.parseInt(split[1])));
                Pattern pattern = new Pattern(color, type);
                banner.addPattern(pattern);
            }
            banner.update();
            meta.setBlockState((BlockState)banner);
            this.stack.setItemMeta((ItemMeta)meta);
        }
    }

    private boolean hasMetaPermission(CommandSource sender, String metaPerm, boolean graceful, boolean includeBase, IEssentials ess) throws Exception {
        User user = sender != null && sender.isPlayer() ? ess.getUser(sender.getPlayer()) : null;
        return this.hasMetaPermission(user, metaPerm, graceful, includeBase);
    }

    private boolean hasMetaPermission(User user, String metaPerm, boolean graceful, boolean includeBase) throws Exception {
        String permBase;
        String string = permBase = includeBase ? "essentials.itemspawn.meta-" : "essentials.";
        if (user == null || user.isAuthorized(permBase + metaPerm)) {
            return true;
        }
        if (graceful) {
            return false;
        }
        throw new Exception(I18n.tl("noMetaPerm", metaPerm));
    }

    private void setUnbreakable(IEssentials ess, ItemStack is, boolean unbreakable) {
        ItemMeta meta = is.getItemMeta();
        ess.getItemUnbreakableProvider().setUnbreakable(meta, unbreakable);
        is.setItemMeta(meta);
    }

    static {
        for (DyeColor dyeColor : DyeColor.values()) {
            colorMap.put(dyeColor.name(), dyeColor);
        }
        for (DyeColor dyeColor : FireworkEffect.Type.values()) {
            fireworkShape.put(dyeColor.name(), (FireworkEffect.Type)dyeColor);
        }
        splitPattern = java.util.regex.Pattern.compile("[:+',;.]");
        hexPattern = java.util.regex.Pattern.compile("#([0-9a-fA-F]{6})");
    }
}

