/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.ITarget;
import com.earth2me.essentials.Teleport;
import com.earth2me.essentials.Trade;
import com.earth2me.essentials.User;
import java.util.UUID;
import net.ess3.api.IEssentials;
import net.ess3.api.IUser;
import org.bukkit.Location;
import org.bukkit.event.player.PlayerTeleportEvent;

@Deprecated
public class TimedTeleport
implements Runnable {
    private static final double MOVE_CONSTANT = 0.3;
    private final IUser teleportOwner;
    private final IEssentials ess;
    private final Teleport teleport;
    private final UUID timer_teleportee;
    private final long timer_started;
    private final long timer_delay;
    private final long timer_initX;
    private final long timer_initY;
    private final long timer_initZ;
    private final ITarget timer_teleportTarget;
    private final boolean timer_respawn;
    private final boolean timer_canMove;
    private final Trade timer_chargeFor;
    private final PlayerTeleportEvent.TeleportCause timer_cause;
    private int timer_task;
    private double timer_health;

    TimedTeleport(IUser user, IEssentials ess, Teleport teleport, long delay, IUser teleportUser, ITarget target, Trade chargeFor, PlayerTeleportEvent.TeleportCause cause, boolean respawn) {
        this.teleportOwner = user;
        this.ess = ess;
        this.teleport = teleport;
        this.timer_started = System.currentTimeMillis();
        this.timer_delay = delay;
        this.timer_health = teleportUser.getBase().getHealth();
        this.timer_initX = Math.round(teleportUser.getBase().getLocation().getX() * 0.3);
        this.timer_initY = Math.round(teleportUser.getBase().getLocation().getY() * 0.3);
        this.timer_initZ = Math.round(teleportUser.getBase().getLocation().getZ() * 0.3);
        this.timer_teleportee = teleportUser.getBase().getUniqueId();
        this.timer_teleportTarget = target;
        this.timer_chargeFor = chargeFor;
        this.timer_cause = cause;
        this.timer_respawn = respawn;
        this.timer_canMove = user.isAuthorized("essentials.teleport.timer.move");
        this.timer_task = ess.runTaskTimerAsynchronously(this, 20L, 20L).getTaskId();
    }

    @Override
    public void run() {
        if (this.teleportOwner == null || !this.teleportOwner.getBase().isOnline() || this.teleportOwner.getBase().getLocation() == null) {
            this.cancelTimer(false);
            return;
        }
        final User teleportUser = this.ess.getUser(this.timer_teleportee);
        if (teleportUser == null || !teleportUser.getBase().isOnline()) {
            this.cancelTimer(false);
            return;
        }
        Location currLocation = teleportUser.getBase().getLocation();
        if (currLocation == null) {
            this.cancelTimer(false);
            return;
        }
        if (!this.timer_canMove && (Math.round(currLocation.getX() * 0.3) != this.timer_initX || Math.round(currLocation.getY() * 0.3) != this.timer_initY || Math.round(currLocation.getZ() * 0.3) != this.timer_initZ || teleportUser.getBase().getHealth() < this.timer_health)) {
            this.cancelTimer(true);
            return;
        }
        class DelayedTeleportTask
        implements Runnable {
            DelayedTeleportTask() {
            }

            @Override
            public void run() {
                TimedTeleport.this.timer_health = teleportUser.getBase().getHealth();
                long now = System.currentTimeMillis();
                if (now > TimedTeleport.this.timer_started + TimedTeleport.this.timer_delay) {
                    block9: {
                        try {
                            TimedTeleport.this.teleport.cooldown(false);
                        }
                        catch (Exception ex) {
                            TimedTeleport.this.teleportOwner.sendMessage(I18n.tl("cooldownWithMessage", ex.getMessage()));
                            if (TimedTeleport.this.teleportOwner == teleportUser) break block9;
                            teleportUser.sendMessage(I18n.tl("cooldownWithMessage", ex.getMessage()));
                        }
                    }
                    try {
                        TimedTeleport.this.cancelTimer(false);
                        teleportUser.sendMessage(I18n.tl("teleportationCommencing", new Object[0]));
                        if (TimedTeleport.this.timer_chargeFor != null) {
                            TimedTeleport.this.timer_chargeFor.isAffordableFor(TimedTeleport.this.teleportOwner);
                        }
                        if (TimedTeleport.this.timer_respawn) {
                            TimedTeleport.this.teleport.respawnNow(teleportUser, TimedTeleport.this.timer_cause);
                        } else {
                            TimedTeleport.this.teleport.now(teleportUser, TimedTeleport.this.timer_teleportTarget, TimedTeleport.this.timer_cause);
                        }
                        if (TimedTeleport.this.timer_chargeFor != null) {
                            TimedTeleport.this.timer_chargeFor.charge(TimedTeleport.this.teleportOwner);
                        }
                    }
                    catch (Exception ex) {
                        TimedTeleport.this.ess.showError(TimedTeleport.this.teleportOwner.getSource(), ex, "\\ teleport");
                    }
                }
            }
        }
        this.ess.scheduleSyncDelayedTask(new DelayedTeleportTask());
    }

    void cancelTimer(boolean notifyUser) {
        if (this.timer_task == -1) {
            return;
        }
        try {
            this.ess.getServer().getScheduler().cancelTask(this.timer_task);
            if (notifyUser) {
                this.teleportOwner.sendMessage(I18n.tl("pendingTeleportCancelled", new Object[0]));
                if (this.timer_teleportee != null && !this.timer_teleportee.equals(this.teleportOwner.getBase().getUniqueId())) {
                    this.ess.getUser(this.timer_teleportee).sendMessage(I18n.tl("pendingTeleportCancelled", new Object[0]));
                }
            }
        }
        finally {
            this.timer_task = -1;
        }
    }
}

