/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.regex.Pattern;
import net.ess3.api.IEssentials;
import org.bukkit.Bukkit;

public class UUIDMap {
    private static final ScheduledExecutorService writeScheduler = Executors.newScheduledThreadPool(1);
    private static boolean pendingWrite;
    private static boolean loading;
    private final transient IEssentials ess;
    private final File userList;
    private final transient Pattern splitPattern = Pattern.compile(",");
    private final Runnable writeTaskRunnable;

    public UUIDMap(IEssentials ess) {
        this.ess = ess;
        this.userList = new File(ess.getDataFolder(), "usermap.csv");
        pendingWrite = false;
        this.writeTaskRunnable = () -> {
            if (pendingWrite) {
                try {
                    new WriteRunner(ess.getDataFolder(), this.userList, ess.getUserMap().getNames()).run();
                }
                catch (Throwable t2) {
                    t2.printStackTrace();
                }
            }
        };
        writeScheduler.scheduleWithFixedDelay(this.writeTaskRunnable, 5L, 5L, TimeUnit.SECONDS);
    }

    public void loadAllUsers(ConcurrentSkipListMap<String, UUID> names, ConcurrentSkipListMap<UUID, ArrayList<String>> history) {
        try {
            if (!this.userList.exists()) {
                this.userList.createNewFile();
            }
            if (this.ess.getSettings().isDebug()) {
                this.ess.getLogger().log(Level.INFO, "Reading usermap from disk");
            }
            if (loading) {
                return;
            }
            names.clear();
            history.clear();
            loading = true;
            try (BufferedReader reader = new BufferedReader(new FileReader(this.userList));){
                String line;
                while ((line = reader.readLine()) != null) {
                    ArrayList<Object> list;
                    String[] values = this.splitPattern.split(line);
                    if (values.length != 2) continue;
                    String name = values[0];
                    UUID uuid = UUID.fromString(values[1]);
                    names.put(name, uuid);
                    if (!history.containsKey(uuid)) {
                        list = new ArrayList<String>();
                        list.add(name);
                        history.put(uuid, list);
                        continue;
                    }
                    list = history.get(uuid);
                    if (list.contains(name)) continue;
                    list.add(name);
                }
            }
            loading = false;
        }
        catch (IOException ex) {
            Bukkit.getLogger().log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public void writeUUIDMap() {
        pendingWrite = true;
    }

    public void forceWriteUUIDMap() {
        if (this.ess.getSettings().isDebug()) {
            this.ess.getLogger().log(Level.INFO, "Forcing usermap write to disk");
        }
        pendingWrite = true;
        this.writeTaskRunnable.run();
    }

    public void shutdown() {
        writeScheduler.submit(this.writeTaskRunnable);
        writeScheduler.shutdown();
    }

    static {
        loading = false;
    }

    private static final class WriteRunner
    implements Runnable {
        private final File location;
        private final File endFile;
        private final Map<String, UUID> names;

        private WriteRunner(File location, File endFile, Map<String, UUID> names) {
            this.location = location;
            this.endFile = endFile;
            this.names = new HashMap<String, UUID>(names);
        }

        @Override
        public void run() {
            pendingWrite = false;
            if (loading || this.names.isEmpty()) {
                return;
            }
            File configFile = null;
            try {
                configFile = File.createTempFile("usermap", ".tmp.csv", this.location);
                BufferedWriter bWriter = new BufferedWriter(new FileWriter(configFile));
                for (Map.Entry<String, UUID> entry : this.names.entrySet()) {
                    bWriter.write(entry.getKey() + "," + entry.getValue().toString());
                    bWriter.newLine();
                }
                bWriter.close();
                Files.move((File)configFile, (File)this.endFile);
            }
            catch (IOException ex) {
                try {
                    if (configFile != null && configFile.exists()) {
                        Files.move((File)configFile, (File)new File(this.endFile.getParentFile(), "usermap.bak.csv"));
                    }
                }
                catch (Exception ex2) {
                    Bukkit.getLogger().log(Level.SEVERE, ex2.getMessage(), ex2);
                }
                Bukkit.getLogger().log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }
}

