/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.AsyncTeleport;
import com.earth2me.essentials.ChargeException;
import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.Console;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.ISettings;
import com.earth2me.essentials.IUser;
import com.earth2me.essentials.OfflinePlayer;
import com.earth2me.essentials.Teleport;
import com.earth2me.essentials.Trade;
import com.earth2me.essentials.UserData;
import com.earth2me.essentials.commands.IEssentialsCommand;
import com.earth2me.essentials.economy.EconomyLayer;
import com.earth2me.essentials.economy.EconomyLayers;
import com.earth2me.essentials.libs.checkerframework.checker.nullness.qual.Nullable;
import com.earth2me.essentials.messaging.IMessageRecipient;
import com.earth2me.essentials.messaging.SimpleMessageRecipient;
import com.earth2me.essentials.utils.DateUtil;
import com.earth2me.essentials.utils.EnumUtil;
import com.earth2me.essentials.utils.FormatUtil;
import com.earth2me.essentials.utils.NumberUtil;
import com.earth2me.essentials.utils.TriState;
import com.earth2me.essentials.utils.VersionUtil;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.ess3.api.IEssentials;
import net.ess3.api.IUser;
import net.ess3.api.MaxMoneyException;
import net.ess3.api.events.AfkStatusChangeEvent;
import net.ess3.api.events.JailStatusChangeEvent;
import net.ess3.api.events.MuteStatusChangeEvent;
import net.ess3.api.events.UserBalanceUpdateEvent;
import net.essentialsx.api.v2.events.TransactionEvent;
import net.essentialsx.api.v2.services.mail.MailSender;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Statistic;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class User
extends UserData
implements Comparable<User>,
IMessageRecipient,
IUser {
    private static final Statistic PLAY_ONE_TICK = EnumUtil.getStatistic("PLAY_ONE_MINUTE", "PLAY_ONE_TICK");
    private static final Logger logger = Logger.getLogger("Essentials");
    private final IMessageRecipient messageRecipient;
    private final transient AsyncTeleport teleport;
    private final transient Teleport legacyTeleport;
    private final Map<User, BigDecimal> confirmingPayments = new WeakHashMap<User, BigDecimal>();
    private final transient LinkedHashMap<String, IUser.TpaRequest> teleportRequestQueue = new LinkedHashMap();
    private transient boolean vanished;
    private boolean hidden = false;
    private boolean rightClickJump = false;
    private boolean invSee = false;
    private boolean recipeSee = false;
    private boolean enderSee = false;
    private boolean ignoreMsg = false;
    private String afkMessage;
    private long afkSince;
    private transient Location afkPosition = null;
    private transient long lastOnlineActivity;
    private transient long lastThrottledAction;
    private transient long lastActivity = System.currentTimeMillis();
    private transient long teleportInvulnerabilityTimestamp = 0L;
    private String confirmingClearCommand;
    private long lastNotifiedAboutMailsMs;
    private String lastHomeConfirmation;
    private long lastHomeConfirmationTimestamp;
    private boolean toggleShout = false;
    private final transient List<String> signCopy = Lists.newArrayList((Object[])new String[]{"", "", "", ""});

    public User(Player base, IEssentials ess) {
        super(base, ess);
        this.teleport = new AsyncTeleport(this, ess);
        this.legacyTeleport = new Teleport(this, ess);
        if (this.isAfk()) {
            this.afkPosition = this.getLocation();
        }
        if (this.getBase().isOnline()) {
            this.lastOnlineActivity = System.currentTimeMillis();
        }
        this.messageRecipient = new SimpleMessageRecipient(ess, this);
    }

    void update(Player base) {
        this.setBase(base);
    }

    @Override
    public boolean isAuthorized(IEssentialsCommand cmd) {
        return this.isAuthorized(cmd, "essentials.");
    }

    @Override
    public boolean isAuthorized(IEssentialsCommand cmd, String permissionPrefix) {
        return this.isAuthorized(permissionPrefix + (cmd.getName().equals("r") ? "msg" : cmd.getName()));
    }

    @Override
    public boolean isAuthorized(String node) {
        boolean result = this.isAuthorizedCheck(node);
        if (this.ess.getSettings().isDebug()) {
            this.ess.getLogger().log(Level.INFO, "checking if " + this.base.getName() + " has " + node + " - " + result);
        }
        return result;
    }

    @Override
    public boolean isPermissionSet(String node) {
        boolean result = this.isPermSetCheck(node);
        if (this.ess.getSettings().isDebug()) {
            this.ess.getLogger().log(Level.INFO, "checking if " + this.base.getName() + " has " + node + " (set-explicit) - " + result);
        }
        return result;
    }

    public TriState isAuthorizedExact(String node) {
        return this.isAuthorizedExactCheck(node);
    }

    private boolean isAuthorizedCheck(String node) {
        if (this.base instanceof OfflinePlayer) {
            return false;
        }
        try {
            return this.ess.getPermissionsHandler().hasPermission(this.base, node);
        }
        catch (Exception ex) {
            if (this.ess.getSettings().isDebug()) {
                this.ess.getLogger().log(Level.SEVERE, "Permission System Error: " + this.ess.getPermissionsHandler().getName() + " returned: " + ex.getMessage(), ex);
            } else {
                this.ess.getLogger().log(Level.SEVERE, "Permission System Error: " + this.ess.getPermissionsHandler().getName() + " returned: " + ex.getMessage());
            }
            return false;
        }
    }

    private boolean isPermSetCheck(String node) {
        if (this.base instanceof OfflinePlayer) {
            return false;
        }
        try {
            return this.ess.getPermissionsHandler().isPermissionSet(this.base, node);
        }
        catch (Exception ex) {
            if (this.ess.getSettings().isDebug()) {
                this.ess.getLogger().log(Level.SEVERE, "Permission System Error: " + this.ess.getPermissionsHandler().getName() + " returned: " + ex.getMessage(), ex);
            } else {
                this.ess.getLogger().log(Level.SEVERE, "Permission System Error: " + this.ess.getPermissionsHandler().getName() + " returned: " + ex.getMessage());
            }
            return false;
        }
    }

    private TriState isAuthorizedExactCheck(String node) {
        if (this.base instanceof OfflinePlayer) {
            return TriState.UNSET;
        }
        try {
            return this.ess.getPermissionsHandler().isPermissionSetExact(this.base, node);
        }
        catch (Exception ex) {
            if (this.ess.getSettings().isDebug()) {
                this.ess.getLogger().log(Level.SEVERE, "Permission System Error: " + this.ess.getPermissionsHandler().getName() + " returned: " + ex.getMessage(), ex);
            } else {
                this.ess.getLogger().log(Level.SEVERE, "Permission System Error: " + this.ess.getPermissionsHandler().getName() + " returned: " + ex.getMessage());
            }
            return TriState.UNSET;
        }
    }

    @Override
    public void healCooldown() throws Exception {
        GregorianCalendar now = new GregorianCalendar();
        if (this.getLastHealTimestamp() > 0L) {
            double cooldown = this.ess.getSettings().getHealCooldown();
            GregorianCalendar cooldownTime = new GregorianCalendar();
            cooldownTime.setTimeInMillis(this.getLastHealTimestamp());
            ((Calendar)cooldownTime).add(13, (int)cooldown);
            ((Calendar)cooldownTime).add(14, (int)(cooldown * 1000.0 % 1000.0));
            if (cooldownTime.after(now) && !this.isAuthorized("essentials.heal.cooldown.bypass")) {
                throw new Exception(I18n.tl("timeBeforeHeal", DateUtil.formatDateDiff(cooldownTime.getTimeInMillis())));
            }
        }
        this.setLastHealTimestamp(now.getTimeInMillis());
    }

    @Override
    public void giveMoney(BigDecimal value) throws MaxMoneyException {
        this.giveMoney(value, null);
    }

    @Override
    public void giveMoney(BigDecimal value, CommandSource initiator) throws MaxMoneyException {
        this.giveMoney(value, initiator, UserBalanceUpdateEvent.Cause.UNKNOWN);
    }

    public void giveMoney(BigDecimal value, CommandSource initiator, UserBalanceUpdateEvent.Cause cause) throws MaxMoneyException {
        if (value.signum() == 0) {
            return;
        }
        this.setMoney(this.getMoney().add(value), cause);
        this.sendMessage(I18n.tl("addedToAccount", NumberUtil.displayCurrency(value, this.ess)));
        if (initiator != null) {
            initiator.sendMessage(I18n.tl("addedToOthersAccount", NumberUtil.displayCurrency(value, this.ess), this.getDisplayName(), NumberUtil.displayCurrency(this.getMoney(), this.ess)));
        }
    }

    @Override
    public void payUser(User reciever, BigDecimal value) throws Exception {
        this.payUser(reciever, value, UserBalanceUpdateEvent.Cause.UNKNOWN);
    }

    public void payUser(User reciever, BigDecimal value, UserBalanceUpdateEvent.Cause cause) throws Exception {
        if (value.compareTo(BigDecimal.ZERO) < 1) {
            throw new Exception(I18n.tl("payMustBePositive", new Object[0]));
        }
        if (!this.canAfford(value)) {
            throw new ChargeException(I18n.tl("notEnoughMoney", NumberUtil.displayCurrency(value, this.ess)));
        }
        this.setMoney(this.getMoney().subtract(value), cause);
        reciever.setMoney(reciever.getMoney().add(value), cause);
        this.sendMessage(I18n.tl("moneySentTo", NumberUtil.displayCurrency(value, this.ess), reciever.getDisplayName()));
        reciever.sendMessage(I18n.tl("moneyRecievedFrom", NumberUtil.displayCurrency(value, this.ess), this.getDisplayName()));
        TransactionEvent transactionEvent = new TransactionEvent(this.getSource(), reciever, value);
        this.ess.getServer().getPluginManager().callEvent((Event)transactionEvent);
    }

    @Override
    public void takeMoney(BigDecimal value) {
        this.takeMoney(value, null);
    }

    @Override
    public void takeMoney(BigDecimal value, CommandSource initiator) {
        this.takeMoney(value, initiator, UserBalanceUpdateEvent.Cause.UNKNOWN);
    }

    public void takeMoney(BigDecimal value, CommandSource initiator, UserBalanceUpdateEvent.Cause cause) {
        if (value.signum() == 0) {
            return;
        }
        try {
            this.setMoney(this.getMoney().subtract(value), cause);
        }
        catch (MaxMoneyException ex) {
            this.ess.getLogger().log(Level.WARNING, "Invalid call to takeMoney, total balance can't be more than the max-money limit.", ex);
        }
        this.sendMessage(I18n.tl("takenFromAccount", NumberUtil.displayCurrency(value, this.ess)));
        if (initiator != null) {
            initiator.sendMessage(I18n.tl("takenFromOthersAccount", NumberUtil.displayCurrency(value, this.ess), this.getDisplayName(), NumberUtil.displayCurrency(this.getMoney(), this.ess)));
        }
    }

    @Override
    public boolean canAfford(BigDecimal cost) {
        return this.canAfford(cost, true);
    }

    public boolean canAfford(BigDecimal cost, boolean permcheck) {
        if (cost.signum() <= 0) {
            return true;
        }
        BigDecimal remainingBalance = this.getMoney().subtract(cost);
        if (!permcheck || this.isAuthorized("essentials.eco.loan")) {
            return remainingBalance.compareTo(this.ess.getSettings().getMinMoney()) >= 0;
        }
        return remainingBalance.signum() >= 0;
    }

    public void dispose() {
        this.ess.runTaskAsynchronously(this::_dispose);
    }

    private void _dispose() {
        if (!this.base.isOnline()) {
            this.base = new OfflinePlayer(this.getConfigUUID(), this.ess.getServer());
        }
        this.cleanup();
    }

    @Override
    public Boolean canSpawnItem(Material material) {
        if (this.ess.getSettings().permissionBasedItemSpawn()) {
            String name = material.toString().toLowerCase(Locale.ENGLISH).replace("_", "");
            if (this.isAuthorized("essentials.itemspawn.item-all") || this.isAuthorized("essentials.itemspawn.item-" + name)) {
                return true;
            }
            if (VersionUtil.getServerBukkitVersion().isLowerThan(VersionUtil.v1_13_0_R01)) {
                int id = material.getId();
                if (this.isAuthorized("essentials.itemspawn.item-" + id)) {
                    return true;
                }
            }
            return false;
        }
        return this.isAuthorized("essentials.itemspawn.exempt") || !this.ess.getSettings().itemSpawnBlacklist().contains(material);
    }

    @Override
    public void setLastLocation() {
        this.setLastLocation(this.getLocation());
    }

    @Override
    public void setLogoutLocation() {
        this.setLogoutLocation(this.getLocation());
    }

    @Override
    public void requestTeleport(User player, boolean here) {
        IUser.TpaRequest request = this.teleportRequestQueue.getOrDefault(player.getName(), new IUser.TpaRequest(player.getName(), player.getUUID()));
        request.setTime(System.currentTimeMillis());
        request.setHere(here);
        request.setLocation(here ? player.getLocation() : this.getLocation());
        this.teleportRequestQueue.remove(request.getName());
        if (this.teleportRequestQueue.size() >= this.ess.getSettings().getTpaMaxRequests()) {
            String lastKey = null;
            for (Map.Entry<String, IUser.TpaRequest> entry : this.teleportRequestQueue.entrySet()) {
                lastKey = entry.getKey();
            }
            this.teleportRequestQueue.remove(lastKey);
        }
        this.teleportRequestQueue.put(request.getName(), request);
    }

    @Override
    @Deprecated
    public boolean hasOutstandingTeleportRequest() {
        return this.getNextTpaRequest(false, false, false) != null;
    }

    public Collection<String> getPendingTpaKeys() {
        return this.teleportRequestQueue.keySet();
    }

    @Override
    public boolean hasPendingTpaRequests(boolean inform, boolean excludeHere) {
        return this.getNextTpaRequest(inform, false, excludeHere) != null;
    }

    public boolean hasOutstandingTpaRequest(String playerUsername, boolean here) {
        IUser.TpaRequest request = this.getOutstandingTpaRequest(playerUsername, false);
        return request != null && request.isHere() == here;
    }

    public @Nullable IUser.TpaRequest getOutstandingTpaRequest(String playerUsername, boolean inform) {
        if (!this.teleportRequestQueue.containsKey(playerUsername)) {
            return null;
        }
        long timeout = this.ess.getSettings().getTpaAcceptCancellation();
        IUser.TpaRequest request = this.teleportRequestQueue.get(playerUsername);
        if (timeout < 1L || System.currentTimeMillis() - request.getTime() <= timeout * 1000L) {
            return request;
        }
        this.teleportRequestQueue.remove(playerUsername);
        if (inform) {
            this.sendMessage(I18n.tl("requestTimedOutFrom", this.ess.getUser(request.getRequesterUuid()).getDisplayName()));
        }
        return null;
    }

    public IUser.TpaRequest removeTpaRequest(String playerUsername) {
        return (IUser.TpaRequest)this.teleportRequestQueue.remove(playerUsername);
    }

    @Override
    public IUser.TpaRequest getNextTpaRequest(boolean inform, boolean performExpirations, boolean excludeHere) {
        if (this.teleportRequestQueue.isEmpty()) {
            return null;
        }
        long timeout = this.ess.getSettings().getTpaAcceptCancellation();
        Iterator<Map.Entry<String, IUser.TpaRequest>> iterator = this.teleportRequestQueue.entrySet().iterator();
        IUser.TpaRequest nextRequest = null;
        while (iterator.hasNext()) {
            IUser.TpaRequest request = iterator.next().getValue();
            if (timeout < 1L || System.currentTimeMillis() - request.getTime() <= TimeUnit.SECONDS.toMillis(timeout)) {
                if (excludeHere && request.isHere()) continue;
                if (performExpirations) {
                    return request;
                }
                if (nextRequest != null) continue;
                nextRequest = request;
                continue;
            }
            if (inform) {
                this.sendMessage(I18n.tl("requestTimedOutFrom", this.ess.getUser(request.getRequesterUuid()).getDisplayName()));
            }
            iterator.remove();
        }
        return nextRequest;
    }

    public String getNick() {
        return this.getNick(true, true);
    }

    public String getNick(boolean longnick) {
        return this.getNick(true, true);
    }

    public String getNick(boolean longnick, boolean withPrefix, boolean withSuffix) {
        return this.getNick(withPrefix, withSuffix);
    }

    public String getNick(boolean withPrefix, boolean withSuffix) {
        String strPrefix;
        String output;
        String nickname;
        String suffix;
        StringBuilder prefix;
        block12: {
            prefix = new StringBuilder();
            suffix = "";
            String nick = this.getNickname();
            if (this.ess.getSettings().isCommandDisabled("nick") || nick == null || nick.isEmpty() || nick.equals(this.getName())) {
                nickname = this.getName();
            } else if (nick.equalsIgnoreCase(this.getName())) {
                nickname = nick;
            } else {
                nickname = FormatUtil.replaceFormat(this.ess.getSettings().getNicknamePrefix()) + nick;
                suffix = "\u00a7r";
            }
            if (this.getBase().isOp()) {
                try {
                    String opPrefix = this.ess.getSettings().getOperatorColor();
                    if (opPrefix != null && !opPrefix.isEmpty()) {
                        prefix.insert(0, opPrefix);
                        suffix = "\u00a7r";
                    }
                }
                catch (Exception e) {
                    if (!this.ess.getSettings().isDebug()) break block12;
                    e.printStackTrace();
                }
            }
        }
        if (this.ess.getSettings().addPrefixSuffix()) {
            if (withPrefix || !this.ess.getSettings().disablePrefix()) {
                String ptext = FormatUtil.replaceFormat(this.ess.getPermissionsHandler().getPrefix(this.base));
                prefix.insert(0, ptext);
                suffix = "\u00a7r";
            }
            if (withSuffix || !this.ess.getSettings().disableSuffix()) {
                String stext = FormatUtil.replaceFormat(this.ess.getPermissionsHandler().getSuffix(this.base));
                suffix = stext + "\u00a7r";
                suffix = suffix.replace("\u00a7f\u00a7r", "\u00a7r").replace("\u00a7r\u00a7r", "\u00a7r");
            }
        }
        if ((output = (strPrefix = prefix.toString()) + nickname + suffix).charAt(output.length() - 1) == '\u00a7') {
            output = output.substring(0, output.length() - 1);
        }
        return output;
    }

    public void setDisplayNick() {
        block6: {
            if (this.base.isOnline() && this.ess.getSettings().changeDisplayName()) {
                this.getBase().setDisplayName(this.getNick(true));
                if (this.isAfk()) {
                    this.updateAfkListName();
                } else if (this.ess.getSettings().changePlayerListName()) {
                    String name = this.getNick(this.ess.getSettings().isAddingPrefixInPlayerlist(), this.ess.getSettings().isAddingSuffixInPlayerlist());
                    try {
                        this.getBase().setPlayerListName(name);
                    }
                    catch (IllegalArgumentException e) {
                        if (!this.ess.getSettings().isDebug()) break block6;
                        logger.log(Level.INFO, "Playerlist for " + name + " was not updated. Name clashed with another online player.");
                    }
                }
            }
        }
    }

    @Override
    public String getDisplayName() {
        return super.getBase().getDisplayName() == null || this.ess.getSettings().hideDisplayNameInVanish() && this.isHidden() ? super.getBase().getName() : super.getBase().getDisplayName();
    }

    @Override
    public String getFormattedNickname() {
        String rawNickname = this.getNickname();
        if (rawNickname == null) {
            return null;
        }
        return FormatUtil.replaceFormat(this.ess.getSettings().getNicknamePrefix() + rawNickname);
    }

    @Override
    public AsyncTeleport getAsyncTeleport() {
        return this.teleport;
    }

    @Override
    @Deprecated
    public Teleport getTeleport() {
        return this.legacyTeleport;
    }

    public long getLastOnlineActivity() {
        return this.lastOnlineActivity;
    }

    public void setLastOnlineActivity(long timestamp) {
        this.lastOnlineActivity = timestamp;
    }

    @Override
    public BigDecimal getMoney() {
        long start = System.nanoTime();
        BigDecimal value = this._getMoney();
        long elapsed = System.nanoTime() - start;
        if (elapsed > this.ess.getSettings().getEconomyLagWarning()) {
            this.ess.getLogger().log(Level.INFO, "Lag Notice - Slow Economy Response - Request took over {0}ms!", (double)elapsed / 1000000.0);
        }
        return value;
    }

    @Override
    public void setMoney(BigDecimal value) throws MaxMoneyException {
        this.setMoney(value, UserBalanceUpdateEvent.Cause.UNKNOWN);
    }

    private BigDecimal _getMoney() {
        if (this.ess.getSettings().isEcoDisabled()) {
            if (this.ess.getSettings().isDebug()) {
                this.ess.getLogger().info("Internal economy functions disabled, aborting balance check.");
            }
            return BigDecimal.ZERO;
        }
        EconomyLayer layer = EconomyLayers.getSelectedLayer();
        if (layer != null && (layer.hasAccount((org.bukkit.OfflinePlayer)this.getBase()) || layer.createPlayerAccount((org.bukkit.OfflinePlayer)this.getBase()))) {
            return layer.getBalance((org.bukkit.OfflinePlayer)this.getBase());
        }
        return super.getMoney();
    }

    public void setMoney(BigDecimal value, UserBalanceUpdateEvent.Cause cause) throws MaxMoneyException {
        if (this.ess.getSettings().isEcoDisabled()) {
            if (this.ess.getSettings().isDebug()) {
                this.ess.getLogger().info("Internal economy functions disabled, aborting balance change.");
            }
            return;
        }
        BigDecimal oldBalance = this._getMoney();
        UserBalanceUpdateEvent updateEvent = new UserBalanceUpdateEvent(this.getBase(), oldBalance, value, cause);
        this.ess.getServer().getPluginManager().callEvent((Event)updateEvent);
        BigDecimal newBalance = updateEvent.getNewBalance();
        EconomyLayer layer = EconomyLayers.getSelectedLayer();
        if (layer != null && (layer.hasAccount((org.bukkit.OfflinePlayer)this.getBase()) || layer.createPlayerAccount((org.bukkit.OfflinePlayer)this.getBase()))) {
            layer.set((org.bukkit.OfflinePlayer)this.getBase(), newBalance);
        }
        super.setMoney(newBalance, true);
        Trade.log("Update", "Set", "API", this.getName(), new Trade(newBalance, this.ess), null, null, null, newBalance, this.ess);
    }

    public void updateMoneyCache(BigDecimal value) {
        if (this.ess.getSettings().isEcoDisabled() || !EconomyLayers.isLayerSelected() || super.getMoney().equals(value)) {
            return;
        }
        try {
            super.setMoney(value, false);
        }
        catch (MaxMoneyException maxMoneyException) {
            // empty catch block
        }
    }

    @Override
    public void setAfk(boolean set) {
        this.setAfk(set, AfkStatusChangeEvent.Cause.UNKNOWN);
    }

    @Override
    public void setAfk(boolean set, AfkStatusChangeEvent.Cause cause) {
        AfkStatusChangeEvent afkEvent = new AfkStatusChangeEvent((IUser)this, set, cause);
        this.ess.getServer().getPluginManager().callEvent((Event)afkEvent);
        if (afkEvent.isCancelled()) {
            return;
        }
        this.getBase().setSleepingIgnored(this.isAuthorized("essentials.sleepingignored") || set && this.ess.getSettings().sleepIgnoresAfkPlayers());
        if (set && !this.isAfk()) {
            this.afkPosition = this.getLocation();
            this.afkSince = System.currentTimeMillis();
        } else if (!set && this.isAfk()) {
            this.afkPosition = null;
            this.afkMessage = null;
            this.afkSince = 0L;
        }
        this._setAfk(set);
        this.updateAfkListName();
    }

    private void updateAfkListName() {
        if (this.ess.getSettings().isAfkListName()) {
            if (this.isAfk()) {
                String afkName = this.ess.getSettings().getAfkListName().replace("{PLAYER}", this.getDisplayName()).replace("{USERNAME}", this.getName());
                this.getBase().setPlayerListName(afkName);
            } else {
                this.getBase().setPlayerListName(null);
                this.setDisplayNick();
            }
        }
    }

    @Deprecated
    public boolean toggleAfk() {
        return this.toggleAfk(AfkStatusChangeEvent.Cause.UNKNOWN);
    }

    public boolean toggleAfk(AfkStatusChangeEvent.Cause cause) {
        this.setAfk(!this.isAfk(), cause);
        return this.isAfk();
    }

    @Override
    public boolean isHiddenFrom(Player player) {
        return !player.canSee(this.getBase());
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public void setHidden(boolean hidden) {
        this.hidden = hidden;
        if (hidden) {
            this.setLastLogout(this.getLastOnlineActivity());
        }
    }

    public boolean isHidden(Player player) {
        return this.hidden || !player.canSee(this.getBase());
    }

    @Override
    public String getFormattedJailTime() {
        return DateUtil.formatDateDiff(this.getOnlineJailedTime() > 0L ? this.getOnlineJailExpireTime() : this.getJailTimeout());
    }

    private long getOnlineJailExpireTime() {
        return (this.getOnlineJailedTime() - (long)this.getBase().getStatistic(PLAY_ONE_TICK)) * 50L + System.currentTimeMillis();
    }

    public boolean checkJailTimeout(long currentTime) {
        if (this.getJailTimeout() > 0L) {
            if (this.getOnlineJailedTime() > 0L && this.getOnlineJailedTime() > (long)this.getBase().getStatistic(PLAY_ONE_TICK)) {
                return false;
            }
            if (this.getJailTimeout() < currentTime && this.isJailed()) {
                JailStatusChangeEvent event = new JailStatusChangeEvent(this, null, false);
                this.ess.getServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    this.setJailTimeout(0L);
                    this.setOnlineJailedTime(0L);
                    this.setJailed(false);
                    this.sendMessage(I18n.tl("haveBeenReleased", new Object[0]));
                    this.setJail(null);
                    if (this.ess.getSettings().getTeleportWhenFreePolicy() == ISettings.TeleportWhenFreePolicy.BACK) {
                        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
                        this.getAsyncTeleport().back(future);
                        future.exceptionally(e -> {
                            this.getAsyncTeleport().respawn(null, PlayerTeleportEvent.TeleportCause.PLUGIN, new CompletableFuture<Boolean>());
                            return false;
                        });
                    } else if (this.ess.getSettings().getTeleportWhenFreePolicy() == ISettings.TeleportWhenFreePolicy.SPAWN) {
                        this.getAsyncTeleport().respawn(null, PlayerTeleportEvent.TeleportCause.PLUGIN, new CompletableFuture<Boolean>());
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public boolean checkMuteTimeout(long currentTime) {
        if (this.getMuteTimeout() > 0L && this.getMuteTimeout() < currentTime && this.isMuted()) {
            MuteStatusChangeEvent event = new MuteStatusChangeEvent(this, null, false, this.getMuteTimeout(), this.getMuteReason());
            this.ess.getServer().getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                this.setMuteTimeout(0L);
                this.sendMessage(I18n.tl("canTalkAgain", new Object[0]));
                this.setMuted(false);
                this.setMuteReason(null);
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public void updateActivity(boolean broadcast) {
        this.updateActivity(broadcast, AfkStatusChangeEvent.Cause.UNKNOWN);
    }

    public void updateActivity(boolean broadcast, AfkStatusChangeEvent.Cause cause) {
        if (this.isAfk()) {
            this.setAfk(false, cause);
            if (broadcast && !this.isHidden() && !this.isAfk()) {
                this.setDisplayNick();
                String msg = I18n.tl("userIsNotAway", this.getDisplayName());
                String selfmsg = I18n.tl("userIsNotAwaySelf", this.getDisplayName());
                if (!msg.isEmpty() && this.ess.getSettings().broadcastAfkMessage()) {
                    this.ess.broadcastMessage(this, msg, u -> u == this);
                }
                if (!selfmsg.isEmpty()) {
                    this.sendMessage(selfmsg);
                }
            }
        }
        this.lastActivity = System.currentTimeMillis();
    }

    public void updateActivityOnMove(boolean broadcast) {
        if (this.ess.getSettings().cancelAfkOnMove()) {
            this.updateActivity(broadcast, AfkStatusChangeEvent.Cause.MOVE);
        }
    }

    public void updateActivityOnInteract(boolean broadcast) {
        if (this.ess.getSettings().cancelAfkOnInteract()) {
            this.updateActivity(broadcast, AfkStatusChangeEvent.Cause.INTERACT);
        }
    }

    public void updateActivityOnChat(boolean broadcast) {
        if (this.ess.getSettings().cancelAfkOnChat()) {
            this.ess.scheduleSyncDelayedTask(() -> this.updateActivity(broadcast, AfkStatusChangeEvent.Cause.CHAT));
        }
    }

    public void checkActivity() {
        if (System.currentTimeMillis() - this.lastActivity <= 10000L) {
            return;
        }
        long autoafkkick = this.ess.getSettings().getAutoAfkKick();
        if (autoafkkick > 0L && this.lastActivity > 0L && this.lastActivity + autoafkkick * 1000L < System.currentTimeMillis() && !this.isAuthorized("essentials.kick.exempt") && !this.isAuthorized("essentials.afk.kickexempt")) {
            String kickReason = I18n.tl("autoAfkKickReason", (double)autoafkkick / 60.0);
            this.lastActivity = 0L;
            this.getBase().kickPlayer(kickReason);
            for (User user : this.ess.getOnlineUsers()) {
                if (!user.isAuthorized("essentials.kick.notify")) continue;
                user.sendMessage(I18n.tl("playerKicked", Console.DISPLAY_NAME, this.getName(), kickReason));
            }
        }
        long autoafk = this.ess.getSettings().getAutoAfk();
        if (!this.isAfk() && autoafk > 0L && this.lastActivity + autoafk * 1000L < System.currentTimeMillis() && this.isAuthorized("essentials.afk.auto")) {
            this.setAfk(true, AfkStatusChangeEvent.Cause.ACTIVITY);
            if (this.isAfk() && !this.isHidden()) {
                this.setDisplayNick();
                String msg = I18n.tl("userIsAway", this.getDisplayName());
                String selfmsg = I18n.tl("userIsAwaySelf", this.getDisplayName());
                if (!msg.isEmpty() && this.ess.getSettings().broadcastAfkMessage()) {
                    this.ess.broadcastMessage(this, msg, u -> u == this);
                }
                if (!selfmsg.isEmpty()) {
                    this.sendMessage(selfmsg);
                }
            }
        }
    }

    public Location getAfkPosition() {
        return this.afkPosition;
    }

    @Override
    public boolean isGodModeEnabled() {
        if (super.isGodModeEnabled() && !this.ess.getSettings().getNoGodWorlds().contains(this.getLocation().getWorld().getName())) {
            return true;
        }
        if (this.isAfk()) {
            return this.ess.getSettings().getFreezeAfkPlayers();
        }
        return false;
    }

    public boolean isGodModeEnabledRaw() {
        return super.isGodModeEnabled();
    }

    @Override
    public String getGroup() {
        String result = this.ess.getPermissionsHandler().getGroup(this.base);
        if (this.ess.getSettings().isDebug()) {
            this.ess.getLogger().log(Level.INFO, "looking up groupname of " + this.base.getName() + " - " + result);
        }
        return result;
    }

    @Override
    public boolean inGroup(String group) {
        boolean result = this.ess.getPermissionsHandler().inGroup(this.base, group);
        if (this.ess.getSettings().isDebug()) {
            this.ess.getLogger().log(Level.INFO, "checking if " + this.base.getName() + " is in group " + group + " - " + result);
        }
        return result;
    }

    @Override
    public boolean canBuild() {
        if (this.getBase().isOp()) {
            return true;
        }
        return this.ess.getPermissionsHandler().canBuild(this.base, this.getGroup());
    }

    @Override
    @Deprecated
    public long getTeleportRequestTime() {
        IUser.TpaRequest request = this.getNextTpaRequest(false, false, false);
        return request == null ? 0L : request.getTime();
    }

    public boolean isInvSee() {
        return this.invSee;
    }

    public void setInvSee(boolean set) {
        this.invSee = set;
    }

    public boolean isEnderSee() {
        return this.enderSee;
    }

    public void setEnderSee(boolean set) {
        this.enderSee = set;
    }

    @Override
    public void enableInvulnerabilityAfterTeleport() {
        long time = this.ess.getSettings().getTeleportInvulnerability();
        if (time > 0L) {
            this.teleportInvulnerabilityTimestamp = System.currentTimeMillis() + time;
        }
    }

    @Override
    public void resetInvulnerabilityAfterTeleport() {
        if (this.teleportInvulnerabilityTimestamp != 0L && this.teleportInvulnerabilityTimestamp < System.currentTimeMillis()) {
            this.teleportInvulnerabilityTimestamp = 0L;
        }
    }

    @Override
    public boolean hasInvulnerabilityAfterTeleport() {
        return this.teleportInvulnerabilityTimestamp != 0L && this.teleportInvulnerabilityTimestamp >= System.currentTimeMillis();
    }

    public boolean canInteractVanished() {
        return this.isAuthorized("essentials.vanish.interact");
    }

    @Override
    public boolean isIgnoreMsg() {
        return this.ignoreMsg;
    }

    @Override
    public void setIgnoreMsg(boolean ignoreMsg) {
        this.ignoreMsg = ignoreMsg;
    }

    @Override
    public boolean isVanished() {
        return this.vanished;
    }

    @Override
    public void setVanished(boolean set) {
        this.vanished = set;
        if (set) {
            for (User user : this.ess.getOnlineUsers()) {
                if (user.isAuthorized("essentials.vanish.see")) continue;
                user.getBase().hidePlayer(this.getBase());
            }
            this.setHidden(true);
            this.ess.getVanishedPlayersNew().add(this.getName());
            this.getBase().setMetadata("vanished", (MetadataValue)new FixedMetadataValue((Plugin)this.ess, (Object)true));
            if (this.isAuthorized("essentials.vanish.effect")) {
                this.getBase().addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 1, false));
            }
            if (this.ess.getSettings().sleepIgnoresVanishedPlayers()) {
                this.getBase().setSleepingIgnored(true);
            }
        } else {
            for (Player p : this.ess.getOnlinePlayers()) {
                p.showPlayer(this.getBase());
            }
            this.setHidden(false);
            this.ess.getVanishedPlayersNew().remove(this.getName());
            this.getBase().setMetadata("vanished", (MetadataValue)new FixedMetadataValue((Plugin)this.ess, (Object)false));
            if (this.isAuthorized("essentials.vanish.effect")) {
                this.getBase().removePotionEffect(PotionEffectType.INVISIBILITY);
            }
            if (this.ess.getSettings().sleepIgnoresVanishedPlayers() && !this.isAuthorized("essentials.sleepingignored")) {
                this.getBase().setSleepingIgnored(false);
            }
        }
    }

    public boolean checkSignThrottle() {
        if (this.isSignThrottled()) {
            return true;
        }
        this.updateThrottle();
        return false;
    }

    public boolean isSignThrottled() {
        long minTime = this.lastThrottledAction + (long)(1000 / this.ess.getSettings().getSignUsePerSecond());
        return System.currentTimeMillis() < minTime;
    }

    public void updateThrottle() {
        this.lastThrottledAction = System.currentTimeMillis();
    }

    public boolean isFlyClickJump() {
        return this.rightClickJump;
    }

    public void setRightClickJump(boolean rightClickJump) {
        this.rightClickJump = rightClickJump;
    }

    @Override
    public boolean isIgnoreExempt() {
        return this.isAuthorized("essentials.chat.ignoreexempt");
    }

    public boolean isRecipeSee() {
        return this.recipeSee;
    }

    public void setRecipeSee(boolean recipeSee) {
        this.recipeSee = recipeSee;
    }

    @Override
    public void sendMessage(String message) {
        if (!message.isEmpty()) {
            this.base.sendMessage(message);
        }
    }

    @Override
    public int compareTo(User other) {
        return FormatUtil.stripFormat(this.getDisplayName()).compareToIgnoreCase(FormatUtil.stripFormat(other.getDisplayName()));
    }

    public boolean equals(Object object) {
        if (!(object instanceof User)) {
            return false;
        }
        return this.getName().equalsIgnoreCase(((User)object).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public CommandSource getSource() {
        return new CommandSource((CommandSender)this.getBase());
    }

    @Override
    public String getName() {
        return this.getBase().getName();
    }

    @Override
    public UUID getUUID() {
        return this.getBase().getUniqueId();
    }

    @Override
    public boolean isReachable() {
        return this.getBase().isOnline();
    }

    @Override
    public IMessageRecipient.MessageResponse sendMessage(IMessageRecipient recipient, String message) {
        return this.messageRecipient.sendMessage(recipient, message);
    }

    @Override
    public IMessageRecipient.MessageResponse onReceiveMessage(IMessageRecipient sender, String message) {
        return this.messageRecipient.onReceiveMessage(sender, message);
    }

    @Override
    public IMessageRecipient getReplyRecipient() {
        return this.messageRecipient.getReplyRecipient();
    }

    @Override
    public void setReplyRecipient(IMessageRecipient recipient) {
        this.messageRecipient.setReplyRecipient(recipient);
    }

    @Override
    public String getAfkMessage() {
        return this.afkMessage;
    }

    @Override
    public void setAfkMessage(String message) {
        if (this.isAfk()) {
            this.afkMessage = message;
        }
    }

    @Override
    public long getAfkSince() {
        return this.afkSince;
    }

    @Override
    public Map<User, BigDecimal> getConfirmingPayments() {
        return this.confirmingPayments;
    }

    public String getConfirmingClearCommand() {
        return this.confirmingClearCommand;
    }

    public void setConfirmingClearCommand(String command) {
        this.confirmingClearCommand = command;
    }

    public ItemStack getItemInHand() {
        if (VersionUtil.getServerBukkitVersion().isLowerThan(VersionUtil.v1_9_R01)) {
            return this.getBase().getInventory().getItemInHand();
        }
        PlayerInventory inventory = this.getBase().getInventory();
        return inventory.getItemInMainHand() != null ? inventory.getItemInMainHand() : inventory.getItemInOffHand();
    }

    @Override
    public void sendMail(MailSender sender, String message) {
        this.sendMail(sender, message, 0L);
    }

    @Override
    public void sendMail(MailSender sender, String message, long expireAt) {
        this.ess.getMail().sendMail(this, sender, message, expireAt);
    }

    @Override
    @Deprecated
    public void addMail(String mail) {
        this.ess.getMail().sendLegacyMail(this, mail);
    }

    public void notifyOfMail() {
        int unread = this.getUnreadMailAmount();
        if (unread != 0) {
            int notifyPlayerOfMailCooldown = this.ess.getSettings().getNotifyPlayerOfMailCooldown() * 1000;
            if (System.currentTimeMillis() - this.lastNotifiedAboutMailsMs >= (long)notifyPlayerOfMailCooldown) {
                this.sendMessage(I18n.tl("youHaveNewMail", unread));
                this.lastNotifiedAboutMailsMs = System.currentTimeMillis();
            }
        }
    }

    public String getLastHomeConfirmation() {
        return this.lastHomeConfirmation;
    }

    public void setLastHomeConfirmation(String lastHomeConfirmation) {
        this.lastHomeConfirmation = lastHomeConfirmation;
    }

    public long getLastHomeConfirmationTimestamp() {
        return this.lastHomeConfirmationTimestamp;
    }

    public void setLastHomeConfirmationTimestamp() {
        this.lastHomeConfirmationTimestamp = System.currentTimeMillis();
    }

    public List<String> getSignCopy() {
        return this.signCopy;
    }

    public boolean isBaltopExempt() {
        if (this.getBase().isOnline()) {
            boolean exempt = this.isAuthorized("essentials.balancetop.exclude");
            this.setBaltopExemptCache(exempt);
            return exempt;
        }
        return this.isBaltopExcludeCache();
    }

    @Override
    public Block getTargetBlock(int maxDistance) {
        Block block;
        if (VersionUtil.getServerBukkitVersion().isLowerThan(VersionUtil.v1_13_2_R01) || (block = this.base.getTargetBlockExact(maxDistance)) == null) {
            return this.base.getTargetBlock(null, maxDistance);
        }
        return block;
    }

    @Override
    public void setToggleShout(boolean toggleShout) {
        this.toggleShout = toggleShout;
    }

    @Override
    public boolean isToggleShout() {
        return this.toggleShout;
    }
}

