/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.Console;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.commands.PlayerNotFoundException;
import com.earth2me.essentials.utils.FormatUtil;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.BanList;
import org.bukkit.Server;
import org.bukkit.entity.Player;

public class Commandbanip
extends EssentialsCommand {
    public Commandbanip() {
        super("banip");
    }

    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        String ipAddress;
        String senderDisplayName;
        if (args.length < 1) {
            throw new NotEnoughArgumentsException();
        }
        String senderName = sender.isPlayer() ? sender.getPlayer().getDisplayName() : "Console";
        String string = senderDisplayName = sender.isPlayer() ? sender.getPlayer().getDisplayName() : Console.DISPLAY_NAME;
        if (FormatUtil.validIP(args[0])) {
            ipAddress = args[0];
        } else {
            try {
                User player = this.getPlayer(server, args, 0, true, true);
                ipAddress = player.getLastLoginAddress();
            }
            catch (PlayerNotFoundException ex) {
                ipAddress = args[0];
            }
        }
        if (ipAddress.isEmpty()) {
            throw new PlayerNotFoundException();
        }
        String banReason = args.length > 1 ? FormatUtil.replaceFormat(Commandbanip.getFinalArg(args, 1).replace("\\n", "\n").replace("|", "\n")) : I18n.tl("defaultBanReason", new Object[0]);
        String banDisplay = I18n.tl("banFormat", banReason, senderDisplayName);
        this.ess.getServer().getBanList(BanList.Type.IP).addBan(ipAddress, banReason, null, senderName);
        server.getLogger().log(Level.INFO, I18n.tl("playerBanIpAddress", senderDisplayName, ipAddress, banReason));
        for (Player player : this.ess.getServer().getOnlinePlayers()) {
            if (!player.getAddress().getAddress().getHostAddress().equalsIgnoreCase(ipAddress)) continue;
            player.kickPlayer(banDisplay);
        }
        this.ess.broadcastMessage("essentials.banip.notify", I18n.tl("playerBanIpAddress", senderDisplayName, ipAddress, banReason));
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1) {
            return this.getPlayers(server, sender);
        }
        return Collections.emptyList();
    }
}

