/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.PlayerNotFoundException;
import com.earth2me.essentials.craftbukkit.InventoryWorkaround;
import com.earth2me.essentials.utils.NumberUtil;
import com.earth2me.essentials.utils.StringUtil;
import com.earth2me.essentials.utils.VersionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Commandclearinventory
extends EssentialsCommand {
    private static final int BASE_AMOUNT = 100000;
    private static final int EXTENDED_CAP = 8;

    public Commandclearinventory() {
        super("clearinventory");
    }

    @Override
    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        this.parseCommand(server, user.getSource(), commandLabel, args, user.isAuthorized("essentials.clearinventory.others"), user.isAuthorized("essentials.clearinventory.all") || user.isAuthorized("essentials.clearinventory.multiple"));
    }

    @Override
    protected void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        this.parseCommand(server, sender, commandLabel, args, true, true);
    }

    private void parseCommand(Server server, CommandSource sender, String commandLabel, String[] args, boolean allowOthers, boolean allowAll) throws Exception {
        Collection<Object> players = new ArrayList<Player>();
        User senderUser = this.ess.getUser(sender.getPlayer());
        String previousClearCommand = "";
        int offset = 0;
        if (sender.isPlayer()) {
            players.add(sender.getPlayer());
            previousClearCommand = senderUser.getConfirmingClearCommand();
            senderUser.setConfirmingClearCommand(null);
        }
        if (allowAll && args.length > 0 && args[0].contentEquals("*")) {
            sender.sendMessage(I18n.tl("inventoryClearingFromAll", new Object[0]));
            offset = 1;
            players = this.ess.getOnlinePlayers();
        } else if (allowOthers && args.length > 0 && args[0].trim().length() > 2) {
            offset = 1;
            players = server.matchPlayer(args[0].trim());
        }
        if (players.size() < 1) {
            throw new PlayerNotFoundException();
        }
        String formattedCommand = this.formatCommand(commandLabel, args);
        if (senderUser != null && senderUser.isPromptingClearConfirm() && !formattedCommand.equals(previousClearCommand)) {
            senderUser.setConfirmingClearCommand(formattedCommand);
            senderUser.sendMessage(I18n.tl("confirmClear", formattedCommand));
            return;
        }
        for (Player player : players) {
            this.clearHandler(sender, player, args, offset, players.size() < 8);
        }
    }

    protected void clearHandler(CommandSource sender, Player player, String[] args, int offset, boolean showExtended) {
        ClearHandlerType type = ClearHandlerType.ALL_EXCEPT_ARMOR;
        HashSet<Item> items = new HashSet<Item>();
        int amount = -1;
        if (args.length > offset + 1 && NumberUtil.isInt(args[offset + 1])) {
            amount = Integer.parseInt(args[offset + 1]);
        }
        if (args.length > offset) {
            if (args[offset].equalsIgnoreCase("**")) {
                type = ClearHandlerType.ALL_INCLUDING_ARMOR;
            } else if (!args[offset].equalsIgnoreCase("*")) {
                String[] split;
                for (String item : split = args[offset].split(",")) {
                    short data;
                    String[] itemParts = item.split(":");
                    try {
                        data = Short.parseShort(itemParts[1]);
                    }
                    catch (Exception e) {
                        data = 0;
                    }
                    try {
                        items.add(new Item(this.ess.getItemDb().get(itemParts[0]).getType(), data));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                type = ClearHandlerType.SPECIFIC_ITEM;
            }
        }
        if (type == ClearHandlerType.ALL_EXCEPT_ARMOR) {
            if (showExtended) {
                sender.sendMessage(I18n.tl("inventoryClearingAllItems", player.getDisplayName()));
            }
            InventoryWorkaround.clearInventoryNoArmor(player.getInventory());
            InventoryWorkaround.setItemInOffHand(player, null);
        } else if (type == ClearHandlerType.ALL_INCLUDING_ARMOR) {
            if (showExtended) {
                sender.sendMessage(I18n.tl("inventoryClearingAllArmor", player.getDisplayName()));
            }
            InventoryWorkaround.clearInventoryNoArmor(player.getInventory());
            InventoryWorkaround.setItemInOffHand(player, null);
            player.getInventory().setArmorContents(null);
        } else {
            for (Item item : items) {
                ItemStack stack = new ItemStack(item.getMaterial());
                if (VersionUtil.getServerBukkitVersion().isLowerThan(VersionUtil.v1_13_0_R01)) {
                    stack.setDurability(item.getData());
                }
                if (amount == -1) {
                    stack.setAmount(100000);
                    ItemStack removedStack = (ItemStack)player.getInventory().removeItem(new ItemStack[]{stack}).get(0);
                    int removedAmount = 100000 - removedStack.getAmount() + InventoryWorkaround.clearItemInOffHand(player, stack);
                    if (removedAmount <= 0 && !showExtended) continue;
                    sender.sendMessage(I18n.tl("inventoryClearingStack", removedAmount, stack.getType().toString().toLowerCase(Locale.ENGLISH), player.getDisplayName()));
                    continue;
                }
                stack.setAmount(amount < 0 ? 1 : amount);
                if (player.getInventory().containsAtLeast(stack, amount)) {
                    sender.sendMessage(I18n.tl("inventoryClearingStack", amount, stack.getType().toString().toLowerCase(Locale.ENGLISH), player.getDisplayName()));
                    player.getInventory().removeItem(new ItemStack[]{stack});
                    continue;
                }
                if (!showExtended) continue;
                sender.sendMessage(I18n.tl("inventoryClearFail", player.getDisplayName(), amount, stack.getType().toString().toLowerCase(Locale.ENGLISH)));
            }
        }
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, User user, String commandLabel, String[] args) {
        if (user.isAuthorized("essentials.clearinventory.others")) {
            if (args.length == 1) {
                List<String> options = this.getPlayers(server, user);
                if (user.isAuthorized("essentials.clearinventory.all") || user.isAuthorized("essentials.clearinventory.multiple")) {
                    options.add("*");
                }
                return options;
            }
            if (args.length == 2) {
                ArrayList<String> items = new ArrayList<String>(this.getItems());
                items.add("*");
                items.add("**");
                return items;
            }
            return Collections.emptyList();
        }
        if (args.length == 1) {
            ArrayList<String> items = new ArrayList<String>(this.getItems());
            items.add("*");
            items.add("**");
            return items;
        }
        return Collections.emptyList();
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1) {
            List<String> options = this.getPlayers(server, sender);
            options.add("*");
            return options;
        }
        if (args.length == 2) {
            ArrayList<String> items = new ArrayList<String>(this.getItems());
            items.add("*");
            items.add("**");
            return items;
        }
        return Collections.emptyList();
    }

    private String formatCommand(String commandLabel, String[] args) {
        return "/" + commandLabel + " " + StringUtil.joinList(" ", (Object[])args);
    }

    private static enum ClearHandlerType {
        ALL_EXCEPT_ARMOR,
        ALL_INCLUDING_ARMOR,
        SPECIFIC_ITEM;

    }

    private static class Item {
        private final Material material;
        private final short data;

        Item(Material material, short data) {
            this.material = material;
            this.data = data;
        }

        public Material getMaterial() {
            return this.material;
        }

        public short getData() {
            return this.data;
        }
    }
}

