/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.EssentialsUpgrade;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.UserMap;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.economy.EconomyLayer;
import com.earth2me.essentials.economy.EconomyLayers;
import com.earth2me.essentials.utils.DateUtil;
import com.earth2me.essentials.utils.EnumUtil;
import com.earth2me.essentials.utils.FloatUtil;
import com.earth2me.essentials.utils.NumberUtil;
import com.earth2me.essentials.utils.PasteUtil;
import com.earth2me.essentials.utils.VersionUtil;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.generator.WorldInfo;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.scheduler.BukkitRunnable;

public class Commandessentials
extends EssentialsCommand {
    private static final Sound NOTE_HARP = EnumUtil.valueOf(Sound.class, "BLOCK_NOTE_BLOCK_HARP", "BLOCK_NOTE_HARP", "NOTE_PIANO");
    private static final Sound MOO_SOUND = EnumUtil.valueOf(Sound.class, "COW_IDLE", "ENTITY_COW_MILK");
    private static final String HOMES_USAGE = "/<command> homes (fix | delete [world])";
    private static final String NYAN_TUNE = "1D#,1E,2F#,,2A#,1E,1D#,1E,2F#,2B,2D#,2E,2D#,2A#,2B,,2F#,,1D#,1E,2F#,2B,2C#,2A#,2B,2C#,2E,2D#,2E,2C#,,2F#,,2G#,,1D,1D#,,1C#,1D,1C#,1B,,1B,,1C#,,1D,,1D,1C#,1B,1C#,1D#,2F#,2G#,1D#,2F#,1C#,1D#,1B,1C#,1B,1D#,,2F#,,2G#,1D#,2F#,1C#,1D#,1B,1D,1D#,1D,1C#,1B,1C#,1D,,1B,1C#,1D#,2F#,1C#,1D,1C#,1B,1C#,,1B,,1C#,,2F#,,2G#,,1D,1D#,,1C#,1D,1C#,1B,,1B,,1C#,,1D,,1D,1C#,1B,1C#,1D#,2F#,2G#,1D#,2F#,1C#,1D#,1B,1C#,1B,1D#,,2F#,,2G#,1D#,2F#,1C#,1D#,1B,1D,1D#,1D,1C#,1B,1C#,1D,,1B,1C#,1D#,2F#,1C#,1D,1C#,1B,1C#,,1B,,1B,,1B,,1F#,1G#,1B,,1F#,1G#,1B,1C#,1D#,1B,1E,1D#,1E,2F#,1B,,1B,,1F#,1G#,1B,1E,1D#,1C#,1B,,,,1F#,1B,,1F#,1G#,1B,,1F#,1G#,1B,1B,1C#,1D#,1B,1F#,1G#,1F#,1B,,1B,1A#,1B,1F#,1G#,1B,1E,1D#,1E,2F#,1B,,1A#,,1B,,1F#,1G#,1B,,1F#,1G#,1B,1C#,1D#,1B,1E,1D#,1E,2F#,1B,,1B,,1F#,1G#,1B,1F#,1E,1D#,1C#,1B,,,,1F#,1B,,1F#,1G#,1B,,1F#,1G#,1B,1B,1C#,1D#,1B,1F#,1G#,1F#,1B,,1B,1A#,1B,1F#,1G#,1B,1E,1D#,1E,2F#,1B,,1A#,,1B,,1F#,1G#,1B,,1F#,1G#,1B,1C#,1D#,1B,1E,1D#,1E,2F#,1B,,1B,,1F#,1G#,1B,1F#,1E,1D#,1C#,1B,,,,1F#,1B,,1F#,1G#,1B,,1F#,1G#,1B,1B,1C#,1D#,1B,1F#,1G#,1F#,1B,,1B,1A#,1B,1F#,1G#,1B,1E,1D#,1E,2F#,1B,,1A#,,1B,,1F#,1G#,1B,,1F#,1G#,1B,1C#,1D#,1B,1E,1D#,1E,2F#,1B,,1B,,1F#,1G#,1B,1F#,1E,1D#,1C#,1B,,,,1F#,1B,,1F#,1G#,1B,,1F#,1G#,1B,1B,1C#,1D#,1B,1F#,1G#,1F#,1B,,1B,1A#,1B,1F#,1G#,1B,1E,1D#,1E,2F#,1B,,1A#,,1B,,1F#,1G#,1B,,1F#,1G#,1B,1C#,1D#,1B,1E,1D#,1E,2F#,1B,,1B,,1F#,1G#,1B,1F#,1E,1D#,1C#,1B,,,,1F#,1B,,1F#,1G#,1B,,1F#,1G#,1B,1B,1C#,1D#,1B,1F#,1G#,1F#,1B,,1B,1A#,1B,1F#,1G#,1B,1E,1D#,1E,2F#,1B,,1B,,";
    private static final String[] CONSOLE_MOO = new String[]{"         (__)", "         (oo)", "   /------\\/", "  / |    ||", " *  /\\---/\\", "    ~~   ~~", "....\"Have you mooed today?\"..."};
    private static final String[] PLAYER_MOO = new String[]{"            (__)", "            (oo)", "   /------\\/", "  /  |      | |", " *  /\\---/\\", "    ~~    ~~", "....\"Have you mooed today?\"..."};
    private static final List<String> versionPlugins = Arrays.asList("Vault", "Reserve", "PlaceholderAPI", "CMI", "Towny", "ChestShop", "Citizens", "LuckPerms", "UltraPermissions", "PermissionsEx", "GroupManager", "bPermissions", "DiscordSRV");
    private static final List<String> officialPlugins = Arrays.asList("EssentialsAntiBuild", "EssentialsChat", "EssentialsDiscord", "EssentialsGeoIP", "EssentialsProtect", "EssentialsSpawn", "EssentialsXMPP");
    private static final List<String> warnPlugins = Arrays.asList("PermissionsEx", "GroupManager", "bPermissions");
    private transient TuneRunnable currentTune = null;

    public Commandessentials() {
        super("essentials");
    }

    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        if (args.length == 0) {
            this.showUsage(sender);
        }
        switch (args[0]) {
            case "debug": 
            case "verbose": {
                this.runDebug(server, sender, commandLabel, args);
                break;
            }
            case "ver": 
            case "version": {
                this.runVersion(server, sender, commandLabel, args);
                break;
            }
            case "cmd": 
            case "commands": {
                this.runCommands(server, sender, commandLabel, args);
                break;
            }
            case "dump": {
                this.runDump(server, sender, commandLabel, args);
                break;
            }
            case "reload": {
                this.runReload(server, sender, commandLabel, args);
                break;
            }
            case "reset": {
                this.runReset(server, sender, commandLabel, args);
                break;
            }
            case "cleanup": {
                this.runCleanup(server, sender, commandLabel, args);
                break;
            }
            case "homes": {
                this.runHomes(server, sender, commandLabel, args);
                break;
            }
            case "uuidconvert": {
                this.runUUIDConvert(server, sender, commandLabel, args);
                break;
            }
            case "uuidtest": {
                this.runUUIDTest(server, sender, commandLabel, args);
                break;
            }
            case "nya": 
            case "nyan": {
                this.runNya(server, sender, commandLabel, args);
                break;
            }
            case "moo": {
                this.runMoo(server, sender, commandLabel, args);
                break;
            }
            default: {
                this.showUsage(sender);
            }
        }
    }

    private void showUsage(CommandSource sender) throws Exception {
        throw new NotEnoughArgumentsException();
    }

    private void runCommands(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (this.ess.getAlternativeCommandsHandler().disabledCommands().size() == 0) {
            sender.sendMessage(I18n.tl("blockListEmpty", new Object[0]));
            return;
        }
        sender.sendMessage(I18n.tl("blockList", new Object[0]));
        for (Map.Entry<String, String> entry : this.ess.getAlternativeCommandsHandler().disabledCommands().entrySet()) {
            sender.sendMessage(entry.getKey() + " => " + entry.getValue());
        }
    }

    private void runDump(Server server, CommandSource sender, String commandLabel, String[] args) {
        sender.sendMessage(I18n.tl("dumpCreating", new Object[0]));
        JsonObject dump = new JsonObject();
        JsonObject meta = new JsonObject();
        meta.addProperty("timestamp", (Number)Instant.now().toEpochMilli());
        meta.addProperty("sender", sender.getPlayer() != null ? sender.getPlayer().getName() : null);
        meta.addProperty("senderUuid", sender.getPlayer() != null ? sender.getPlayer().getUniqueId().toString() : null);
        dump.add("meta", (JsonElement)meta);
        JsonObject serverData = new JsonObject();
        serverData.addProperty("bukkit-version", Bukkit.getBukkitVersion());
        serverData.addProperty("server-version", Bukkit.getVersion());
        serverData.addProperty("server-brand", Bukkit.getName());
        serverData.addProperty("online-mode", this.ess.getOnlineModeProvider().getOnlineModeString());
        JsonObject supportStatus = new JsonObject();
        VersionUtil.SupportStatus status = VersionUtil.getServerSupportStatus();
        supportStatus.addProperty("status", status.name());
        supportStatus.addProperty("supported", Boolean.valueOf(status.isSupported()));
        supportStatus.addProperty("trigger", VersionUtil.getSupportStatusClass());
        serverData.add("support-status", (JsonElement)supportStatus);
        dump.add("server-data", (JsonElement)serverData);
        JsonObject environment = new JsonObject();
        environment.addProperty("java-version", System.getProperty("java.version"));
        environment.addProperty("operating-system", System.getProperty("os.name"));
        environment.addProperty("uptime", DateUtil.formatDateDiff(ManagementFactory.getRuntimeMXBean().getStartTime()));
        environment.addProperty("allocated-memory", Runtime.getRuntime().totalMemory() / 1024L / 1024L + "MB");
        dump.add("environment", (JsonElement)environment);
        JsonObject essData = new JsonObject();
        essData.addProperty("version", this.ess.getDescription().getVersion());
        JsonObject updateData = new JsonObject();
        updateData.addProperty("id", this.ess.getUpdateChecker().getVersionIdentifier());
        updateData.addProperty("branch", this.ess.getUpdateChecker().getVersionBranch());
        updateData.addProperty("dev", Boolean.valueOf(this.ess.getUpdateChecker().isDevBuild()));
        essData.add("update-data", (JsonElement)updateData);
        JsonObject econLayer = new JsonObject();
        econLayer.addProperty("enabled", Boolean.valueOf(!this.ess.getSettings().isEcoDisabled()));
        econLayer.addProperty("selected-layer", Boolean.valueOf(EconomyLayers.isLayerSelected()));
        EconomyLayer layer = EconomyLayers.getSelectedLayer();
        econLayer.addProperty("name", layer == null ? "null" : layer.getName());
        econLayer.addProperty("layer-version", layer == null ? "null" : layer.getPluginVersion());
        econLayer.addProperty("backend-name", layer == null ? "null" : layer.getBackendName());
        essData.add("economy-layer", (JsonElement)econLayer);
        JsonArray addons = new JsonArray();
        JsonArray plugins = new JsonArray();
        ArrayList<Plugin> alphabetical = new ArrayList<Plugin>();
        Collections.addAll(alphabetical, Bukkit.getPluginManager().getPlugins());
        alphabetical.sort(Comparator.comparing(o -> o.getName().toUpperCase(Locale.ENGLISH)));
        for (Plugin plugin : alphabetical) {
            JsonObject pluginData = new JsonObject();
            PluginDescriptionFile info = plugin.getDescription();
            String name = info.getName();
            pluginData.addProperty("name", name);
            pluginData.addProperty("version", info.getVersion());
            pluginData.addProperty("description", info.getDescription());
            pluginData.addProperty("main", info.getMain());
            pluginData.addProperty("enabled", Boolean.valueOf(plugin.isEnabled()));
            pluginData.addProperty("official", Boolean.valueOf(plugin == this.ess || officialPlugins.contains(name)));
            pluginData.addProperty("unsupported", Boolean.valueOf(warnPlugins.contains(name)));
            JsonArray authors = new JsonArray();
            for (String author : info.getAuthors()) {
                authors.add((JsonElement)(author == null ? JsonNull.INSTANCE : new JsonPrimitive(author)));
            }
            pluginData.add("authors", (JsonElement)authors);
            if (name.startsWith("Essentials") && !name.equals("Essentials")) {
                addons.add((JsonElement)pluginData);
            }
            plugins.add((JsonElement)pluginData);
        }
        essData.add("addons", (JsonElement)addons);
        dump.add("ess-data", (JsonElement)essData);
        dump.add("plugins", (JsonElement)plugins);
        ArrayList<PasteUtil.PasteFile> files = new ArrayList<PasteUtil.PasteFile>();
        files.add(new PasteUtil.PasteFile("dump.json", dump.toString()));
        Plugin essDiscord = Bukkit.getPluginManager().getPlugin("EssentialsDiscord");
        this.ess.runTaskAsynchronously(() -> {
            boolean config = false;
            boolean discord = false;
            boolean kits = false;
            boolean log = false;
            for (String arg : args) {
                if (arg.equals("*") || arg.equalsIgnoreCase("all")) {
                    config = true;
                    discord = true;
                    kits = true;
                    log = true;
                    break;
                }
                if (arg.equalsIgnoreCase("config")) {
                    config = true;
                    continue;
                }
                if (arg.equalsIgnoreCase("discord")) {
                    discord = true;
                    continue;
                }
                if (arg.equalsIgnoreCase("kits")) {
                    kits = true;
                    continue;
                }
                if (!arg.equalsIgnoreCase("log")) continue;
                log = true;
            }
            if (config) {
                try {
                    files.add(new PasteUtil.PasteFile("config.yml", new String(Files.readAllBytes(this.ess.getSettings().getConfigFile().toPath()), StandardCharsets.UTF_8)));
                }
                catch (IOException e) {
                    sender.sendMessage(I18n.tl("dumpErrorUpload", "config.yml", e.getMessage()));
                }
            }
            if (discord && essDiscord != null) {
                try {
                    files.add(new PasteUtil.PasteFile("discord-config.yml", new String(Files.readAllBytes(essDiscord.getDataFolder().toPath().resolve("config.yml")), StandardCharsets.UTF_8).replaceAll("[A-Za-z\\d]{24}\\.[\\w-]{6}\\.[\\w-]{27}", "<censored token>")));
                }
                catch (IOException e) {
                    sender.sendMessage(I18n.tl("dumpErrorUpload", "discord-config.yml", e.getMessage()));
                }
            }
            if (kits) {
                try {
                    files.add(new PasteUtil.PasteFile("kits.yml", new String(Files.readAllBytes(this.ess.getKits().getFile().toPath()), StandardCharsets.UTF_8)));
                }
                catch (IOException e) {
                    sender.sendMessage(I18n.tl("dumpErrorUpload", "kits.yml", e.getMessage()));
                }
            }
            if (log) {
                try {
                    files.add(new PasteUtil.PasteFile("latest.log", new String(Files.readAllBytes(Paths.get("logs", "latest.log")), StandardCharsets.UTF_8).replaceAll("(?m)^\\[\\d\\d:\\d\\d:\\d\\d] \\[.+/(?:DEBUG|TRACE)]: .+\\s(?:[A-Za-z.]+:.+\\s(?:\\t.+\\s)*)?\\s*(?:\"[A-Za-z]+\" : .+[\\s}\\]]+)*", "").replaceAll("(?:[0-9]{1,3}\\.){3}[0-9]{1,3}", "<censored ip address>")));
                }
                catch (IOException e) {
                    sender.sendMessage(I18n.tl("dumpErrorUpload", "latest.log", e.getMessage()));
                }
            }
            CompletableFuture<PasteUtil.PasteResult> future = PasteUtil.createPaste(files);
            future.thenAccept(result -> {
                if (result != null) {
                    String dumpUrl = "https://essentialsx.net/dump.html?id=" + result.getPasteId();
                    sender.sendMessage(I18n.tl("dumpUrl", dumpUrl));
                    sender.sendMessage(I18n.tl("dumpDeleteKey", result.getDeletionKey()));
                    if (sender.isPlayer()) {
                        this.ess.getLogger().info(I18n.tl("dumpConsoleUrl", dumpUrl));
                        this.ess.getLogger().info(I18n.tl("dumpDeleteKey", result.getDeletionKey()));
                    }
                }
                files.clear();
            });
            future.exceptionally(throwable -> {
                sender.sendMessage(I18n.tl("dumpError", throwable.getMessage()));
                return null;
            });
        });
    }

    private void runReset(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        if (args.length < 2) {
            throw new Exception("/<command> reset <player>");
        }
        User user = this.getPlayer(server, args, 1, true, true);
        user.reset();
        sender.sendMessage("Reset Essentials userdata for player: " + user.getDisplayName());
    }

    private void runDebug(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        this.ess.getSettings().setDebug(!this.ess.getSettings().isDebug());
        sender.sendMessage("Essentials " + this.ess.getDescription().getVersion() + " debug mode " + (this.ess.getSettings().isDebug() ? "enabled" : "disabled"));
    }

    private void runReload(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        this.ess.reload();
        sender.sendMessage(I18n.tl("essentialsReload", this.ess.getDescription().getVersion()));
    }

    private void runNya(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        if (this.currentTune != null) {
            this.currentTune.cancel();
        }
        this.currentTune = new TuneRunnable(NYAN_TUNE, NOTE_HARP, this.ess::getOnlinePlayers);
        this.currentTune.runTaskTimer(this.ess, 20L, 2L);
    }

    private void runMoo(Server server, CommandSource sender, String command, String[] args) {
        if (args.length == 2 && args[1].equals("moo")) {
            for (String s2 : CONSOLE_MOO) {
                logger.info(s2);
            }
            for (Player player : this.ess.getOnlinePlayers()) {
                player.sendMessage(PLAYER_MOO);
                player.playSound(player.getLocation(), MOO_SOUND, 1.0f, 1.0f);
            }
        } else if (sender.isPlayer()) {
            sender.getSender().sendMessage(PLAYER_MOO);
            Player player = sender.getPlayer();
            player.playSound(player.getLocation(), MOO_SOUND, 1.0f, 1.0f);
        } else {
            sender.getSender().sendMessage(CONSOLE_MOO);
        }
    }

    private void runCleanup(Server server, CommandSource sender, String command, String[] args) throws Exception {
        if (args.length < 2 || !NumberUtil.isInt(args[1])) {
            sender.sendMessage("This sub-command will delete users who haven't logged in in the last <days> days.");
            sender.sendMessage("Optional parameters define the minimum amount required to prevent deletion.");
            sender.sendMessage("Unless you define larger default values, this command will ignore people who have more than 0 money/homes.");
            throw new Exception("/<command> cleanup <days> [money] [homes]");
        }
        sender.sendMessage(I18n.tl("cleaning", new Object[0]));
        long daysArg = Long.parseLong(args[1]);
        double moneyArg = args.length >= 3 ? FloatUtil.parseDouble(args[2].replaceAll("[^0-9\\.]", "")) : 0.0;
        int homesArg = args.length >= 4 && NumberUtil.isInt(args[3]) ? Integer.parseInt(args[3]) : 0;
        UserMap userMap = this.ess.getUserMap();
        this.ess.runTaskAsynchronously(() -> {
            long currTime = System.currentTimeMillis();
            for (UUID u : userMap.getAllUniqueUsers()) {
                User user = this.ess.getUserMap().getUser(u);
                if (user == null) continue;
                long lastLog = user.getLastLogout();
                if (lastLog == 0L) {
                    lastLog = user.getLastLogin();
                }
                if (lastLog == 0L) {
                    user.setLastLogin(currTime);
                }
                if (user.isNPC()) continue;
                long timeDiff = currTime - lastLog;
                long milliDays = daysArg * 24L * 60L * 60L * 1000L;
                int homeCount = user.getHomes().size();
                double moneyCount = user.getMoney().doubleValue();
                if (lastLog == 0L || timeDiff < milliDays || homeCount > homesArg || moneyCount > moneyArg) continue;
                if (this.ess.getSettings().isDebug()) {
                    this.ess.getLogger().info("Deleting user: " + user.getName() + " Money: " + moneyCount + " Homes: " + homeCount + " Last seen: " + DateUtil.formatDateDiff(lastLog));
                }
                user.reset();
            }
            sender.sendMessage(I18n.tl("cleaned", new Object[0]));
        });
    }

    private void runHomes(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        if (args.length < 2) {
            sender.sendMessage("This sub-command provides a utility to mass-delete homes based on user options:");
            sender.sendMessage("Use \"fix\" to delete all homes inside non-existent or unloaded worlds.");
            sender.sendMessage("Use \"delete\" to delete all existing homes.");
            sender.sendMessage("Use \"delete <worldname>\" to delete all homes inside a specific world.");
            throw new Exception(HOMES_USAGE);
        }
        UserMap userMap = this.ess.getUserMap();
        switch (args[1]) {
            case "fix": {
                sender.sendMessage(I18n.tl("fixingHomes", new Object[0]));
                this.ess.runTaskAsynchronously(() -> {
                    for (UUID u : userMap.getAllUniqueUsers()) {
                        User user = this.ess.getUserMap().getUser(u);
                        if (user == null) continue;
                        for (String homeName : user.getHomes()) {
                            try {
                                if (user.getHome(homeName) != null) continue;
                                user.delHome(homeName);
                            }
                            catch (Exception e) {
                                this.ess.getLogger().info("Unable to delete home " + homeName + " for " + user.getName());
                            }
                        }
                    }
                    sender.sendMessage(I18n.tl("fixedHomes", new Object[0]));
                });
                break;
            }
            case "delete": {
                boolean filterByWorld;
                boolean bl = filterByWorld = args.length >= 3;
                if (filterByWorld && server.getWorld(args[2]) == null) {
                    throw new Exception(I18n.tl("invalidWorld", new Object[0]));
                }
                sender.sendMessage(filterByWorld ? I18n.tl("deletingHomesWorld", args[2]) : I18n.tl("deletingHomes", new Object[0]));
                this.ess.runTaskAsynchronously(() -> {
                    for (UUID u : userMap.getAllUniqueUsers()) {
                        User user = this.ess.getUserMap().getUser(u);
                        if (user == null) continue;
                        for (String homeName : user.getHomes()) {
                            try {
                                Location home = user.getHome(homeName);
                                if (filterByWorld && (home == null || home.getWorld() == null || !home.getWorld().getName().equals(args[2]))) continue;
                                user.delHome(homeName);
                            }
                            catch (Exception e) {
                                this.ess.getLogger().info("Unable to delete home " + homeName + " for " + user.getName());
                            }
                        }
                    }
                    sender.sendMessage(filterByWorld ? I18n.tl("deletedHomesWorld", args[2]) : I18n.tl("deletedHomes", new Object[0]));
                });
                break;
            }
            default: {
                throw new Exception(HOMES_USAGE);
            }
        }
    }

    private void runUUIDConvert(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        sender.sendMessage("Starting Essentials UUID userdata conversion; this may lag the server.");
        Boolean ignoreUFCache = args.length > 2 && args[1].toLowerCase(Locale.ENGLISH).contains("ignore");
        EssentialsUpgrade.uuidFileConvert(this.ess, ignoreUFCache);
        sender.sendMessage("UUID conversion complete. Check your server log for more information.");
    }

    private void runUUIDTest(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        Player player2;
        if (args.length < 2) {
            throw new Exception("/<command> uuidtest <name>");
        }
        String name = args[1];
        sender.sendMessage("Looking up UUID for " + name);
        UUID onlineUUID = null;
        for (Player player2 : this.ess.getOnlinePlayers()) {
            if (!player2.getName().equalsIgnoreCase(name)) continue;
            onlineUUID = player2.getUniqueId();
            break;
        }
        UUID essUUID = this.ess.getUserMap().getUser(name).getConfigUUID();
        player2 = this.ess.getServer().getOfflinePlayer(name);
        UUID bukkituuid = player2.getUniqueId();
        sender.sendMessage("Bukkit Lookup: " + bukkituuid.toString());
        if (onlineUUID != null && onlineUUID != bukkituuid) {
            sender.sendMessage("Online player: " + onlineUUID.toString());
        }
        if (essUUID != null && essUUID != bukkituuid) {
            sender.sendMessage("Essentials config: " + essUUID.toString());
        }
        UUID npcuuid = UUID.nameUUIDFromBytes(("NPC:" + name).getBytes(Charsets.UTF_8));
        sender.sendMessage("NPC UUID: " + npcuuid.toString());
        UUID offlineuuid = UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(Charsets.UTF_8));
        sender.sendMessage("Offline Mode UUID: " + offlineuuid.toString());
    }

    private void runVersion(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        String layer;
        if (sender.isPlayer() && !this.ess.getUser(sender.getPlayer()).isAuthorized("essentials.version")) {
            return;
        }
        boolean isMismatched = false;
        boolean isVaultInstalled = false;
        boolean isUnsupported = false;
        VersionUtil.SupportStatus supportStatus = VersionUtil.getServerSupportStatus();
        PluginManager pm = server.getPluginManager();
        String essVer = pm.getPlugin("Essentials").getDescription().getVersion();
        String serverMessageKey = supportStatus.isSupported() ? "versionOutputFine" : (supportStatus == VersionUtil.SupportStatus.UNSTABLE ? "versionOutputUnsupported" : "versionOutputWarn");
        sender.sendMessage(I18n.tl(serverMessageKey, "Server", server.getBukkitVersion() + " " + server.getVersion()));
        sender.sendMessage(I18n.tl(serverMessageKey, "Brand", server.getName()));
        sender.sendMessage(I18n.tl("versionOutputFine", "EssentialsX", essVer));
        for (Plugin plugin : pm.getPlugins()) {
            PluginDescriptionFile desc = plugin.getDescription();
            String name = desc.getName();
            String version = desc.getVersion();
            if (name.startsWith("Essentials") && !name.equalsIgnoreCase("Essentials")) {
                if (officialPlugins.contains(name)) {
                    name = name.replace("Essentials", "EssentialsX");
                    if (!version.equalsIgnoreCase(essVer)) {
                        isMismatched = true;
                        sender.sendMessage(I18n.tl("versionOutputWarn", name, version));
                    } else {
                        sender.sendMessage(I18n.tl("versionOutputFine", name, version));
                    }
                } else {
                    sender.sendMessage(I18n.tl("versionOutputUnsupported", name, version));
                    isUnsupported = true;
                }
            }
            if (versionPlugins.contains(name)) {
                if (warnPlugins.contains(name)) {
                    sender.sendMessage(I18n.tl("versionOutputUnsupported", name, version));
                    isUnsupported = true;
                } else {
                    sender.sendMessage(I18n.tl("versionOutputFine", name, version));
                }
            }
            if (!name.equals("Vault")) continue;
            isVaultInstalled = true;
        }
        if (this.ess.getSettings().isEcoDisabled()) {
            layer = "Disabled";
        } else if (EconomyLayers.isLayerSelected()) {
            EconomyLayer economyLayer = EconomyLayers.getSelectedLayer();
            layer = economyLayer.getName() + " (" + economyLayer.getBackendName() + ")";
        } else {
            layer = "None";
        }
        sender.sendMessage(I18n.tl("versionOutputEconLayer", layer));
        if (isMismatched) {
            sender.sendMessage(I18n.tl("versionMismatchAll", new Object[0]));
        }
        if (!isVaultInstalled) {
            sender.sendMessage(I18n.tl("versionOutputVaultMissing", new Object[0]));
        }
        if (isUnsupported) {
            sender.sendMessage(I18n.tl("versionOutputUnsupportedPlugins", new Object[0]));
        }
        switch (supportStatus) {
            case NMS_CLEANROOM: {
                sender.sendMessage(ChatColor.DARK_RED + I18n.tl("serverUnsupportedCleanroom", new Object[0]));
                break;
            }
            case DANGEROUS_FORK: {
                sender.sendMessage(ChatColor.DARK_RED + I18n.tl("serverUnsupportedDangerous", new Object[0]));
                break;
            }
            case UNSTABLE: {
                sender.sendMessage(ChatColor.DARK_RED + I18n.tl("serverUnsupportedMods", new Object[0]));
                break;
            }
            case OUTDATED: {
                sender.sendMessage(ChatColor.RED + I18n.tl("serverUnsupported", new Object[0]));
                break;
            }
            case LIMITED: {
                sender.sendMessage(ChatColor.RED + I18n.tl("serverUnsupportedLimitedApi", new Object[0]));
            }
        }
        if (VersionUtil.getSupportStatusClass() != null) {
            sender.sendMessage(ChatColor.RED + I18n.tl("serverUnsupportedClass", VersionUtil.getSupportStatusClass()));
        }
        sender.sendMessage(I18n.tl("versionFetching", new Object[0]));
        this.ess.runTaskAsynchronously(() -> {
            for (String str : this.ess.getUpdateChecker().getVersionMessages(true, true)) {
                sender.sendMessage(str);
            }
        });
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1) {
            ArrayList options = Lists.newArrayList();
            options.add("reload");
            options.add("version");
            options.add("dump");
            options.add("commands");
            options.add("debug");
            options.add("reset");
            options.add("cleanup");
            options.add("homes");
            return options;
        }
        switch (args[0]) {
            case "moo": {
                if (args.length != 2) break;
                return Lists.newArrayList((Object[])new String[]{"moo"});
            }
            case "reset": 
            case "uuidtest": {
                if (args.length != 2) break;
                return this.getPlayers(server, sender);
            }
            case "cleanup": {
                if (args.length == 2) {
                    return COMMON_DURATIONS;
                }
                if (args.length != 3 && args.length != 4) break;
                return Lists.newArrayList((Object[])new String[]{"-1", "0"});
            }
            case "homes": {
                if (args.length == 2) {
                    return Lists.newArrayList((Object[])new String[]{"fix", "delete"});
                }
                if (args.length != 3 || !args[1].equalsIgnoreCase("delete")) break;
                return server.getWorlds().stream().map(WorldInfo::getName).collect(Collectors.toList());
            }
            case "uuidconvert": {
                if (args.length != 2) break;
                return Lists.newArrayList((Object[])new String[]{"ignoreUFCache"});
            }
            case "dump": {
                ArrayList list = Lists.newArrayList((Object[])new String[]{"config", "kits", "log", "discord", "all"});
                for (String arg : args) {
                    if (arg.equals("*") || arg.equalsIgnoreCase("all")) {
                        list.clear();
                        return list;
                    }
                    list.remove(arg.toLowerCase(Locale.ENGLISH));
                }
                return list;
            }
        }
        return Collections.emptyList();
    }

    private static class TuneRunnable
    extends BukkitRunnable {
        private static final Map<String, Float> noteMap = ImmutableMap.builder().put((Object)"1F#", (Object)Float.valueOf(0.5f)).put((Object)"1G", (Object)Float.valueOf(0.53f)).put((Object)"1G#", (Object)Float.valueOf(0.56f)).put((Object)"1A", (Object)Float.valueOf(0.6f)).put((Object)"1A#", (Object)Float.valueOf(0.63f)).put((Object)"1B", (Object)Float.valueOf(0.67f)).put((Object)"1C", (Object)Float.valueOf(0.7f)).put((Object)"1C#", (Object)Float.valueOf(0.76f)).put((Object)"1D", (Object)Float.valueOf(0.8f)).put((Object)"1D#", (Object)Float.valueOf(0.84f)).put((Object)"1E", (Object)Float.valueOf(0.9f)).put((Object)"1F", (Object)Float.valueOf(0.94f)).put((Object)"2F#", (Object)Float.valueOf(1.0f)).put((Object)"2G", (Object)Float.valueOf(1.06f)).put((Object)"2G#", (Object)Float.valueOf(1.12f)).put((Object)"2A", (Object)Float.valueOf(1.18f)).put((Object)"2A#", (Object)Float.valueOf(1.26f)).put((Object)"2B", (Object)Float.valueOf(1.34f)).put((Object)"2C", (Object)Float.valueOf(1.42f)).put((Object)"2C#", (Object)Float.valueOf(1.5f)).put((Object)"2D", (Object)Float.valueOf(1.6f)).put((Object)"2D#", (Object)Float.valueOf(1.68f)).put((Object)"2E", (Object)Float.valueOf(1.78f)).put((Object)"2F", (Object)Float.valueOf(1.88f)).build();
        private final String[] tune;
        private final Sound sound;
        private final Supplier<Collection<Player>> players;
        private int i = 0;

        TuneRunnable(String tuneStr, Sound sound, Supplier<Collection<Player>> players) {
            this.tune = tuneStr.split(",");
            this.sound = sound;
            this.players = players;
        }

        public void run() {
            String note = this.tune[this.i];
            ++this.i;
            if (this.i >= this.tune.length) {
                this.cancel();
            }
            if (note == null || note.isEmpty()) {
                return;
            }
            for (Player onlinePlayer : this.players.get()) {
                onlinePlayer.playSound(onlinePlayer.getLocation(), this.sound, 1.0f, noteMap.get(note).floatValue());
            }
        }
    }
}

