/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.Console;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.commands.PlayerNotFoundException;
import com.earth2me.essentials.utils.FormatUtil;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import net.essentialsx.api.v2.events.UserKickEvent;
import org.bukkit.Server;
import org.bukkit.event.Event;

public class Commandkick
extends EssentialsCommand {
    public Commandkick() {
        super("kick");
    }

    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        User user;
        if (args.length < 1) {
            throw new NotEnoughArgumentsException();
        }
        User target = this.getPlayer(server, args, 0, true, false);
        User user2 = user = sender.isPlayer() ? this.ess.getUser(sender.getPlayer()) : null;
        if (user != null) {
            if (target.isHidden(sender.getPlayer()) && !user.canInteractVanished() && !sender.getPlayer().canSee(target.getBase())) {
                throw new PlayerNotFoundException();
            }
            if (target.isAuthorized("essentials.kick.exempt")) {
                throw new Exception(I18n.tl("kickExempt", new Object[0]));
            }
        }
        String kickReason = args.length > 1 ? Commandkick.getFinalArg(args, 1) : I18n.tl("kickDefault", new Object[0]);
        kickReason = FormatUtil.replaceFormat(kickReason.replace("\\n", "\n").replace("|", "\n"));
        UserKickEvent event = new UserKickEvent(user, target, kickReason);
        this.ess.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        kickReason = event.getReason();
        target.getBase().kickPlayer(kickReason);
        String senderDisplayName = sender.isPlayer() ? sender.getPlayer().getDisplayName() : Console.DISPLAY_NAME;
        server.getLogger().log(Level.INFO, I18n.tl("playerKicked", senderDisplayName, target.getName(), kickReason));
        this.ess.broadcastMessage("essentials.kick.notify", I18n.tl("playerKicked", senderDisplayName, target.getName(), kickReason));
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1) {
            return this.getPlayers(server, sender);
        }
        return Collections.emptyList();
    }
}

