/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.PlayerList;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bukkit.Server;

public class Commandlist
extends EssentialsCommand {
    public Commandlist() {
        super("list");
    }

    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        boolean showHidden = true;
        User user = null;
        if (sender.isPlayer()) {
            user = this.ess.getUser(sender.getPlayer());
            showHidden = user.isAuthorized("essentials.list.hidden") || user.canInteractVanished();
        }
        sender.sendMessage(PlayerList.listSummary(this.ess, user, showHidden));
        Map<String, List<User>> playerList = PlayerList.getPlayerLists(this.ess, user, showHidden);
        if (args.length > 0) {
            sender.sendMessage(PlayerList.listGroupUsers(this.ess, playerList, args[0].toLowerCase()));
        } else {
            this.sendGroupedList(sender, commandLabel, playerList);
        }
    }

    private void sendGroupedList(CommandSource sender, String commandLabel, Map<String, List<User>> playerList) {
        for (String str : PlayerList.prepareGroupedList(this.ess, commandLabel, playerList)) {
            sender.sendMessage(str);
        }
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1) {
            return new ArrayList<String>(PlayerList.getPlayerLists(this.ess, sender.getUser(this.ess), false).keySet());
        }
        return Collections.emptyList();
    }
}

