/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.Console;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NoChargeException;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.commands.PlayerNotFoundException;
import com.earth2me.essentials.messaging.IMessageRecipient;
import com.earth2me.essentials.textreader.SimpleTextInput;
import com.earth2me.essentials.textreader.TextPager;
import com.earth2me.essentials.utils.DateUtil;
import com.earth2me.essentials.utils.FormatUtil;
import com.earth2me.essentials.utils.NumberUtil;
import com.earth2me.essentials.utils.StringUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.UUID;
import net.essentialsx.api.v2.services.mail.MailMessage;
import org.bukkit.Server;

public class Commandmail
extends EssentialsCommand {
    private static int mailsPerMinute = 0;
    private static long timestamp = 0L;

    public Commandmail() {
        super("mail");
    }

    @Override
    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        if (args.length >= 1 && "read".equalsIgnoreCase(args[0])) {
            ArrayList<MailMessage> mail = user.getMailMessages();
            if (mail == null || mail.size() == 0) {
                user.sendMessage(I18n.tl("noMail", new Object[0]));
                throw new NoChargeException();
            }
            SimpleTextInput input = new SimpleTextInput();
            ListIterator<MailMessage> iterator = mail.listIterator();
            while (iterator.hasNext()) {
                MailMessage mailObj = iterator.next();
                if (mailObj.isExpired()) {
                    iterator.remove();
                    continue;
                }
                input.addLine(this.ess.getMail().getMailLine(mailObj));
                iterator.set(new MailMessage(true, mailObj.isLegacy(), mailObj.getSenderUsername(), mailObj.getSenderUUID(), mailObj.getTimeSent(), mailObj.getTimeExpire(), mailObj.getMessage()));
            }
            if (input.getLines().isEmpty()) {
                user.sendMessage(I18n.tl("noMail", new Object[0]));
                throw new NoChargeException();
            }
            TextPager pager = new TextPager(input);
            pager.showPage(args.length > 1 ? args[1] : null, null, commandLabel + " " + args[0], user.getSource());
            user.sendMessage(I18n.tl("mailClear", new Object[0]));
            user.setMailList(mail);
            return;
        }
        if (args.length >= 3 && "send".equalsIgnoreCase(args[0])) {
            User u;
            if (!user.isAuthorized("essentials.mail.send")) {
                throw new Exception(I18n.tl("noPerm", "essentials.mail.send"));
            }
            if (user.isMuted()) {
                String dateDiff;
                String string = dateDiff = user.getMuteTimeout() > 0L ? DateUtil.formatDateDiff(user.getMuteTimeout()) : null;
                if (dateDiff == null) {
                    throw new Exception(user.hasMuteReason() ? I18n.tl("voiceSilencedReason", user.getMuteReason()) : I18n.tl("voiceSilenced", new Object[0]));
                }
                throw new Exception(user.hasMuteReason() ? I18n.tl("voiceSilencedReasonTime", dateDiff, user.getMuteReason()) : I18n.tl("voiceSilencedTime", dateDiff));
            }
            try {
                u = this.getPlayer(server, args[1], true, true);
            }
            catch (PlayerNotFoundException e) {
                throw new Exception(I18n.tl("playerNeverOnServer", args[1]));
            }
            String msg = FormatUtil.formatMessage(user, "essentials.mail", StringUtil.sanitizeString(FormatUtil.stripFormat(Commandmail.getFinalArg(args, 2))));
            if (msg.length() > 1000) {
                throw new Exception(I18n.tl("mailTooLong", new Object[0]));
            }
            if (!u.isIgnoredPlayer(user)) {
                if (Math.abs(System.currentTimeMillis() - timestamp) > 60000L) {
                    timestamp = System.currentTimeMillis();
                    mailsPerMinute = 0;
                }
                if (++mailsPerMinute > this.ess.getSettings().getMailsPerMinute()) {
                    throw new Exception(I18n.tl("mailDelay", this.ess.getSettings().getMailsPerMinute()));
                }
                u.sendMail(user, msg);
            }
            user.sendMessage(I18n.tl("mailSentTo", u.getDisplayName(), u.getName()));
            user.sendMessage(msg);
            return;
        }
        if (args.length >= 4 && "sendtemp".equalsIgnoreCase(args[0])) {
            User u;
            if (!user.isAuthorized("essentials.mail.sendtemp")) {
                throw new Exception(I18n.tl("noPerm", "essentials.mail.sendtemp"));
            }
            if (user.isMuted()) {
                String dateDiff;
                String string = dateDiff = user.getMuteTimeout() > 0L ? DateUtil.formatDateDiff(user.getMuteTimeout()) : null;
                if (dateDiff == null) {
                    throw new Exception(user.hasMuteReason() ? I18n.tl("voiceSilencedReason", user.getMuteReason()) : I18n.tl("voiceSilenced", new Object[0]));
                }
                throw new Exception(user.hasMuteReason() ? I18n.tl("voiceSilencedReasonTime", dateDiff, user.getMuteReason()) : I18n.tl("voiceSilencedTime", dateDiff));
            }
            try {
                u = this.getPlayer(server, args[1], true, true);
            }
            catch (PlayerNotFoundException e) {
                throw new Exception(I18n.tl("playerNeverOnServer", args[1]));
            }
            long dateDiff = DateUtil.parseDateDiff(args[2], true);
            String msg = FormatUtil.formatMessage(user, "essentials.mail", StringUtil.sanitizeString(FormatUtil.stripFormat(Commandmail.getFinalArg(args, 3))));
            if (msg.length() > 1000) {
                throw new Exception(I18n.tl("mailTooLong", new Object[0]));
            }
            if (!u.isIgnoredPlayer(user)) {
                if (Math.abs(System.currentTimeMillis() - timestamp) > 60000L) {
                    timestamp = System.currentTimeMillis();
                    mailsPerMinute = 0;
                }
                if (++mailsPerMinute > this.ess.getSettings().getMailsPerMinute()) {
                    throw new Exception(I18n.tl("mailDelay", this.ess.getSettings().getMailsPerMinute()));
                }
                u.sendMail(user, msg, dateDiff);
            }
            user.sendMessage(I18n.tl("mailSentToExpire", u.getDisplayName(), DateUtil.formatDateDiff(dateDiff), u.getName()));
            user.sendMessage(msg);
            return;
        }
        if (args.length > 1 && "sendall".equalsIgnoreCase(args[0])) {
            if (!user.isAuthorized("essentials.mail.sendall")) {
                throw new Exception(I18n.tl("noPerm", "essentials.mail.sendall"));
            }
            this.ess.runTaskAsynchronously(new SendAll(user, FormatUtil.formatMessage(user, "essentials.mail", StringUtil.sanitizeString(FormatUtil.stripFormat(Commandmail.getFinalArg(args, 1)))), 0L));
            user.sendMessage(I18n.tl("mailSent", new Object[0]));
            return;
        }
        if (args.length >= 3 && "sendtempall".equalsIgnoreCase(args[0])) {
            if (!user.isAuthorized("essentials.mail.sendtempall")) {
                throw new Exception(I18n.tl("noPerm", "essentials.mail.sendtempall"));
            }
            this.ess.runTaskAsynchronously(new SendAll(user, FormatUtil.formatMessage(user, "essentials.mail", StringUtil.sanitizeString(FormatUtil.stripFormat(Commandmail.getFinalArg(args, 2)))), DateUtil.parseDateDiff(args[1], true)));
            user.sendMessage(I18n.tl("mailSent", new Object[0]));
            return;
        }
        if (args.length >= 1 && "clear".equalsIgnoreCase(args[0])) {
            ArrayList<MailMessage> mails = user.getMailMessages();
            if (mails == null || mails.size() == 0) {
                user.sendMessage(I18n.tl("noMail", new Object[0]));
                throw new NoChargeException();
            }
            if (args.length > 1) {
                if (!NumberUtil.isPositiveInt(args[1])) {
                    throw new NotEnoughArgumentsException();
                }
                int toRemove = Integer.parseInt(args[1]);
                if (toRemove > mails.size()) {
                    user.sendMessage(I18n.tl("mailClearIndex", mails.size()));
                    return;
                }
                mails.remove(toRemove - 1);
                user.setMailList(mails);
            } else {
                user.setMailList(null);
            }
            user.sendMessage(I18n.tl("mailCleared", new Object[0]));
            return;
        }
        throw new NotEnoughArgumentsException();
    }

    @Override
    protected void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        if (args.length >= 1 && "read".equalsIgnoreCase(args[0])) {
            throw new Exception(I18n.tl("onlyPlayers", commandLabel + " read"));
        }
        if (args.length >= 1 && "clear".equalsIgnoreCase(args[0])) {
            throw new Exception(I18n.tl("onlyPlayers", commandLabel + " clear"));
        }
        if (args.length >= 3 && "send".equalsIgnoreCase(args[0])) {
            User u;
            try {
                u = this.getPlayer(server, args[1], true, true);
            }
            catch (PlayerNotFoundException e) {
                throw new Exception(I18n.tl("playerNeverOnServer", args[1]));
            }
            u.sendMail(Console.getInstance(), FormatUtil.replaceFormat(Commandmail.getFinalArg(args, 2)));
            sender.sendMessage(I18n.tl("mailSent", new Object[0]));
            return;
        }
        if (args.length >= 4 && "sendtemp".equalsIgnoreCase(args[0])) {
            User u;
            try {
                u = this.getPlayer(server, args[1], true, true);
            }
            catch (PlayerNotFoundException e) {
                throw new Exception(I18n.tl("playerNeverOnServer", args[1]));
            }
            long dateDiff = DateUtil.parseDateDiff(args[2], true);
            u.sendMail(Console.getInstance(), FormatUtil.replaceFormat(Commandmail.getFinalArg(args, 3)), dateDiff);
            sender.sendMessage(I18n.tl("mailSent", new Object[0]));
            return;
        }
        if (args.length >= 2 && "sendall".equalsIgnoreCase(args[0])) {
            this.ess.runTaskAsynchronously(new SendAll(Console.getInstance(), FormatUtil.replaceFormat(Commandmail.getFinalArg(args, 1)), 0L));
            sender.sendMessage(I18n.tl("mailSent", new Object[0]));
            return;
        }
        if (args.length >= 3 && "sendtempall".equalsIgnoreCase(args[0])) {
            long dateDiff = DateUtil.parseDateDiff(args[1], true);
            this.ess.runTaskAsynchronously(new SendAll(Console.getInstance(), FormatUtil.replaceFormat(Commandmail.getFinalArg(args, 2)), dateDiff));
            sender.sendMessage(I18n.tl("mailSent", new Object[0]));
            return;
        }
        if (args.length >= 2) {
            User u;
            try {
                u = this.getPlayer(server, args[0], true, true);
            }
            catch (PlayerNotFoundException e) {
                throw new Exception(I18n.tl("playerNeverOnServer", args[0]));
            }
            u.sendMail(Console.getInstance(), FormatUtil.replaceFormat(Commandmail.getFinalArg(args, 1)));
            sender.sendMessage(I18n.tl("mailSent", new Object[0]));
            return;
        }
        throw new NotEnoughArgumentsException();
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, User user, String commandLabel, String[] args) {
        if (args.length == 1) {
            ArrayList options = Lists.newArrayList((Object[])new String[]{"read", "clear"});
            if (user.isAuthorized("essentials.mail.send")) {
                options.add("send");
            }
            if (user.isAuthorized("essentials.mail.sendtemp")) {
                options.add("sendtemp");
            }
            if (user.isAuthorized("essentials.mail.sendall")) {
                options.add("sendall");
            }
            if (user.isAuthorized("essentials.mail.sendtempall")) {
                options.add("sendtempall");
            }
            return options;
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("send") && user.isAuthorized("essentials.mail.send") || args[0].equalsIgnoreCase("sendtemp") && user.isAuthorized("essentials.mail.sendtemp")) {
                return this.getPlayers(server, user);
            }
            if (args[0].equalsIgnoreCase("sendtempall") && user.isAuthorized("essentials.mail.sendtempall")) {
                return COMMON_DATE_DIFFS;
            }
            if (args[0].equalsIgnoreCase("read")) {
                int pages;
                ArrayList<MailMessage> mail = user.getMailMessages();
                int n = mail != null ? mail.size() / 9 + (mail.size() % 9 > 0 ? 1 : 0) : (pages = 0);
                if (pages == 0) {
                    return Lists.newArrayList((Object[])new String[]{"0"});
                }
                ArrayList options = Lists.newArrayList((Object[])new String[]{"1"});
                if (pages > 1) {
                    options.add(String.valueOf(pages));
                }
                return options;
            }
        } else if (args.length == 3 && args[0].equalsIgnoreCase("sendtemp") && user.isAuthorized("essentials.mail.sendtemp")) {
            return COMMON_DATE_DIFFS;
        }
        return Collections.emptyList();
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1) {
            return Lists.newArrayList((Object[])new String[]{"send", "sendall", "sendtemp", "sendtempall"});
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("send") || args[0].equalsIgnoreCase("sendtemp")) {
                return this.getPlayers(server, sender);
            }
            if (args[0].equalsIgnoreCase("sendtempall")) {
                return COMMON_DATE_DIFFS;
            }
        } else if (args.length == 3 && args[0].equalsIgnoreCase("sendtemp")) {
            return COMMON_DATE_DIFFS;
        }
        return Collections.emptyList();
    }

    private class SendAll
    implements Runnable {
        private final IMessageRecipient messageRecipient;
        private final String message;
        private final long dateDiff;

        SendAll(IMessageRecipient messageRecipient, String message, long dateDiff) {
            this.messageRecipient = messageRecipient;
            this.message = message;
            this.dateDiff = dateDiff;
        }

        @Override
        public void run() {
            for (UUID userid : Commandmail.this.ess.getUserMap().getAllUniqueUsers()) {
                User user = Commandmail.this.ess.getUserMap().getUser(userid);
                if (user == null) continue;
                user.sendMail(this.messageRecipient, this.message, this.dateDiff);
            }
        }
    }
}

