/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.utils.NumberUtil;
import java.util.Locale;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.inventory.ItemStack;

public class Commandmore
extends EssentialsCommand {
    public Commandmore() {
        super("more");
    }

    @Override
    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        ItemStack stack = user.getItemInHand();
        if (stack == null || stack.getType() == Material.AIR) {
            throw new Exception(I18n.tl("cantSpawnItem", "Air"));
        }
        boolean canOversized = user.isAuthorized("essentials.oversizedstacks");
        if (stack.getAmount() >= (canOversized ? this.ess.getSettings().getOversizedStackSize() : stack.getMaxStackSize())) {
            throw new Exception(I18n.tl("fullStack", new Object[0]));
        }
        String itemname = stack.getType().toString().toLowerCase(Locale.ENGLISH).replace("_", "");
        if (!user.canSpawnItem(stack.getType()).booleanValue()) {
            throw new Exception(I18n.tl("cantSpawnItem", itemname));
        }
        int newStackSize = stack.getAmount();
        if (args.length >= 1) {
            if (!NumberUtil.isPositiveInt(args[0])) {
                throw new Exception(I18n.tl("nonZeroPosNumber", new Object[0]));
            }
            if ((newStackSize += Integer.parseInt(args[0])) > (canOversized ? this.ess.getSettings().getOversizedStackSize() : stack.getMaxStackSize())) {
                user.sendMessage(I18n.tl(canOversized ? "fullStackDefaultOversize" : "fullStackDefault", canOversized ? this.ess.getSettings().getOversizedStackSize() : stack.getMaxStackSize()));
                newStackSize = canOversized ? this.ess.getSettings().getOversizedStackSize() : stack.getMaxStackSize();
            }
        } else {
            newStackSize = canOversized ? this.ess.getSettings().getOversizedStackSize() : stack.getMaxStackSize();
        }
        stack.setAmount(newStackSize);
        user.getBase().updateInventory();
    }
}

