/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.UserMap;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.commands.PlayerNotFoundException;
import com.earth2me.essentials.craftbukkit.BanLookup;
import com.earth2me.essentials.utils.DateUtil;
import com.earth2me.essentials.utils.FormatUtil;
import com.earth2me.essentials.utils.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;

public class Commandseen
extends EssentialsCommand {
    public Commandseen() {
        super("seen");
    }

    @Override
    protected void run(final Server server, final CommandSource sender, final String commandLabel, final String[] args) throws Exception {
        User player;
        if (args.length < 1) {
            throw new NotEnoughArgumentsException();
        }
        final boolean showBan = sender.isAuthorized("essentials.seen.banreason", this.ess);
        final boolean showIp = sender.isAuthorized("essentials.seen.ip", this.ess);
        final boolean showLocation = sender.isAuthorized("essentials.seen.location", this.ess);
        final boolean searchAccounts = commandLabel.contains("alts") && sender.isAuthorized("essentials.seen.alts", this.ess);
        try {
            UUID uuid = UUID.fromString(args[0]);
            player = this.ess.getUser(uuid);
        }
        catch (IllegalArgumentException ignored) {
            player = this.ess.getOfflineUser(args[0]);
        }
        if (player == null) {
            if (!searchAccounts) {
                if (sender.isAuthorized("essentials.seen.ipsearch", this.ess) && FormatUtil.validIP(args[0])) {
                    if (this.ess.getServer().getBanList(BanList.Type.IP).isBanned(args[0])) {
                        sender.sendMessage(I18n.tl("isIpBanned", args[0]));
                    }
                    this.seenIP(sender, args[0], args[0]);
                    return;
                }
                if (this.ess.getServer().getBanList(BanList.Type.IP).isBanned(args[0])) {
                    sender.sendMessage(I18n.tl("isIpBanned", args[0]));
                    return;
                }
                if (BanLookup.isBanned(this.ess, args[0]).booleanValue()) {
                    sender.sendMessage(I18n.tl("whoisBanned", showBan ? BanLookup.getBanEntry(this.ess, args[0]).getReason() : I18n.tl("true", new Object[0])));
                    return;
                }
            }
            this.ess.getScheduler().runTaskAsynchronously((Plugin)this.ess, new Runnable(){

                @Override
                public void run() {
                    block5: {
                        User userFromBukkit = Commandseen.this.ess.getUserMap().getUserFromBukkit(args[0]);
                        try {
                            if (userFromBukkit != null) {
                                this.showUserSeen(userFromBukkit);
                                break block5;
                            }
                            try {
                                this.showUserSeen(Commandseen.this.getPlayer(server, sender, args, 0));
                            }
                            catch (PlayerNotFoundException e) {
                                throw new Exception(I18n.tl("playerNeverOnServer", args[0]));
                            }
                        }
                        catch (Exception e) {
                            Commandseen.this.ess.showError(sender, e, commandLabel);
                        }
                    }
                }

                private void showUserSeen(User user) throws Exception {
                    Commandseen.this.showSeenMessage(sender, user, searchAccounts, showBan, showIp, showLocation);
                }
            });
        } else {
            this.showSeenMessage(sender, player, searchAccounts, showBan, showIp, showLocation);
        }
    }

    private void showSeenMessage(CommandSource sender, User player, boolean searchAccounts, boolean showBan, boolean showIp, boolean showLocation) {
        if (searchAccounts) {
            this.seenIP(sender, player.getLastLoginAddress(), player.getDisplayName());
        } else if (player.getBase().isOnline() && this.canInteractWith(sender, player)) {
            this.seenOnline(sender, player, showIp);
        } else {
            this.seenOffline(sender, player, showBan, showIp, showLocation);
        }
    }

    private void seenOnline(CommandSource sender, User user, boolean showIp) {
        String location;
        user.setDisplayNick();
        sender.sendMessage(I18n.tl("seenOnline", user.getDisplayName(), DateUtil.formatDateDiff(user.getLastLogin())));
        List<String> history = this.ess.getUserMap().getUserHistory(user.getBase().getUniqueId());
        if (history != null && history.size() > 1) {
            sender.sendMessage(I18n.tl("seenAccounts", StringUtil.joinListSkip(", ", user.getName(), history)));
        }
        if (sender.isAuthorized("essentials.seen.uuid", this.ess)) {
            sender.sendMessage(I18n.tl("whoisUuid", user.getBase().getUniqueId().toString()));
        }
        if (user.isAfk()) {
            sender.sendMessage(I18n.tl("whoisAFK", I18n.tl("true", new Object[0])));
        }
        if (user.isJailed()) {
            sender.sendMessage(I18n.tl("whoisJail", user.getJailTimeout() > 0L ? user.getFormattedJailTime() : I18n.tl("true", new Object[0])));
        }
        if (user.isMuted()) {
            long muteTimeout = user.getMuteTimeout();
            if (!user.hasMuteReason()) {
                sender.sendMessage(I18n.tl("whoisMuted", muteTimeout > 0L ? DateUtil.formatDateDiff(muteTimeout) : I18n.tl("true", new Object[0])));
            } else {
                sender.sendMessage(I18n.tl("whoisMutedReason", muteTimeout > 0L ? DateUtil.formatDateDiff(muteTimeout) : I18n.tl("true", new Object[0]), user.getMuteReason()));
            }
        }
        if ((location = user.getGeoLocation()) != null && (!sender.isPlayer() || this.ess.getUser(sender.getPlayer()).isAuthorized("essentials.geoip.show"))) {
            sender.sendMessage(I18n.tl("whoisGeoLocation", location));
        }
        if (showIp) {
            sender.sendMessage(I18n.tl("whoisIPAddress", user.getBase().getAddress().getAddress().toString()));
        }
    }

    private void seenOffline(CommandSource sender, User user, boolean showBan, boolean showIp, boolean showLocation) {
        Location loc;
        String location;
        user.setDisplayNick();
        if (user.getLastLogout() > 0L) {
            sender.sendMessage(I18n.tl("seenOffline", user.getName(), DateUtil.formatDateDiff(user.getLastLogout())));
            List<String> history = this.ess.getUserMap().getUserHistory(user.getBase().getUniqueId());
            if (history != null && history.size() > 1) {
                sender.sendMessage(I18n.tl("seenAccounts", StringUtil.joinListSkip(", ", user.getName(), history)));
            }
            if (sender.isAuthorized("essentials.seen.uuid", this.ess)) {
                sender.sendMessage(I18n.tl("whoisUuid", user.getBase().getUniqueId()));
            }
        } else {
            sender.sendMessage(I18n.tl("userUnknown", user.getName()));
        }
        if (BanLookup.isBanned(this.ess, user).booleanValue()) {
            BanEntry banEntry = BanLookup.getBanEntry(this.ess, user.getName());
            String reason = showBan ? banEntry.getReason() : I18n.tl("true", new Object[0]);
            sender.sendMessage(I18n.tl("whoisBanned", reason));
            if (banEntry.getExpiration() != null) {
                Date expiry = banEntry.getExpiration();
                String expireString = I18n.tl("now", new Object[0]);
                if (expiry.after(new Date())) {
                    expireString = DateUtil.formatDateDiff(expiry.getTime());
                }
                sender.sendMessage(I18n.tl("whoisTempBanned", expireString));
            }
        }
        if (user.isMuted()) {
            long muteTimeout = user.getMuteTimeout();
            if (!user.hasMuteReason()) {
                sender.sendMessage(I18n.tl("whoisMuted", muteTimeout > 0L ? DateUtil.formatDateDiff(muteTimeout) : I18n.tl("true", new Object[0])));
            } else {
                sender.sendMessage(I18n.tl("whoisMutedReason", muteTimeout > 0L ? DateUtil.formatDateDiff(muteTimeout) : I18n.tl("true", new Object[0]), user.getMuteReason()));
            }
        }
        if ((location = user.getGeoLocation()) != null && (!sender.isPlayer() || this.ess.getUser(sender.getPlayer()).isAuthorized("essentials.geoip.show"))) {
            sender.sendMessage(I18n.tl("whoisGeoLocation", location));
        }
        if (showIp && !user.getLastLoginAddress().isEmpty()) {
            sender.sendMessage(I18n.tl("whoisIPAddress", user.getLastLoginAddress()));
        }
        if (showLocation && (loc = user.getLogoutLocation()) != null) {
            sender.sendMessage(I18n.tl("whoisLocation", loc.getWorld().getName(), loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()));
        }
    }

    private void seenIP(CommandSource sender, String ipAddress, String display) {
        UserMap userMap = this.ess.getUserMap();
        sender.sendMessage(I18n.tl("runningPlayerMatch", display));
        this.ess.runTaskAsynchronously(() -> {
            ArrayList<String> matches = new ArrayList<String>();
            for (UUID u : userMap.getAllUniqueUsers()) {
                String uIPAddress;
                User user = this.ess.getUserMap().getUser(u);
                if (user == null || (uIPAddress = user.getLastLoginAddress()).isEmpty() || !uIPAddress.equalsIgnoreCase(ipAddress)) continue;
                matches.add(user.getName());
            }
            if (matches.size() > 0) {
                sender.sendMessage(I18n.tl("matchingIPAddress", new Object[0]));
                sender.sendMessage(StringUtil.joinList(matches));
            } else {
                sender.sendMessage(I18n.tl("noMatchingPlayers", new Object[0]));
            }
        });
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1) {
            return this.getPlayers(server, sender);
        }
        return Collections.emptyList();
    }
}

