/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.PlayerNotFoundException;
import com.earth2me.essentials.utils.LocationUtil;
import com.earth2me.essentials.utils.NumberUtil;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.bukkit.Location;
import org.bukkit.Server;

public class Commandsethome
extends EssentialsCommand {
    public Commandsethome() {
        super("sethome");
    }

    @Override
    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        User usersHome = user;
        String name = "home";
        if (args.length > 0) {
            String[] nameParts = args[0].split(":");
            if (nameParts[0].length() != args[0].length()) {
                args = nameParts;
            }
            if (args.length < 2) {
                name = args[0].toLowerCase(Locale.ENGLISH);
            } else {
                name = args[1].toLowerCase(Locale.ENGLISH);
                if (user.isAuthorized("essentials.sethome.others") && (usersHome = this.getPlayer(server, args[0], true, true)) == null) {
                    throw new PlayerNotFoundException();
                }
            }
        }
        if (this.checkHomeLimit(user, usersHome, name)) {
            name = "home";
        }
        if ("bed".equals(name) || NumberUtil.isInt(name)) {
            throw new NoSuchFieldException(I18n.tl("invalidHomeName", new Object[0]));
        }
        Location location = user.getLocation();
        if (!(this.ess.getSettings().isTeleportSafetyEnabled() && this.ess.getSettings().isForceDisableTeleportSafety() || !LocationUtil.isBlockUnsafeForUser(this.ess, usersHome, location.getWorld(), location.getBlockX(), location.getBlockY(), location.getBlockZ()))) {
            throw new Exception(I18n.tl("unsafeTeleportDestination", location.getWorld().getName(), location.getBlockX(), location.getBlockY(), location.getBlockZ()));
        }
        if (this.ess.getSettings().isConfirmHomeOverwrite() && usersHome.hasHome(name) && (!name.equals(usersHome.getLastHomeConfirmation()) || name.equals(usersHome.getLastHomeConfirmation()) && System.currentTimeMillis() - usersHome.getLastHomeConfirmationTimestamp() > TimeUnit.MINUTES.toMillis(2L))) {
            usersHome.setLastHomeConfirmation(name);
            usersHome.setLastHomeConfirmationTimestamp();
            user.sendMessage(I18n.tl("homeConfirmation", name));
            return;
        }
        usersHome.setHome(name, location);
        user.sendMessage(I18n.tl("homeSet", user.getLocation().getWorld().getName(), user.getLocation().getBlockX(), user.getLocation().getBlockY(), user.getLocation().getBlockZ(), name));
        usersHome.setLastHomeConfirmation(null);
    }

    private boolean checkHomeLimit(User user, User usersHome, String name) throws Exception {
        if (!user.isAuthorized("essentials.sethome.multiple.unlimited")) {
            int limit = this.ess.getSettings().getHomeLimit(user);
            if (usersHome.getHomes().size() >= limit) {
                if (usersHome.getHomes().contains(name)) {
                    return false;
                }
                throw new Exception(I18n.tl("maxHomes", this.ess.getSettings().getHomeLimit(user)));
            }
            return limit == 1;
        }
        return false;
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        return Collections.emptyList();
    }
}

