/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.Console;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.utils.DateUtil;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.BanList;
import org.bukkit.Server;

public class Commandtempban
extends EssentialsCommand {
    public Commandtempban() {
        super("tempban");
    }

    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        if (args.length < 2) {
            throw new NotEnoughArgumentsException();
        }
        User user = this.getPlayer(server, args, 0, true, true);
        if (!user.getBase().isOnline() && sender.isPlayer() && !this.ess.getUser(sender.getPlayer()).isAuthorized("essentials.tempban.offline")) {
            sender.sendMessage(I18n.tl("tempbanExemptOffline", new Object[0]));
            return;
        }
        if (user.isAuthorized("essentials.tempban.exempt") && sender.isPlayer()) {
            sender.sendMessage(I18n.tl("tempbanExempt", new Object[0]));
            return;
        }
        String time = Commandtempban.getFinalArg(args, 1);
        long banTimestamp = DateUtil.parseDateDiff(time, true);
        String banReason = DateUtil.removeTimePattern(time);
        long maxBanLength = this.ess.getSettings().getMaxTempban() * 1000L;
        if (maxBanLength > 0L && banTimestamp - GregorianCalendar.getInstance().getTimeInMillis() > maxBanLength && sender.isPlayer() && !this.ess.getUser(sender.getPlayer()).isAuthorized("essentials.tempban.unlimited")) {
            sender.sendMessage(I18n.tl("oversizedTempban", new Object[0]));
            return;
        }
        if (banReason.length() < 2) {
            banReason = I18n.tl("defaultBanReason", new Object[0]);
        }
        String senderName = sender.isPlayer() ? sender.getPlayer().getDisplayName() : "Console";
        String senderDisplayName = sender.isPlayer() ? sender.getPlayer().getDisplayName() : Console.DISPLAY_NAME;
        this.ess.getServer().getBanList(BanList.Type.NAME).addBan(user.getName(), banReason, new Date(banTimestamp), senderName);
        String expiry = DateUtil.formatDateDiff(banTimestamp);
        user.getBase().kickPlayer(I18n.tl("tempBanned", expiry, senderDisplayName, banReason));
        String message = I18n.tl("playerTempBanned", senderDisplayName, user.getName(), expiry, banReason);
        server.getLogger().log(Level.INFO, message);
        this.ess.broadcastMessage("essentials.ban.notify", message);
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1) {
            return this.getPlayers(server, sender);
        }
        return COMMON_DATE_DIFFS;
    }
}

