/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.AsyncTeleport;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.IUser;
import com.earth2me.essentials.Trade;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NoChargeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.ess3.api.IUser;
import net.essentialsx.api.v2.events.TeleportRequestResponseEvent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerTeleportEvent;

public class Commandtpaccept
extends EssentialsCommand {
    public Commandtpaccept() {
        super("tpaccept");
    }

    @Override
    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        boolean acceptAll = args.length > 0 ? args[0].equals("*") || args[0].equalsIgnoreCase("all") : false;
        if (!user.hasPendingTpaRequests(true, acceptAll)) {
            throw new Exception(I18n.tl("noPendingRequest", new Object[0]));
        }
        if (args.length > 0) {
            if (acceptAll) {
                this.acceptAllRequests(user, commandLabel);
                throw new NoChargeException();
            }
            user.sendMessage(I18n.tl("requestAccepted", new Object[0]));
            this.handleTeleport(user, user.getOutstandingTpaRequest(this.getPlayer(server, user, args, 0).getName(), true), commandLabel);
        } else {
            user.sendMessage(I18n.tl("requestAccepted", new Object[0]));
            this.handleTeleport(user, user.getNextTpaRequest(true, false, false), commandLabel);
        }
        throw new NoChargeException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acceptAllRequests(User user, String commandLabel) throws Exception {
        IUser.TpaRequest request;
        int count = 0;
        while ((request = user.getNextTpaRequest(true, true, true)) != null) {
            try {
                this.handleTeleport(user, request, commandLabel);
                ++count;
            }
            catch (Exception e) {
                this.ess.showError(user.getSource(), e, commandLabel);
            }
            finally {
                user.removeTpaRequest(request.getName());
            }
        }
        user.sendMessage(I18n.tl("requestAcceptedAll", count));
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, User user, String commandLabel, String[] args) {
        if (args.length == 1) {
            ArrayList<String> options = new ArrayList<String>(user.getPendingTpaKeys());
            options.add("*");
            return options;
        }
        return Collections.emptyList();
    }

    private void handleTeleport(User user, IUser.TpaRequest request, String commandLabel) throws Exception {
        if (request == null) {
            throw new Exception(I18n.tl("noPendingRequest", new Object[0]));
        }
        User requester = this.ess.getUser(request.getRequesterUuid());
        if (!requester.getBase().isOnline()) {
            user.removeTpaRequest(request.getName());
            throw new Exception(I18n.tl("noPendingRequest", new Object[0]));
        }
        if (request.isHere() && (!requester.isAuthorized("essentials.tpahere") && !requester.isAuthorized("essentials.tpaall") || user.getWorld() != requester.getWorld() && this.ess.getSettings().isWorldTeleportPermissions() && !user.isAuthorized("essentials.worlds." + user.getWorld().getName()))) {
            throw new Exception(I18n.tl("noPendingRequest", new Object[0]));
        }
        if (!request.isHere() && (!requester.isAuthorized("essentials.tpa") || user.getWorld() != requester.getWorld() && this.ess.getSettings().isWorldTeleportPermissions() && !user.isAuthorized("essentials.worlds." + requester.getWorld().getName()))) {
            throw new Exception(I18n.tl("noPendingRequest", new Object[0]));
        }
        TeleportRequestResponseEvent event = new TeleportRequestResponseEvent(user, requester, request, true);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            if (this.ess.getSettings().isDebug()) {
                logger.info("TPA accept cancelled by API for " + user.getName() + " (requested by " + requester.getName() + ")");
            }
            return;
        }
        Trade charge = new Trade(this.getName(), this.ess);
        requester.sendMessage(I18n.tl("requestAcceptedFrom", user.getDisplayName()));
        CompletableFuture<Boolean> future = this.getNewExceptionFuture(requester.getSource(), commandLabel);
        future.exceptionally(e -> {
            user.sendMessage(I18n.tl("pendingTeleportCancelled", new Object[0]));
            return false;
        });
        if (request.isHere()) {
            Location loc = request.getLocation();
            AsyncTeleport teleport = requester.getAsyncTeleport();
            teleport.setTpType(AsyncTeleport.TeleportType.TPA);
            future.thenAccept(success -> {
                if (success.booleanValue()) {
                    requester.sendMessage(I18n.tl("teleporting", loc.getWorld().getName(), loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()));
                }
            });
            teleport.teleportPlayer((IUser)user, loc, charge, PlayerTeleportEvent.TeleportCause.COMMAND, future);
        } else {
            AsyncTeleport teleport = requester.getAsyncTeleport();
            teleport.setTpType(AsyncTeleport.TeleportType.TPA);
            teleport.teleport(user.getBase(), charge, PlayerTeleportEvent.TeleportCause.COMMAND, future);
        }
        user.removeTpaRequest(request.getName());
    }
}

