/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.IEssentialsModule;
import com.earth2me.essentials.Trade;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.IEssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.commands.PlayerNotFoundException;
import com.earth2me.essentials.utils.FormatUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.ess3.api.IEssentials;
import org.bukkit.ChatColor;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.PluginIdentifiableCommand;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.StringUtil;

public abstract class EssentialsCommand
implements IEssentialsCommand {
    protected static final Logger logger = Logger.getLogger("Essentials");
    protected static final List<String> COMMON_DURATIONS = ImmutableList.of((Object)"1", (Object)"60", (Object)"600", (Object)"3600", (Object)"86400");
    protected static final List<String> COMMON_DATE_DIFFS = ImmutableList.of((Object)"1m", (Object)"15m", (Object)"1h", (Object)"3h", (Object)"12h", (Object)"1d", (Object)"1w", (Object)"1mo", (Object)"1y");
    private static final Pattern ARGUMENT_PATTERN = Pattern.compile("([ :>])(([\\[<])[A-Za-z |]+[>\\]])");
    private final transient String name;
    private final transient Map<String, String> usageStrings = new LinkedHashMap<String, String>();
    protected transient IEssentials ess;
    protected transient IEssentialsModule module;

    protected EssentialsCommand(String name) {
        this.name = name;
        int i = 1;
        try {
            while (true) {
                String baseKey = name + "CommandUsage" + i;
                this.addUsageString(I18n.tl(baseKey, new Object[0]), I18n.tl(baseKey + "Description", new Object[0]));
                ++i;
            }
        }
        catch (MissingResourceException missingResourceException) {
            return;
        }
    }

    private void addUsageString(String usage, String description) {
        StringBuffer buffer = new StringBuffer();
        Matcher matcher = ARGUMENT_PATTERN.matcher(usage);
        while (matcher.find()) {
            String color = matcher.group(3).equals("<") ? I18n.tl("commandArgumentRequired", new Object[0]) : I18n.tl("commandArgumentOptional", new Object[0]);
            matcher.appendReplacement(buffer, "$1" + color + matcher.group(2).replace("|", I18n.tl("commandArgumentOr", new Object[0]) + "|" + color) + ChatColor.RESET);
        }
        matcher.appendTail(buffer);
        this.usageStrings.put(buffer.toString(), description);
    }

    @Override
    public Map<String, String> getUsageStrings() {
        return this.usageStrings;
    }

    public static String getFinalArg(String[] args, int start) {
        StringBuilder bldr = new StringBuilder();
        for (int i = start; i < args.length; ++i) {
            if (i != start) {
                bldr.append(" ");
            }
            bldr.append(args[i]);
        }
        return bldr.toString();
    }

    private boolean canInteractWith(User interactor, User interactee) {
        return this.ess.canInteractWith(interactor, interactee);
    }

    @Override
    public void setEssentials(IEssentials ess) {
        this.ess = ess;
    }

    @Override
    public void setEssentialsModule(IEssentialsModule module) {
        this.module = module;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected User getPlayer(Server server, CommandSource sender, String[] args, int pos) throws PlayerNotFoundException, NotEnoughArgumentsException {
        return this.getPlayer(server, sender, args, pos, false);
    }

    protected User getPlayer(Server server, CommandSource sender, String[] args, int pos, boolean getOffline) throws PlayerNotFoundException, NotEnoughArgumentsException {
        if (sender.isPlayer()) {
            User user = this.ess.getUser(sender.getPlayer());
            return this.getPlayer(server, user, args, pos, getOffline);
        }
        return this.getPlayer(server, args, pos, true, getOffline);
    }

    protected User getPlayer(Server server, CommandSource sender, String searchTerm) throws PlayerNotFoundException, NotEnoughArgumentsException {
        if (sender.isPlayer()) {
            User user = this.ess.getUser(sender.getPlayer());
            return this.getPlayer(server, user, searchTerm, user.canInteractVanished(), false);
        }
        return this.getPlayer(server, searchTerm, true, false);
    }

    protected User getPlayer(Server server, User user, String[] args, int pos) throws PlayerNotFoundException, NotEnoughArgumentsException {
        return this.getPlayer(server, user, args, pos, false);
    }

    protected User getPlayer(Server server, User user, String[] args, int pos, boolean getOffline) throws PlayerNotFoundException, NotEnoughArgumentsException {
        return this.getPlayer(server, user, args, pos, user.canInteractVanished(), getOffline);
    }

    protected User getPlayer(Server server, String[] args, int pos, boolean getHidden, boolean getOffline) throws PlayerNotFoundException, NotEnoughArgumentsException {
        return this.getPlayer(server, null, args, pos, getHidden, getOffline);
    }

    User getPlayer(Server server, User sourceUser, String[] args, int pos, boolean getHidden, boolean getOffline) throws PlayerNotFoundException, NotEnoughArgumentsException {
        if (args.length <= pos) {
            throw new NotEnoughArgumentsException();
        }
        if (args[pos].isEmpty()) {
            throw new PlayerNotFoundException();
        }
        return this.getPlayer(server, sourceUser, args[pos], getHidden, getOffline);
    }

    protected User getPlayer(Server server, String searchTerm, boolean getHidden, boolean getOffline) throws PlayerNotFoundException {
        return this.getPlayer(server, null, searchTerm, getHidden, getOffline);
    }

    private User getPlayer(Server server, User sourceUser, String searchTerm, boolean getHidden, boolean getOffline) throws PlayerNotFoundException {
        return this.ess.matchUser(server, sourceUser, searchTerm, getHidden, getOffline);
    }

    @Override
    public final void run(Server server, User user, String commandLabel, Command cmd, String[] args) throws Exception {
        Trade charge = new Trade(this.getName(), this.ess);
        charge.isAffordableFor(user);
        this.run(server, user, commandLabel, args);
        charge.charge(user);
    }

    protected void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        this.run(server, user.getSource(), commandLabel, args);
    }

    @Override
    public final void run(Server server, CommandSource sender, String commandLabel, Command cmd, String[] args) throws Exception {
        this.run(server, sender, commandLabel, args);
    }

    protected void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        throw new Exception(I18n.tl("onlyPlayers", commandLabel));
    }

    @Override
    public final List<String> tabComplete(Server server, User user, String commandLabel, Command cmd, String[] args) {
        if (args.length == 0) {
            return Collections.emptyList();
        }
        List<String> options = this.getTabCompleteOptions(server, user, commandLabel, args);
        if (options == null) {
            return null;
        }
        return (List)StringUtil.copyPartialMatches((String)args[args.length - 1], options, (Collection)Lists.newArrayList());
    }

    protected List<String> getTabCompleteOptions(Server server, User user, String commandLabel, String[] args) {
        return this.getTabCompleteOptions(server, user.getSource(), commandLabel, args);
    }

    @Override
    public final List<String> tabComplete(Server server, CommandSource sender, String commandLabel, Command cmd, String[] args) {
        if (args.length == 0) {
            return Collections.emptyList();
        }
        List<String> options = this.getTabCompleteOptions(server, sender, commandLabel, args);
        if (options == null) {
            return null;
        }
        return (List)StringUtil.copyPartialMatches((String)args[args.length - 1], options, (Collection)Lists.newArrayList());
    }

    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        return this.getPlayers(server, sender);
    }

    boolean canInteractWith(CommandSource interactor, User interactee) {
        return this.ess.canInteractWith(interactor, interactee);
    }

    protected List<String> getPlayers(Server server, CommandSource interactor) {
        ArrayList players = Lists.newArrayList();
        for (User user : this.ess.getOnlineUsers()) {
            if (!this.canInteractWith(interactor, user)) continue;
            players.add(this.ess.getSettings().changeTabCompleteName() ? FormatUtil.stripFormat(user.getDisplayName()) : user.getName());
        }
        return players;
    }

    protected List<String> getPlayers(Server server, User interactor) {
        ArrayList players = Lists.newArrayList();
        for (User user : this.ess.getOnlineUsers()) {
            if (!this.canInteractWith(interactor, user)) continue;
            players.add(this.ess.getSettings().changeTabCompleteName() ? FormatUtil.stripFormat(user.getDisplayName()) : user.getName());
        }
        return players;
    }

    protected List<String> getItems() {
        return new ArrayList<String>(this.ess.getItemDb().listNames());
    }

    protected List<String> getMatchingItems(String arg) {
        ArrayList items = Lists.newArrayList((Object[])new String[]{"hand", "inventory", "blocks"});
        if (!arg.isEmpty()) {
            items.addAll(this.getItems());
        }
        return items;
    }

    protected final List<String> getCommands(Server server) {
        HashMap commandMap = Maps.newHashMap(this.ess.getKnownCommandsProvider().getKnownCommands());
        ArrayList commands = Lists.newArrayListWithCapacity((int)commandMap.size());
        for (Command command : commandMap.values()) {
            if (!(command instanceof PluginIdentifiableCommand)) continue;
            commands.add(command.getName());
        }
        return commands;
    }

    protected final List<String> getPlugins(Server server) {
        ArrayList plugins = Lists.newArrayList();
        for (Plugin p : server.getPluginManager().getPlugins()) {
            plugins.add(p.getName());
        }
        return plugins;
    }

    protected final List<String> tabCompleteCommand(CommandSource sender, Server server, String label, String[] args, int index) {
        PluginCommand command = server.getPluginCommand(label);
        if (command == null) {
            return Collections.emptyList();
        }
        int numArgs = args.length - index - 1;
        if (this.ess.getSettings().isDebug()) {
            this.ess.getLogger().info(numArgs + " " + index + " " + Arrays.toString(args));
        }
        Object[] effectiveArgs = new String[numArgs];
        System.arraycopy(args, index, effectiveArgs, 0, numArgs);
        if (effectiveArgs.length == 0) {
            effectiveArgs = new String[]{""};
        }
        if (this.ess.getSettings().isDebug()) {
            this.ess.getLogger().info(command + " -- " + Arrays.toString(effectiveArgs));
        }
        return command.tabComplete(sender.getSender(), label, (String[])effectiveArgs);
    }

    @Override
    public void showError(CommandSender sender, Throwable throwable, String commandLabel) {
        sender.sendMessage(I18n.tl("errorWithMessage", throwable.getMessage()));
        if (this.ess.getSettings().isDebug()) {
            logger.log(Level.INFO, I18n.tl("errorCallingCommand", commandLabel), throwable);
            throwable.printStackTrace();
        }
    }

    public CompletableFuture<Boolean> getNewExceptionFuture(CommandSource sender, String commandLabel) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        future.exceptionally(e -> {
            this.showError(sender.getSender(), (Throwable)e, commandLabel);
            return false;
        });
        return future;
    }
}

