/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.ChargeException;
import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.commands.PlayerExemptException;
import com.earth2me.essentials.commands.PlayerNotFoundException;
import com.earth2me.essentials.utils.FormatUtil;
import com.earth2me.essentials.utils.StringUtil;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.ess3.api.MaxMoneyException;
import org.bukkit.Server;
import org.bukkit.entity.Player;

public abstract class EssentialsLoopCommand
extends EssentialsCommand {
    public EssentialsLoopCommand(String command) {
        super(command);
    }

    protected void loopOfflinePlayers(Server server, CommandSource sender, boolean multipleStringMatches, boolean matchWildcards, String searchTerm, String[] commandArgs) throws PlayerNotFoundException, NotEnoughArgumentsException, PlayerExemptException, ChargeException, MaxMoneyException {
        this.loopOfflinePlayersConsumer(server, sender, multipleStringMatches, matchWildcards, searchTerm, user -> this.updatePlayer(server, sender, user, commandArgs));
    }

    protected void loopOfflinePlayersConsumer(Server server, CommandSource sender, boolean multipleStringMatches, boolean matchWildcards, String searchTerm, UserConsumer userConsumer) throws PlayerNotFoundException, NotEnoughArgumentsException, PlayerExemptException, ChargeException, MaxMoneyException {
        if (searchTerm.isEmpty()) {
            throw new PlayerNotFoundException();
        }
        UUID uuid = StringUtil.toUUID(searchTerm);
        if (uuid != null) {
            User matchedUser = this.ess.getUser(uuid);
            userConsumer.accept(matchedUser);
        } else if (matchWildcards && searchTerm.contentEquals("**")) {
            for (UUID sUser : this.ess.getUserMap().getAllUniqueUsers()) {
                User matchedUser = this.ess.getUser(sUser);
                userConsumer.accept(matchedUser);
            }
        } else if (matchWildcards && searchTerm.contentEquals("*")) {
            boolean skipHidden = sender.isPlayer() && !this.ess.getUser(sender.getPlayer()).canInteractVanished();
            for (User onlineUser : this.ess.getOnlineUsers()) {
                if (skipHidden && onlineUser.isHidden(sender.getPlayer()) && !sender.getPlayer().canSee(onlineUser.getBase())) continue;
                userConsumer.accept(onlineUser);
            }
        } else if (multipleStringMatches) {
            if (searchTerm.trim().length() < 3) {
                throw new PlayerNotFoundException();
            }
            List matchedPlayers = server.matchPlayer(searchTerm);
            if (matchedPlayers.isEmpty()) {
                User matchedUser = this.getPlayer(server, searchTerm, true, true);
                userConsumer.accept(matchedUser);
            }
            for (Player matchPlayer : matchedPlayers) {
                User matchedUser = this.ess.getUser(matchPlayer);
                userConsumer.accept(matchedUser);
            }
        } else {
            User user = this.getPlayer(server, searchTerm, true, true);
            userConsumer.accept(user);
        }
    }

    protected void loopOnlinePlayers(Server server, CommandSource sender, boolean multipleStringMatches, boolean matchWildcards, String searchTerm, String[] commandArgs) throws PlayerNotFoundException, NotEnoughArgumentsException, PlayerExemptException, ChargeException, MaxMoneyException {
        this.loopOnlinePlayersConsumer(server, sender, multipleStringMatches, matchWildcards, searchTerm, user -> this.updatePlayer(server, sender, user, commandArgs));
    }

    protected void loopOnlinePlayersConsumer(Server server, CommandSource sender, boolean multipleStringMatches, boolean matchWildcards, String searchTerm, UserConsumer userConsumer) throws PlayerNotFoundException, NotEnoughArgumentsException, PlayerExemptException, ChargeException, MaxMoneyException {
        boolean skipHidden;
        if (searchTerm.isEmpty()) {
            throw new PlayerNotFoundException();
        }
        boolean bl = skipHidden = sender.isPlayer() && !this.ess.getUser(sender.getPlayer()).canInteractVanished();
        if (matchWildcards && (searchTerm.contentEquals("**") || searchTerm.contentEquals("*"))) {
            for (User onlineUser : this.ess.getOnlineUsers()) {
                if (skipHidden && onlineUser.isHidden(sender.getPlayer()) && !sender.getPlayer().canSee(onlineUser.getBase())) continue;
                userConsumer.accept(onlineUser);
            }
        } else if (multipleStringMatches) {
            if (searchTerm.trim().length() < 2) {
                throw new PlayerNotFoundException();
            }
            boolean foundUser = false;
            List matchedPlayers = server.matchPlayer(searchTerm);
            if (matchedPlayers.isEmpty()) {
                String matchText = searchTerm.toLowerCase(Locale.ENGLISH);
                for (User player : this.ess.getOnlineUsers()) {
                    String displayName;
                    if (skipHidden && player.isHidden(sender.getPlayer()) && !sender.getPlayer().canSee(player.getBase()) || !(displayName = FormatUtil.stripFormat(player.getDisplayName()).toLowerCase(Locale.ENGLISH)).contains(matchText)) continue;
                    foundUser = true;
                    userConsumer.accept(player);
                }
            } else {
                for (Player matchPlayer : matchedPlayers) {
                    User player = this.ess.getUser(matchPlayer);
                    if (skipHidden && player.isHidden(sender.getPlayer()) && !sender.getPlayer().canSee(matchPlayer)) continue;
                    foundUser = true;
                    userConsumer.accept(player);
                }
            }
            if (!foundUser) {
                throw new PlayerNotFoundException();
            }
        } else {
            User player = this.getPlayer(server, sender, searchTerm);
            userConsumer.accept(player);
        }
    }

    protected abstract void updatePlayer(Server var1, CommandSource var2, User var3, String[] var4) throws NotEnoughArgumentsException, PlayerExemptException, ChargeException, MaxMoneyException;

    @Override
    protected List<String> getPlayers(Server server, CommandSource interactor) {
        List<String> players = super.getPlayers(server, interactor);
        players.add("**");
        players.add("*");
        return players;
    }

    @Override
    protected List<String> getPlayers(Server server, User interactor) {
        List<String> players = super.getPlayers(server, interactor);
        players.add("**");
        players.add("*");
        return players;
    }

    public static interface UserConsumer {
        public void accept(User var1) throws PlayerNotFoundException, NotEnoughArgumentsException, PlayerExemptException, ChargeException, MaxMoneyException;
    }
}

