/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.config;

import com.earth2me.essentials.config.EssentialsConfiguration;
import com.earth2me.essentials.libs.configurate.CommentedConfigurationNode;
import com.earth2me.essentials.libs.configurate.ConfigurateException;
import com.earth2me.essentials.libs.configurate.yaml.YamlConfigurationLoader;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public class ConfigurationSaveTask
implements Runnable {
    private final YamlConfigurationLoader loader;
    private final CommentedConfigurationNode node;
    private final AtomicInteger pendingWrites;

    public ConfigurationSaveTask(YamlConfigurationLoader loader, CommentedConfigurationNode node, AtomicInteger pendingWrites) {
        this.loader = loader;
        this.node = node;
        this.pendingWrites = pendingWrites;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        YamlConfigurationLoader yamlConfigurationLoader = this.loader;
        synchronized (yamlConfigurationLoader) {
            if (this.pendingWrites.get() > 1) {
                this.pendingWrites.decrementAndGet();
            }
            try {
                this.loader.save(this.node);
            }
            catch (ConfigurateException e) {
                EssentialsConfiguration.LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
            finally {
                this.pendingWrites.decrementAndGet();
            }
        }
    }
}

